/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.widgets;

import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.edgemind.ibee.core.able.IResetAble;
import net.edgemind.ibee.core.context.ContextStack;
import net.edgemind.ibee.core.exception.ExceptionUtil;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.core.log.ALogHandler;
import net.edgemind.ibee.core.log.ILogHandler;
import net.edgemind.ibee.core.log.LogEntry;
import net.edgemind.ibee.core.log.LogLevel;
import net.edgemind.ibee.core.monitor.MultiTaskProgressMonitor;
import net.edgemind.ibee.core.monitor.TopLevelMonitor;
import net.edgemind.ibee.swt.core.dialog.IRunnableWithProgress;
import net.edgemind.ibee.swt.core.dialog.IRunnableWithoutError;
import net.edgemind.ibee.swt.core.image.AnimatedGif;
import net.edgemind.ibee.swt.core.image.ImageUtil;
import net.edgemind.ibee.swt.core.util.SwtUtil;
import net.edgemind.ibee.swt.core.widgets.SwtLogFilterWidget;
import net.edgemind.ibee.swt.core.widgets.SwtLogWidget;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class SwtExecutionWidget {
    protected Label lblCurrentTask;
    protected Label lblCurrentSubTask;
    protected boolean canceled = false;
    protected boolean createLauncherHeader = true;
    protected boolean createExportLog = false;
    protected boolean createProgressBar = false;
    protected boolean createLog = true;
    protected boolean printLogDate = false;
    protected Shell shell;
    protected boolean showBusyCursorAtExec = false;
    protected String doneBtnName = "Done";
    protected String cancelBtnName = "Cancel";
    protected SwtLogWidget logWidget;
    private boolean useSimpleLogWidget = false;
    protected ProgressBar progressBar;
    protected Label progressTxt;
    protected boolean running = false;
    protected IRunnableWithProgress runnable;
    protected IProgressMonitor monitor;
    protected ILogHandler logHandler;
    private boolean createWaitingAnimation = false;
    private AnimatedGif waitingAnimation;
    Button btnCancelInfoLine;
    Button exportLogBtn;
    Button btnStart;
    Button btnCancel;
    Button btnExportLog;
    Button btnClearLog;
    List<String> buf = new ArrayList<String>();
    List<LogLevel> bufLevel = new ArrayList<LogLevel>();
    boolean asyncTriggered = false;
    private boolean createTaskInfo = true;
    private Point logWidgetSize = new Point(800, 300);
    protected boolean logSubTasks = true;
    private List<Integer> monitoredLevels = Arrays.asList(1);
    private int nrOfTasks;
    private DateFormat dateFormat;
    private boolean progressUpdateOngoing = false;
    private int progressPercent = -1;

    public boolean getLogSubTasks() {
        return this.logSubTasks;
    }

    public void setLogSubTasks(boolean logSubTasks) {
        this.logSubTasks = logSubTasks;
    }

    public void setCreateExportLog(boolean value) {
        this.createExportLog = value;
    }

    public void setCreateLauncherHeader(boolean value) {
        this.createLauncherHeader = value;
    }

    public void setShowBusyCursorAtExec(boolean value) {
        this.showBusyCursorAtExec = value;
    }

    public void setCreateLog(boolean value) {
        this.createLog = value;
    }

    public void setCreateProgressBar(boolean value) {
        this.createProgressBar = value;
    }

    public void setPrintLogDate(boolean value) {
        this.printLogDate = value;
    }

    public boolean isCreateTaskInfo() {
        return this.createTaskInfo;
    }

    public void setCreateTaskInfo(boolean createTaskInfo) {
        this.createTaskInfo = createTaskInfo;
    }

    public void resetProgress() {
        this.setProgress(0.0);
    }

    public void create(Composite parent, int style) {
        this.shell = parent.getShell();
        this.createPre(parent);
        if (this.createLauncherHeader) {
            this.createLauncher(parent);
        }
        if (this.createTaskInfo) {
            this.createTaskInfo(parent);
        }
        if (this.createLog) {
            this.createLog(parent);
        }
        if (this.createProgressBar) {
            this.createProgressBar(parent);
        }
        this.createPost(parent);
    }

    protected void createPost(Composite parent) {
    }

    protected void createPre(Composite parent) {
    }

    protected boolean launchPre() {
        return true;
    }

    protected boolean launchPost() {
        return true;
    }

    public void setRunnable(IRunnableWithProgress runnable) {
        this.runnable = runnable;
    }

    protected void createLauncher(Composite parent) {
        Composite toolbar = new Composite(parent, 0);
        toolbar.setLayout((Layout)new GridLayout(4, false));
        GridData data = new GridData(768);
        toolbar.setLayoutData((Object)data);
        this.btnStart = this.createLaunchToolbarItem(toolbar);
        this.btnCancel = this.createCancelToolbarItem(toolbar);
        this.btnClearLog = this.createClearLogToolbarItem(toolbar);
        this.btnExportLog = this.createExportLogToolbarItem(toolbar);
        this.changeRunningState(false);
    }

    protected Button createLaunchToolbarItem(Composite toolbar) {
        Button btn = new Button(toolbar, 8);
        btn.setToolTipText("Start");
        btn.setImage(ImageUtil.getBitmapImage("img/play.png", SwtExecutionWidget.class));
        btn.addListener(13, e -> this.execute(this.runnable));
        return btn;
    }

    protected Button createCancelToolbarItem(Composite toolbar) {
        Button btn = new Button(toolbar, 8);
        btn.setToolTipText("Stop Operation");
        btn.setImage(ImageUtil.getBitmapImage("img/terminate.png", SwtExecutionWidget.class));
        btn.addListener(13, e -> {
            if (this.monitor != null) {
                this.monitor.setCanceled(true);
            }
        });
        return btn;
    }

    protected Button createClearLogToolbarItem(Composite toolbar) {
        Button btn = new Button(toolbar, 8);
        btn.setToolTipText("Clear Log");
        btn.setImage(ImageUtil.getImage("img/icon_clear_24x24.png", SwtExecutionWidget.class, 16, 16));
        btn.addListener(13, e -> {
            if (this.logWidget.getBuffer().isEmpty()) {
                return;
            }
            if (SwtUtil.openConfirmDlg(this.shell, "Clear Log", "Are you sure to clear the log?")) {
                this.clearLog();
                if (this.progressBar != null) {
                    this.progressBar.setSelection(0);
                }
            }
        });
        return btn;
    }

    public void clearLog() {
        if (this.logWidget != null) {
            this.logWidget.clearLog();
        }
    }

    protected Button createExportLogToolbarItem(Composite toolbar) {
        Button btn = new Button(toolbar, 8);
        btn.setToolTipText("Export Log");
        btn.setImage(ImageUtil.getImage("img/icon_export_24x24_2.png", SwtExecutionWidget.class, 16, 16));
        btn.addListener(13, e -> {
            if (this.logWidget.getBuffer().isEmpty()) {
                return;
            }
            String file = SwtUtil.promptFilePathSave("Export Log", "", this.shell);
            if (file != null && !file.equals("")) {
                OutputStreamWriter writer = null;
                try {
                    try {
                        writer = new FileWriter(file);
                        writer.write(this.logWidget.getBuffer());
                    }
                    catch (Exception ex) {
                        ExceptionUtil.wrap((Exception)ex);
                        try {
                            writer.close();
                        }
                        catch (Exception ex2) {
                            ExceptionUtil.wrap((Exception)ex2);
                        }
                    }
                }
                finally {
                    try {
                        writer.close();
                    }
                    catch (Exception ex) {
                        ExceptionUtil.wrap((Exception)ex);
                    }
                }
            }
        });
        return btn;
    }

    public void setLogSize(Point size) {
        this.logWidgetSize = size;
    }

    private void createLog(Composite parent) {
        Composite component = new Composite(parent, 0);
        component.setLayout((Layout)new GridLayout());
        GridData data = new GridData(1808);
        if (this.logWidgetSize.x > 0) {
            data.widthHint = this.logWidgetSize.x;
        }
        if (this.logWidgetSize.y > 0) {
            data.heightHint = this.logWidgetSize.y;
        }
        component.setLayoutData((Object)data);
        SwtLogWidget swtLogWidget = this.logWidget = this.useSimpleLogWidget ? new SwtLogWidget() : new SwtLogFilterWidget();
        if (this.dateFormat != null) {
            this.logWidget.setDateFormat(this.dateFormat);
        }
        this.logWidget.setAutoScroll(true);
        this.logWidget.create(component);
    }

    private void createTaskInfo(Composite parent) {
        Composite composite = new Composite(parent, 0);
        if (this.createExportLog) {
            composite.setLayout((Layout)new GridLayout(4, false));
        } else {
            composite.setLayout((Layout)new GridLayout(3, false));
        }
        GridData data = new GridData(768);
        composite.setLayoutData((Object)data);
        if (this.createWaitingAnimation) {
            this.createWaitingAnimation(composite);
        } else {
            this.createWorkingImage(composite);
        }
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        data = new GridData(768);
        composite2.setLayoutData((Object)data);
        this.lblCurrentTask = new Label(composite2, 0);
        data = new GridData(768);
        this.lblCurrentTask.setText("");
        this.lblCurrentTask.setLayoutData((Object)data);
        this.lblCurrentSubTask = new Label(composite2, 0);
        data = new GridData(768);
        this.lblCurrentSubTask.setText("");
        this.lblCurrentSubTask.setLayoutData((Object)data);
        this.btnCancelInfoLine = new Button(composite, 0);
        this.btnCancelInfoLine.setImage(ImageUtil.getBitmapImage("img/terminate.png", SwtExecutionWidget.class));
        this.btnCancelInfoLine.setToolTipText("Cancel");
        this.btnCancelInfoLine.addListener(13, e -> {
            if (this.isRunning()) {
                this.cancel();
            }
        });
        this.btnCancelInfoLine.setVisible(false);
        if (this.createExportLog) {
            this.exportLogBtn = this.createExportLogToolbarItem(composite);
            this.exportLogBtn.setVisible(false);
        }
    }

    private void createWorkingImage(Composite composite) {
        Label imageLabel = new Label(composite, 0);
        Image image = composite.getDisplay().getSystemImage(16);
        image.setBackground(imageLabel.getBackground());
        imageLabel.setImage(image);
        GridData data = new GridData();
        imageLabel.setLayoutData((Object)data);
    }

    private void createWaitingAnimation(Composite parent) {
        this.waitingAnimation = new AnimatedGif("/img/waiting.gif", SwtExecutionWidget.class, parent);
    }

    protected void createProgressBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        GridData data = new GridData(768);
        composite.setLayoutData((Object)data);
        new Label(composite, 0).setText("Progress: ");
        this.progressBar = new ProgressBar(composite, 65536);
        data = new GridData(768);
        this.progressBar.setLayoutData((Object)data);
        this.progressBar.setMaximum(100);
        this.progressBar.setMaximum(0);
        this.progressTxt = new Label(composite, 0);
        this.progressTxt.setText(String.format("%10.2f%%", 0.0));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.progressBar.setLayoutData((Object)gd);
    }

    public final void execute(IRunnableWithProgress runnable) {
        if (this.isRunning()) {
            return;
        }
        if (!this.launchPre()) {
            return;
        }
        this.clearLog();
        this.changeRunningState(true);
        Thread t = new Thread(() -> {
            try {
                this.performInternal(runnable);
                if (!this.launchPost()) {
                    return;
                }
            }
            finally {
                this.changeRunningState(false);
            }
        });
        t.start();
    }

    private void changeRunningState(final boolean running) {
        this.running = running;
        boolean bl = this.canceled = !running;
        if (this.waitingAnimation != null) {
            if (running) {
                this.waitingAnimation.startAnimation();
            } else {
                this.waitingAnimation.stopAnimation();
            }
        }
        SwtUtil.runInGui(new IRunnableWithoutError(){

            @Override
            public void run() {
                SwtExecutionWidget.this.execSync(() -> {
                    if (SwtExecutionWidget.this.btnStart != null) {
                        SwtExecutionWidget.this.btnStart.setEnabled(!running);
                    }
                    if (SwtExecutionWidget.this.btnCancel != null) {
                        SwtExecutionWidget.this.btnCancel.setEnabled(running);
                    }
                    if (SwtExecutionWidget.this.btnCancelInfoLine != null) {
                        SwtExecutionWidget.this.btnCancelInfoLine.setEnabled(running);
                    }
                    if (SwtExecutionWidget.this.exportLogBtn != null) {
                        SwtExecutionWidget.this.exportLogBtn.setEnabled(!running);
                    }
                    if (running) {
                        if (SwtExecutionWidget.this.progressBar != null) {
                            SwtExecutionWidget.this.progressBar.setSelection(0);
                        }
                        if (SwtExecutionWidget.this.showBusyCursorAtExec) {
                            Cursor cursor = SwtExecutionWidget.this.shell.getDisplay().getSystemCursor(1);
                            SwtExecutionWidget.this.shell.setCursor(cursor);
                        }
                    } else {
                        if (SwtExecutionWidget.this.showBusyCursorAtExec) {
                            Cursor cursor = SwtExecutionWidget.this.shell.getDisplay().getSystemCursor(0);
                            SwtExecutionWidget.this.shell.setCursor(cursor);
                        }
                        if (SwtExecutionWidget.this.progressBar != null && !SwtExecutionWidget.this.progressBar.isDisposed()) {
                            SwtExecutionWidget.this.progressBar.setState(0);
                        }
                    }
                });
            }
        }, this.shell);
    }

    private void performInternal(IRunnableWithProgress runnable) throws IbeeException {
        block10: {
            if (runnable == null) {
                return;
            }
            this.monitor = this.getMonitor(true, true);
            this.setTaskName("");
            this.setSubTaskName("");
            this.setProgress(0.0);
            try {
                try {
                    ContextStack.appendContext((String)"exec");
                    ContextStack.setCurrentContextValue(ILogHandler.class, (Object)this.getLogHandler());
                    ContextStack.setCurrentContextValue(IProgressMonitor.class, (Object)this.monitor);
                    if (this.btnCancelInfoLine != null) {
                        this.execAsync(() -> this.btnCancelInfoLine.setVisible(true));
                    }
                    runnable.run(this.monitor);
                }
                catch (Exception e) {
                    this.monitor.setCanceled(true);
                    ExceptionUtil.wrap((Exception)e);
                    if (this.btnCancelInfoLine != null) {
                        this.execAsync(() -> this.btnCancelInfoLine.setVisible(false));
                    }
                    ContextStack.popContext();
                    break block10;
                }
            }
            catch (Throwable throwable) {
                if (this.btnCancelInfoLine != null) {
                    this.execAsync(() -> this.btnCancelInfoLine.setVisible(false));
                }
                ContextStack.popContext();
                throw throwable;
            }
            if (this.btnCancelInfoLine != null) {
                this.execAsync(() -> this.btnCancelInfoLine.setVisible(false));
            }
            ContextStack.popContext();
        }
    }

    public IProgressMonitor getMonitor(boolean create, boolean reset) {
        if (create && this.monitor == null) {
            this.monitor = this.createMonitor();
        }
        if (reset && this.monitor instanceof IResetAble) {
            ((IResetAble)this.monitor).reset();
        }
        return this.monitor;
    }

    protected IProgressMonitor createMonitor() {
        TopLevelMonitor monitor = new TopLevelMonitor(this.monitoredLevels);
        monitor.setProgressListener(new TopLevelMonitor.Listener(){

            public void setTaskName(String name, int level) {
                SwtExecutionWidget.this.setTaskName(name);
            }

            public void setProgress(double progress, int level) {
                SwtExecutionWidget.this.setProgress(progress);
            }

            public void setSubTaskName(String name, int level) {
                SwtExecutionWidget.this.setSubTaskName(name);
            }
        });
        return new MultiTaskProgressMonitor((IProgressMonitor)monitor);
    }

    private void setTaskName(String name) {
        if (this.lblCurrentSubTask != null) {
            this.execAsync(() -> this.lblCurrentTask.setText(name));
        }
    }

    private void setSubTaskName(String name) {
        if (this.lblCurrentSubTask != null) {
            this.execAsync(() -> this.lblCurrentSubTask.setText(name));
        }
    }

    private void setProgress(double value) {
        if (this.progressBar == null) {
            return;
        }
        int percent = (int)(value * 100.0);
        if (percent == this.progressPercent) {
            return;
        }
        this.progressPercent = percent;
        if (this.progressUpdateOngoing) {
            return;
        }
        this.progressUpdateOngoing = true;
        this.execAsync(() -> {
            this.progressTxt.setText(String.format("%d%%", this.progressPercent));
            this.progressBar.setSelection(this.progressPercent);
            this.progressUpdateOngoing = false;
            this.progressTxt.requestLayout();
        });
    }

    private void execSync(Runnable run) {
        if (this.shell.isDisposed()) {
            return;
        }
        this.shell.getDisplay().syncExec(run);
    }

    private void execAsync(Runnable run) {
        if (this.shell.isDisposed()) {
            return;
        }
        this.shell.getDisplay().asyncExec(() -> {
            if (!this.shell.isDisposed()) {
                run.run();
            }
        });
    }

    public void log(String msg) {
        this.log(msg, LogLevel.INFO);
    }

    public ILogHandler getLogHandler() {
        if (this.logHandler == null) {
            this.logHandler = this.createLogHandler();
        }
        return this.logHandler;
    }

    protected ILogHandler createLogHandler() {
        ALogHandler logHandler = new ALogHandler(){

            public void log(String msg, LogLevel level) {
                SwtExecutionWidget.this.log(msg, level);
            }
        };
        return logHandler;
    }

    public void log(String msg, LogLevel level) {
        if (this.logWidget == null) {
            return;
        }
        LogEntry entry = new LogEntry(msg, level);
        this.logWidget.append(entry);
    }

    public Map<LogLevel, Integer> getStats() {
        SwtLogWidget swtLogWidget = this.logWidget;
        if (swtLogWidget instanceof SwtLogFilterWidget) {
            SwtLogFilterWidget logFilterWidget = (SwtLogFilterWidget)swtLogWidget;
            return logFilterWidget.getStats();
        }
        return new HashMap<LogLevel, Integer>();
    }

    public boolean done() {
        if (this.running) {
            SwtUtil.showInfo("Info", "Task is still running", this.shell);
            return false;
        }
        return true;
    }

    public boolean cancel() {
        if (this.running && this.monitor != null) {
            this.monitor.setCanceled(true);
        }
        return false;
    }

    public void setDoneButtonName(String name) {
        this.doneBtnName = name;
    }

    public void setCancelButtonName(String name) {
        this.cancelBtnName = name;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isCancelled() {
        if (this.monitor != null) {
            return this.monitor.isCanceled();
        }
        return false;
    }

    public boolean isDone() {
        return !this.running;
    }

    public void setNrOfTasks(int nr) {
        this.nrOfTasks = nr;
    }

    public void setDateFormat(DateFormat format) {
        this.dateFormat = format;
        if (this.logWidget != null) {
            this.logWidget.setDateFormat(format);
        }
    }

    public List<Integer> getMonitoredLevels() {
        return this.monitoredLevels;
    }

    public void setMonitoredLevels(List<Integer> monitoredLevels) {
        this.monitoredLevels = monitoredLevels;
    }

    public void setMonitorOnlyTopLevel(boolean value) {
        this.monitoredLevels = Arrays.asList(1);
    }

    public void setShowWaitingAnimation(boolean value) {
        this.createWaitingAnimation = value;
    }

    public boolean isUseSimpleLogWidget() {
        return this.useSimpleLogWidget;
    }

    public void setUseSimpleLogWidget(boolean useSimpleLogWidget) {
        this.useSimpleLogWidget = useSimpleLogWidget;
    }
}

