/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.widgets;

import java.awt.Desktop;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import net.edgemind.ibee.core.diagram.Color;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.core.log.LogEntry;
import net.edgemind.ibee.core.log.LogLevel;
import net.edgemind.ibee.swt.core.image.ImageUtil;
import net.edgemind.ibee.swt.core.util.SwtUtil;
import net.edgemind.ibee.swt.core.widgets.SwtLogWidget;
import net.edgemind.ibee.util.string.PatternUtil;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SwtLogFilterWidget
extends SwtLogWidget {
    private Map<LogLevel, Integer> stat = new HashMap<LogLevel, Integer>();
    private Map<LogLevel, Label> statusTexts;
    private Map<LogLevel, Color> statusColors;
    private LinkedList<LogEntry> allLogs = new LinkedList();
    private LogLevel logLevelFilter;
    private String logMessagePatternFilter;
    private Combo logFilterCombo;
    private Map<String, LogLevel> logLevels;
    private Map<LogLevel, String> logLevelsInv;
    private boolean updateStatusBarTriggered;

    @Override
    public void create(Composite component) {
        this.createLogFilter(component);
        super.create(component);
        this.createLogStatus(component);
    }

    private void createLogFilter(Composite component) {
        GridLayout layout = new GridLayout(6, false);
        layout.horizontalSpacing = 5;
        Composite filterComposite = new Composite(component, 0);
        filterComposite.setLayout((Layout)layout);
        filterComposite.setLayoutData((Object)new GridData(768));
        Image img = ImageUtil.getImage("/img/icon_filter16x16.png", SwtLogFilterWidget.class);
        Label filterText = new Label(filterComposite, 0);
        filterText.setImage(img);
        Label label = new Label(filterComposite, 0);
        label.setText("Level:");
        GridData data = new GridData(1);
        label.setLayoutData((Object)data);
        this.logFilterCombo = new Combo(filterComposite, 12);
        data = new GridData(1);
        this.logFilterCombo.setLayoutData((Object)data);
        this.initFilteredLogLevels();
        for (String logLevelString : this.logLevels.keySet()) {
            this.logFilterCombo.add(logLevelString);
        }
        this.logFilterCombo.select(0);
        this.logFilterCombo.addListener(13, e -> {
            int index = this.logFilterCombo.getSelectionIndex();
            if (index != -1) {
                LogLevel selectedLogLevel = this.logLevels.get(this.logFilterCombo.getItem(index));
                this.setLogLevelFilter(selectedLogLevel);
                this.refresh();
            }
        });
        label = new Label(filterComposite, 0);
        label.setText("Message:");
        data = new GridData(1);
        label.setLayoutData((Object)data);
        Text text = new Text(filterComposite, 2048);
        data = new GridData(768);
        text.setLayoutData((Object)data);
        text.addListener(24, e -> {
            String pattern = text.getText();
            if (pattern != null) {
                this.setMessagePatternFilter(pattern);
                this.refresh();
            }
        });
        img = ImageUtil.getImage("/img/icon_export16x16.png", SwtLogFilterWidget.class);
        Button export = new Button(filterComposite, 0);
        export.setImage(img);
        export.addListener(13, e -> this.exportLog());
    }

    private void createLogStatus(Composite component) {
        GridLayout layout = new GridLayout(6, false);
        layout.horizontalSpacing = 5;
        Composite filterComposite = new Composite(component, 0);
        filterComposite.setLayout((Layout)layout);
        filterComposite.setLayoutData((Object)new GridData(768));
        this.initStatusColors();
        this.statusTexts = new HashMap<LogLevel, Label>();
        for (String logLevelString : this.logLevels.keySet()) {
            LogLevel level = this.logLevels.get(logLevelString);
            Label label = new Label(filterComposite, 0);
            label.setForeground(SwtUtil.toSwtColor(this.statusColors.get(level)));
            GridData data = new GridData(768);
            label.setLayoutData((Object)data);
            this.statusTexts.put(level, label);
        }
        this.updateStatusBar();
    }

    private void initStatusColors() {
        this.statusColors = new HashMap<LogLevel, Color>();
        this.statusColors.put(LogLevel.ERROR, Color.RED);
        this.statusColors.put(LogLevel.WARNING, Color.EMORANGE);
    }

    private void initFilteredLogLevels() {
        this.logLevels = new LinkedHashMap<String, LogLevel>();
        this.logLevels.put("ALL", null);
        this.logLevels.put("ERROR", LogLevel.ERROR);
        this.logLevels.put("WARNING", LogLevel.WARNING);
        this.logLevels.put("INFO", LogLevel.INFO);
        this.logLevels.put("DEBUG", LogLevel.DEBUG);
        this.logLevelsInv = new LinkedHashMap<LogLevel, String>();
        for (String logLevelString : this.logLevels.keySet()) {
            LogLevel level = this.logLevels.get(logLevelString);
            this.logLevelsInv.put(level, logLevelString);
        }
    }

    private void setLogLevelFilter(LogLevel logLevel) {
        this.logLevelFilter = logLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearLog() {
        super.clearLog();
        Object object = this.stat;
        synchronized (object) {
            this.stat.clear();
        }
        object = this.allLogs;
        synchronized (object) {
            this.allLogs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        super.clearLog();
        LinkedList<LogEntry> linkedList = this.allLogs;
        synchronized (linkedList) {
            for (LogEntry entry : this.allLogs) {
                if (!this.filter(entry)) continue;
                super.append(entry);
            }
        }
    }

    @Override
    public void append(String msg, LogLevel level) {
        this.append(new LogEntry(msg, level));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(LogEntry entry) {
        LinkedList<LogEntry> linkedList = this.allLogs;
        synchronized (linkedList) {
            this.allLogs.add(entry);
        }
        if (this.filter(entry)) {
            super.append(entry);
        }
        this.incStat(null);
        this.incStat(entry.getLevel());
        this.updateStatusBarAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incStat(LogLevel logLevel) {
        Map<LogLevel, Integer> map = this.stat;
        synchronized (map) {
            Integer cnt = this.stat.get(logLevel);
            if (cnt == null) {
                cnt = 0;
            }
            cnt = cnt + 1;
            this.stat.put(logLevel, cnt);
        }
    }

    private void updateStatusBarAsync() {
        if (this.updateStatusBarTriggered) {
            return;
        }
        if (this.logFilterCombo.isDisposed()) {
            return;
        }
        this.updateStatusBarTriggered = true;
        this.logFilterCombo.getDisplay().asyncExec(() -> {
            this.updateStatusBarTriggered = false;
            this.updateStatusBar();
        });
    }

    private void updateStatusBar() {
        for (LogLevel level : this.logLevelsInv.keySet()) {
            this.updateStatusBar(level);
        }
    }

    private void updateStatusBarAsync(LogLevel level) {
        this.logFilterCombo.getDisplay().asyncExec(() -> this.updateStatusBar(level));
    }

    private void updateStatusBar(LogLevel level) {
        Label label = this.statusTexts.get(level);
        if (label == null || label.isDisposed()) {
            return;
        }
        Integer cnt = this.stat.get(level);
        if (cnt == null) {
            cnt = 0;
        }
        String category = this.logLevelsInv.get(level);
        label.setText(category + ": " + String.valueOf(cnt));
    }

    private void exportLog() {
        String savePath;
        Object fileName = "all";
        int index = this.logFilterCombo.getSelectionIndex();
        if (index != -1) {
            fileName = this.logFilterCombo.getItem(index).toLowerCase();
        }
        if ((savePath = SwtUtil.promptFilePathSave("Export Log", (String)(fileName = (String)fileName + ".csv"), this.getShell(), true, "csv", "CSV Format")) != null) {
            this.doWriteLog(savePath);
            File file = new File(savePath);
            if (file.exists() && Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.open(file);
                }
                catch (IOException e) {
                    throw new IbeeException((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doWriteLog(String savePath) {
        CSVFormat csvFormat = CSVFormat.Builder.create().setHeader(new String[]{"LogLevel", "Date", "Message"}).setSkipHeaderRecord(false).build();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                FileWriter writer = new FileWriter(savePath, Charset.forName("UTF-8"));
                try {
                    try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)writer, csvFormat);){
                        LinkedList<LogEntry> linkedList = this.allLogs;
                        synchronized (linkedList) {
                            for (LogEntry next : new ArrayList<LogEntry>(this.allLogs)) {
                                if (!this.filter(next)) continue;
                                csvPrinter.printRecord(new Object[]{next.getLevel().toString(), this.getDateAsString(next), next.getMessage()});
                            }
                        }
                    }
                    if (writer == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (writer == null) throw throwable;
                    writer.close();
                    throw throwable;
                }
                writer.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IbeeException((Throwable)e);
        }
    }

    private void setMessagePatternFilter(String messagePattern) {
        this.logMessagePatternFilter = messagePattern;
    }

    private boolean filter(LogEntry entry) {
        if (this.logLevelFilter != null && entry.getLevel() != this.logLevelFilter) {
            return false;
        }
        return this.logMessagePatternFilter == null || this.logMessagePatternFilter.isEmpty() || this.logMessagePatternFilter == null || PatternUtil.wildCardMatch((String)entry.getMessage(), (String)("*" + this.logMessagePatternFilter));
    }

    public Map<LogLevel, Integer> getStats() {
        return this.stat;
    }
}

