/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.widgets;

import fr.edf.ibee.swt.core.table.ITableContentProvider;
import fr.edf.ibee.swt.core.table.LazyTableViewer;
import net.edgemind.ibee.swt.core.widgets.ASwtTreeTableWidget;
import net.edgemind.ibee.ui.column.Column;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class SwtTableWidget<T>
extends ASwtTreeTableWidget<T> {
    private LazyTableViewer tableViewer;
    private TableColumnLayout layout;
    private ITableContentProvider contentProvider;
    private long maxRowsToShow = -1L;

    public long getMaxRowsToShow() {
        return this.maxRowsToShow;
    }

    public void setMaxRowsToShow(long maxRowsToShow) {
        this.maxRowsToShow = maxRowsToShow;
    }

    public ITableContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public void setContentProvider(ITableContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public Table getTable() {
        return this.tableViewer.getTable();
    }

    public TableViewer getViewer() {
        return this.tableViewer;
    }

    @Override
    protected Viewer createViewer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        this.layout = new TableColumnLayout();
        composite.setLayout((Layout)this.layout);
        this.tableViewer = new LazyTableViewer(composite, 66050);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        this.tableViewer.setMaxRowsToShow(this.maxRowsToShow);
        return this.tableViewer;
    }

    @Override
    protected void createColumn(Column<T> column) {
        TableViewerColumn viewerCol = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        viewerCol.setLabelProvider(this.createLabelProvider(column));
        viewerCol.getColumn().setText(column.getTitle());
        viewerCol.getColumn().setWidth(400);
        viewerCol.getColumn().setMoveable(true);
        int nextColIndex = super.getNextColumnIndex();
        viewerCol.getColumn().addListener(13, e -> this.sort(nextColIndex));
        int weight = column.getMinimumWidth();
        if (weight == 0) {
            weight = 100;
        }
        this.layout.setColumnData((Widget)viewerCol.getColumn(), (ColumnLayoutData)new ColumnWeightData(weight));
    }

    @Override
    protected void clearColumns() {
        this.resetColumnIndex();
        TableColumn[] tableColumnArray = this.tableViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.dispose();
            ++n2;
        }
        Composite composite = this.tableViewer.getTable().getParent();
        this.layout = new TableColumnLayout();
        composite.setLayout((Layout)this.layout);
    }

    @Override
    protected void createContentProvider() {
        this.tableViewer.setContentProvider(this.contentProvider);
        this.createSelectionListener();
        this.createDblClickListener();
        this.tableViewer.getContentProvider().setFilter((Object object) -> this.getFilter() == null || this.getFilter().accept(object));
        this.tableViewer.setInput(this.tableViewer.getTable());
    }

    public void refresh() {
        this.refreshView(true);
    }

    protected void refreshView(boolean full) {
        if (full) {
            this.tableViewer.getContentProvider().clearFull();
        } else {
            this.tableViewer.getContentProvider().clearFilter();
        }
        this.tableViewer.refresh();
    }

    @Override
    public void sort(int col) {
        super.sort(col);
        this.tableViewer.getTable().setSortColumn(this.tableViewer.getTable().getColumns()[this.getSortColumn() - 1]);
        this.tableViewer.getTable().setSortDirection(this.getSortDirection() == 0 ? 0 : (this.getSortDirection() == 1 ? 128 : 1024));
        this.refreshView(true);
    }
}

