/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.widgets;

import fr.edf.ibee.swt.core.table.ITreeContentProvider;
import fr.edf.ibee.swt.core.table.LazyTreeViewer;
import net.edgemind.ibee.swt.core.widgets.ASwtTreeTableWidget;
import net.edgemind.ibee.ui.column.Column;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public class SwtTreeWidget<T>
extends ASwtTreeTableWidget<T> {
    private LazyTreeViewer treeViewer;
    private TreeColumnLayout layout;
    private ITreeContentProvider contentProvider;

    public ITreeContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public void setContentProvider(ITreeContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public Tree getTree() {
        return this.treeViewer.getTree();
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    @Override
    protected Viewer createViewer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        this.layout = new TreeColumnLayout();
        composite.setLayout((Layout)this.layout);
        this.treeViewer = new LazyTreeViewer(composite, 66050);
        Tree tree = this.treeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        tree.setLayoutData((Object)new GridData(1808));
        return this.treeViewer;
    }

    @Override
    protected void createColumn(Column<T> column) {
        TreeViewerColumn viewerCol = new TreeViewerColumn((TreeViewer)this.treeViewer, 0);
        viewerCol.setLabelProvider(this.createLabelProvider(column));
        viewerCol.getColumn().setText(column.getTitle());
        viewerCol.getColumn().setWidth(400);
        viewerCol.getColumn().setMoveable(true);
        int nextColIndex = super.getNextColumnIndex();
        viewerCol.getColumn().addListener(13, e -> this.sort(nextColIndex));
        int weight = column.getMinimumWidth();
        if (weight == 0) {
            weight = 100;
        }
        this.layout.setColumnData((Widget)viewerCol.getColumn(), (ColumnLayoutData)new ColumnWeightData(weight));
    }

    @Override
    protected void clearColumns() {
        this.resetColumnIndex();
        this.treeViewer.getTree().clearAll(true);
        TreeColumn[] treeColumnArray = this.treeViewer.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn col = treeColumnArray[n2];
            col.dispose();
            ++n2;
        }
        Composite composite = this.treeViewer.getTree().getParent();
        this.layout = new TreeColumnLayout();
        composite.setLayout((Layout)this.layout);
    }

    @Override
    protected void createContentProvider() {
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.createSelectionListener();
        this.createDblClickListener();
        this.treeViewer.getContentProvider().setFilter((Object object) -> this.getFilter() == null || this.getFilter().accept(object));
        this.treeViewer.setSelection((ISelection)new StructuredSelection());
        this.treeViewer.getTree().setRedraw(false);
        this.treeViewer.setInput(this.treeViewer.getTree());
        this.treeViewer.getTree().setRedraw(true);
    }

    public void refresh() {
        this.refreshView(true);
    }

    protected void refreshView(boolean full) {
        if (full) {
            this.treeViewer.getContentProvider().clearFull();
        } else {
            this.treeViewer.getContentProvider().clearFilter();
        }
        this.treeViewer.setSelection((ISelection)new StructuredSelection());
        this.treeViewer.refresh();
    }

    @Override
    public void sort(int col) {
        super.sort(col);
        this.treeViewer.getTree().setSortColumn(this.treeViewer.getTree().getColumns()[this.getSortColumn() - 1]);
        this.treeViewer.getTree().setSortDirection(this.getSortDirection() == 0 ? 0 : (this.getSortDirection() == 1 ? 128 : 1024));
        this.refreshView(true);
    }
}

