/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.extra.dialogs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.core.property.AProperty;
import net.edgemind.ibee.extra.dialogs.DlgSelectSomething;
import net.edgemind.ibee.swt.core.dialog.AExecutionDialog;
import net.edgemind.ibee.swt.core.field.FieldData;
import net.edgemind.ibee.swt.core.field.FileField;
import net.edgemind.ibee.swt.core.field.SwtFieldCreator;
import net.edgemind.ibee.swt.core.util.SwtUtil;
import net.edgemind.ibee.swt.core.widgets.SwtExecutionWidget;
import net.edgemind.ibee.util.file.FileUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class AExecutionFolderDialog
extends AExecutionDialog {
    protected FileField fFolderInput;
    private static String lastFolderInput;
    private List<File> outputFiles;
    private boolean recursive = true;

    public AExecutionFolderDialog(Shell parent, String title) {
        super(parent, title);
        this.batchLog = true;
    }

    public AExecutionFolderDialog(Shell parent, int style, String title) {
        super(parent, style, title);
        this.batchLog = true;
        this.creator = new SwtFieldCreator();
        this.creator.setShowDescription(true);
    }

    public void createConfigSection(Composite parent) {
        super.initSize(0.7, 0.7);
        Group container1 = new Group(parent, 0);
        container1.setBackgroundMode(1);
        container1.setLayout((Layout)SwtUtil.createLayout((int)3, (boolean)false, (int)5));
        container1.setLayoutData((Object)new GridData(768));
        this.createGenericFields((Composite)container1);
        this.createSpecificFields((Composite)container1);
    }

    private void createGenericFields(Composite parent) {
        this.createFolderInputField(parent);
    }

    protected abstract void createSpecificFields(Composite var1);

    private void createFolderInputField(Composite parent) {
        this.fFolderInput = new FileField("input", "Input Folder ", lastFolderInput, true, false);
        this.fFolderInput.setEditable(true);
        this.addFieldNotEmptyChecker((FieldData)this.fFolderInput, f -> true);
        this.creator.createField((FieldData)this.fFolderInput, parent);
    }

    protected boolean launchPre() {
        if (this.fFolderInput.getFile().isDirectory()) {
            String[] inputExtensions = this.getInputFileExtensions();
            ArrayList<File> inputFiles = new ArrayList();
            try {
                inputFiles = FileUtil.findFiles((File)(this.fFolderInput.getFile() != null ? this.fFolderInput.getFile() : new File("")), (boolean)this.recursive, file -> Arrays.asList(inputExtensions).stream().anyMatch(ext -> FileUtil.hasExtension((File)file, (String)ext)));
            }
            catch (IOException e1) {
                throw new IbeeException((Throwable)e1);
            }
            this.outputFiles = this.selectFiles(inputFiles, this.fFolderInput.getFile() != null ? this.fFolderInput.getFile().getAbsolutePath() : "");
            return this.outputFiles.size() > 0;
        }
        return true;
    }

    private List<File> selectFiles(List<File> files, final String dirPath) {
        DlgSelectSomething dlgSomething = new DlgSelectSomething(this.shell, "Select List of Files");
        dlgSomething.setElements(files);
        dlgSomething.setDoneButtonName("Execute");
        dlgSomething.setFields(Arrays.asList(new AProperty<String, File>("File"){

            public String getValue(File file) {
                return FileUtil.getRelativePath((String)file.getAbsolutePath(), (String)dirPath);
            }

            public String checkValue(File file) {
                return null;
            }

            public int compareTo(String v1, String v2) {
                return 0;
            }

            public Object getEditValue(File file) {
                return null;
            }

            public String checkEditValue(File file, Object value) {
                return null;
            }

            public boolean setEditValue(File file, Object value) {
                return false;
            }

            public String toString(String value) {
                return value;
            }
        }));
        dlgSomething.open();
        if (!dlgSomething.isValid()) {
            return new ArrayList<File>();
        }
        return dlgSomething.getSelectedElements();
    }

    public void perform(SwtExecutionWidget exec, IProgressMonitor progress) {
        this.fillConfiguration();
        this.startConversion(exec, progress, this.outputFiles);
    }

    protected abstract void startConversion(SwtExecutionWidget var1, IProgressMonitor var2, List<File> var3);

    protected abstract String[] getInputFileExtensions();

    protected void fillConfiguration() {
        if (this.fFolderInput != null) {
            lastFolderInput = (String)this.fFolderInput.getValue();
        }
    }
}

