/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.extra.dialogs;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.edgemind.ibee.swt.core.dialog.ADialog;
import net.edgemind.ibee.swt.core.field.FieldData;
import net.edgemind.ibee.swt.core.field.SwtFieldCreator;
import net.edgemind.ibee.swt.core.util.SwtUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class DlgConfigureMore
extends ADialog {
    Map<String, SwtFieldCreator> mFieldCreator = new HashMap<String, SwtFieldCreator>();
    Map<String, List<FieldData<?>>> mFields;
    TabFolder tabFolder;

    public DlgConfigureMore(String title, Shell parent, Map<String, List<FieldData<?>>> fields) {
        this(title, parent, fields, 67696);
    }

    public DlgConfigureMore(String title, Shell parent, Map<String, List<FieldData<?>>> fields, int style) {
        super(parent, style, title);
        this.mFields = fields;
    }

    public void createContents(Composite parent) {
        this.tabFolder = new TabFolder(parent, 0);
        for (String key : this.mFields.keySet()) {
            TabItem item = new TabItem(this.tabFolder, 0);
            item.setText(key);
            Composite composite = new Composite((Composite)this.tabFolder, 0);
            GridData gridData = new GridData(1808);
            composite.setLayoutData((Object)gridData);
            composite.setLayout((Layout)new GridLayout(2, false));
            SwtFieldCreator creator = new SwtFieldCreator();
            this.mFieldCreator.put(key, creator);
            this.createFields(creator, composite, this.mFields.get(key));
            item.setControl((Control)composite);
        }
        this.tabFolder.setSelection(0);
        this.createCtrl(parent);
        this.shell.pack();
    }

    public String getSelectedTab() {
        return this.tabFolder.getItem(this.tabFolder.getSelectionIndex()).getText();
    }

    public void createFields(SwtFieldCreator creator, Composite parent, List<FieldData<?>> fields) {
        creator.setMinWidth(300);
        for (FieldData<?> field : fields) {
            creator.createField(field, parent);
        }
    }

    public boolean getIsChecked(String categorie, String key) {
        return this.mFieldCreator.get(categorie).getIsChecked(key);
    }

    public String getStringValue(String key) {
        return this.getValue(key, String.class);
    }

    public <T> T getValue(String key, Class<T> clazz) {
        Object obj;
        FieldData<?> field = this.getField(key);
        if (field != null && (obj = field.getValue()) != null && clazz.isAssignableFrom(obj.getClass())) {
            return (T)obj;
        }
        return null;
    }

    public FieldData<?> getField(String fieldName) {
        for (SwtFieldCreator creator : this.mFieldCreator.values()) {
            FieldData field = creator.getField(fieldName);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    public boolean prepareDone() {
        String msg = this.getErrorMsg();
        if (msg != null) {
            SwtUtil.showInfo((String)"Invalid Configuration", (String)msg, (Shell)this.shell);
            return false;
        }
        return true;
    }

    public String getErrorMsg() {
        for (SwtFieldCreator creator : this.mFieldCreator.values()) {
            String err = creator.getErrorMsg();
            if (err == null) continue;
            return err;
        }
        return null;
    }
}

