/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.extra.dialogs;

import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.swt.core.dialog.ADialog;
import net.edgemind.ibee.swt.core.field.FieldData;
import net.edgemind.ibee.swt.core.field.SwtFieldCreator;
import net.edgemind.ibee.swt.core.util.SwtUtil;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DlgConfigureSomething
extends ADialog {
    private SwtFieldCreator mFieldCreator = new SwtFieldCreator();
    private List<FieldData<?>> mFields = new ArrayList();
    private boolean printDefaultValue = true;
    private boolean printUnit = true;
    private boolean showDescription = false;
    public static int defaultWidth = 800;
    public static int defaultHeight = -1;
    private String title = null;

    public DlgConfigureSomething setShowDescription(boolean value) {
        this.showDescription = value;
        return this;
    }

    public DlgConfigureSomething setPrintUnit(boolean value) {
        this.printUnit = value;
        return this;
    }

    public DlgConfigureSomething setPrintDefaultValue(boolean value) {
        this.printDefaultValue = value;
        return this;
    }

    public void setSize(Rectangle size) {
        this.mSize = size;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static void setDefaultWidth(int defaultWidth) {
        DlgConfigureSomething.defaultWidth = defaultWidth;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static void setDefaultHeight(int defaultHeight) {
        DlgConfigureSomething.defaultHeight = defaultHeight;
    }

    public DlgConfigureSomething(String title, Shell parent) {
        this(title, parent, null);
    }

    public DlgConfigureSomething(String title, Shell parent, List<FieldData<?>> fields) {
        super(parent, 67696, title);
        if (fields != null) {
            this.mFields = fields;
        }
        super.setBlocking(true);
        super.initSize(new Point(defaultWidth, defaultHeight));
    }

    public void createContents(Composite parent) {
        if (this.title != null) {
            Label labelHeader = new Label(parent, 0);
            labelHeader.setText(this.title);
        }
        this.createFields(parent);
        this.createCtrl(parent);
        this.getShell().addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    DlgConfigureSomething.this.done();
                }
            }
        });
    }

    public boolean prepareDone() {
        String msg = this.getErrorMsg();
        if (msg != null) {
            SwtUtil.showInfo((String)"Invalid Configuration", (String)msg, (Shell)this.shell);
            return false;
        }
        return true;
    }

    public void createFields(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        sc.setLayoutData((Object)new GridData(1808));
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        this.mFieldCreator.setMinWidth(300);
        this.mFieldCreator.setPrintDefaultValue(this.printDefaultValue);
        this.mFieldCreator.setPrintUnit(this.printUnit);
        this.mFieldCreator.setShowDescription(this.showDescription);
        Composite composite = new Composite((Composite)sc, 0);
        composite.setBackgroundMode(2);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(this.mFieldCreator.getRequiredColumns(), false));
        for (FieldData<?> field : this.mFields) {
            this.mFieldCreator.createField(field, composite);
        }
        Point p = composite.computeSize(-1, -1);
        sc.setMinSize(-1, p.y);
        sc.setContent((Control)composite);
    }

    public <T> FieldData<T> getField(String name) {
        for (FieldData<?> field : this.mFields) {
            if (!field.getKey().equals(name)) continue;
            return field;
        }
        return null;
    }

    public <T extends FieldData<?>> T addField(T field) {
        this.mFields.add(field);
        return field;
    }

    public boolean getIsChecked(String key) {
        return this.mFieldCreator.getIsChecked(key);
    }

    public <T> T getValue(String key, Class<T> clazz) {
        Object o = this.getValue(key);
        if (o == null) {
            return null;
        }
        if (clazz.isAssignableFrom(o.getClass())) {
            return (T)o;
        }
        return null;
    }

    public Object getValue(String key) {
        if (this.mFieldCreator.getValue(key) == null) {
            return null;
        }
        return this.mFieldCreator.getValue(key);
    }

    public String getStringValue(String key) {
        if (this.mFieldCreator.getValue(key) == null) {
            return "";
        }
        return (String)this.mFieldCreator.getValue(key);
    }

    public String getErrorMsg() {
        return this.mFieldCreator.getErrorMsg();
    }

    public List<FieldData<?>> getFields() {
        return this.mFields;
    }
}

