/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.ui.charts;

import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.core.diagram.Color;
import net.edgemind.ibee.core.diagram.Diagram;
import net.edgemind.ibee.core.diagram.DiagramData;
import net.edgemind.ibee.core.diagram.Edge;
import net.edgemind.ibee.core.diagram.Group;
import net.edgemind.ibee.core.diagram.Node;
import net.edgemind.ibee.core.diagram.Point;
import net.edgemind.ibee.core.diagram.Rect;
import net.edgemind.ibee.core.diagram.Symbol;
import net.edgemind.ibee.core.diagram.Text;
import net.edgemind.ibee.ui.charts.AbstractChart;
import net.edgemind.ibee.ui.charts.OverlayPaintingContext;
import net.edgemind.ibee.ui.charts.YChartElement;
import net.edgemind.ibee.util.math.NumberUtil;

public class BarChart
extends AbstractChart {
    private int BAR_WIDTH = 20;
    private int MARGIN_TEXT = 40;
    private boolean vertical = false;
    private String unit = "";
    private List<YChartElement> elements = new ArrayList<YChartElement>();

    public void addElement(YChartElement element) {
        this.elements.add(element);
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    @Override
    public Diagram createDiagram() {
        double minValue = 0.0;
        double maxValue = 0.0;
        for (YChartElement element : this.elements) {
            if (element.getYValue() < minValue) {
                minValue = element.getYValue();
            }
            if (!(element.getYValue() > maxValue)) continue;
            maxValue = element.getYValue();
        }
        if (this.isVertical()) {
            return this.getDiagramVertical(minValue, maxValue);
        }
        return this.getDiagramHorizontal(minValue, maxValue);
    }

    private Diagram getDiagramHorizontal(double minValue, double maxValue) {
        Diagram diagram = new Diagram();
        Group root = new Group();
        diagram.addGroup(root);
        double scaleY = (double)(100 - this.MARGIN_TEXT) / (maxValue - minValue);
        double centerY = maxValue * scaleY + (double)this.MARGIN_TEXT;
        double x = 0.0;
        Group nodeGroup = new Group();
        root.addGroup(nodeGroup);
        Group edgeGroup = new Group();
        root.addGroup(edgeGroup);
        Node last = null;
        double lastY = 0.0;
        for (YChartElement chartElement : this.elements) {
            Node node = new Node();
            node.setX(x);
            node.setY(chartElement.getYValue() < 0.0 ? centerY : centerY - chartElement.getYValue() * scaleY);
            node.setWidth((double)this.BAR_WIDTH);
            node.setHeight(Math.abs(chartElement.getYValue()) * scaleY);
            node.setForeColor(Color.BLACK);
            node.setBackColor(Color.GREEN);
            if (chartElement.getYValue() < 0.0) {
                node.setBackColor(Color.RED);
            }
            if (this.chartFormatter != null) {
                node.setBackColor(this.chartFormatter.getColor(chartElement));
            }
            Rect rect = new Rect();
            node.setSymbol((Symbol)rect);
            nodeGroup.addNode(node);
            node.setData((DiagramData)chartElement);
            node.setElement((Object)chartElement.getElement());
            double value = node.getY();
            if (chartElement.getYValue() < 0.0) {
                value += node.getHeight();
            }
            if (last != null) {
                Edge edge = new Edge();
                edgeGroup.addEdge(edge);
                edge.setForeColor(Color.BLUE);
                ArrayList<Point> points = new ArrayList<Point>();
                points.add(new Point(last.getX() + last.getWidth() / 2.0, lastY));
                points.add(new Point(node.getX() + node.getWidth() / 2.0, value));
                edge.setPoints(points);
            }
            lastY = value;
            last = node;
            this.showValue(x, node.getY() - 10.0, chartElement, nodeGroup);
            x += (double)(this.BAR_WIDTH + 10);
        }
        return diagram;
    }

    public Diagram getDiagramVertical(double minValue, double maxValue) {
        Diagram diagram = new Diagram();
        Group root = new Group();
        diagram.addGroup(root);
        double scaleX = (double)(100 - this.MARGIN_TEXT) / (maxValue - minValue);
        double centerX = minValue * scaleX;
        double y = 0.0;
        Group nodeGroup = new Group();
        root.addGroup(nodeGroup);
        for (YChartElement chartElement : this.elements) {
            Node node = new Node();
            node.setY(y);
            node.setX(chartElement.getYValue() > 0.0 ? centerX : centerX + chartElement.getYValue() * scaleX);
            node.setHeight((double)this.BAR_WIDTH);
            node.setWidth(Math.abs(chartElement.getYValue()) * scaleX);
            node.setForeColor(Color.BLACK);
            node.setBackColor(Color.GREEN);
            if (chartElement.getYValue() < 0.0) {
                node.setBackColor(Color.RED);
            }
            if (this.chartFormatter != null) {
                node.setBackColor(this.chartFormatter.getColor(chartElement));
            }
            Rect rect = new Rect();
            node.setSymbol((Symbol)rect);
            nodeGroup.addNode(node);
            node.setData((DiagramData)chartElement);
            node.setElement((Object)chartElement.getElement());
            this.showValue(node.getX() + node.getWidth() + 10.0, y + (double)(this.BAR_WIDTH / 2), chartElement, nodeGroup);
            y += (double)(this.BAR_WIDTH + 10);
        }
        return diagram;
    }

    private void showValue(double x, double y, YChartElement chartElement, Group parent) {
        Text text = new Text();
        text.setX(x);
        text.setY(y);
        text.doAntiScaleX(true);
        text.doAntiScaleY(true);
        text.setForeColor(Color.BLACK);
        text.setText(NumberUtil.roundTo2Decimals((double)chartElement.getYValue()) + this.unit);
        parent.addText(text);
    }

    @Override
    public Group getChartOverlay(OverlayPaintingContext context) {
        return null;
    }
}

