/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.ui.charts;

import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.core.diagram.Color;
import net.edgemind.ibee.core.diagram.Diagram;
import net.edgemind.ibee.core.diagram.DiagramData;
import net.edgemind.ibee.core.diagram.Edge;
import net.edgemind.ibee.core.diagram.Group;
import net.edgemind.ibee.core.diagram.Point;
import net.edgemind.ibee.core.diagram.Text;
import net.edgemind.ibee.ui.charts.AbstractChart;
import net.edgemind.ibee.ui.charts.OverlayPaintingContext;
import net.edgemind.ibee.ui.charts.XYChartElement;
import net.edgemind.ibee.util.math.Frame;
import net.edgemind.ibee.util.math.NumberUtil;

public class TimelineChart
extends AbstractChart {
    private int BAR_WIDTH_DEFAULT = 10;
    private int MARGIN_TEXT_UPPER = 20;
    private int MARGIN_TEXT_LOWER = 20;
    private int MARGIN_TEXT_LEFT = 0;
    private int MARGIN_TEXT_RIGTH = 20;
    private boolean vertical = false;
    private String unit = "";
    private double barWidth = this.BAR_WIDTH_DEFAULT;
    private boolean showYLabel = true;
    private boolean showXLabel = true;
    private Color barColor = Color.BLACK;
    private List<XYChartElement> elements = new ArrayList<XYChartElement>();

    public void addElement(XYChartElement element) {
        this.elements.add(element);
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setBarWidth(double barWidth) {
        this.barWidth = barWidth;
    }

    public void setBarColor(Color color) {
        this.barColor = color;
    }

    public void showValue(boolean showValue) {
        this.showYLabel = showValue;
    }

    public void showLabel(boolean showLabel) {
        this.showXLabel = showLabel;
    }

    @Override
    public Diagram createDiagram() {
        double minTime = 0.0;
        double maxTime = 0.0;
        for (XYChartElement element : this.elements) {
            if (element.getXValue() < minTime) {
                minTime = element.getXValue();
            }
            if (!(element.getXValue() > maxTime)) continue;
            maxTime = element.getXValue();
        }
        double minValue = 0.0;
        double maxValue = 0.0;
        for (XYChartElement element : this.elements) {
            if (element.getYValue() < minValue) {
                minValue = element.getYValue();
            }
            if (!(element.getYValue() > maxValue)) continue;
            maxValue = element.getYValue();
        }
        if (!this.isVertical()) {
            return this.getDiagramHorizontal(minTime, maxTime, minValue, maxValue);
        }
        return null;
    }

    private Diagram getDiagramHorizontal(double minTime, double maxTime, double minValue, double maxValue) {
        Diagram diagram = new Diagram();
        Group root = new Group();
        diagram.addGroup(root);
        Group nodeGroup = new Group();
        root.addGroup(nodeGroup);
        Group edgeGroup = new Group();
        root.addGroup(edgeGroup);
        double widthDiagram = (maxTime - minTime) * 1.3;
        double heightDiagram = 100 - this.MARGIN_TEXT_UPPER - this.MARGIN_TEXT_LOWER;
        double scaleX = 1.0;
        double scaleY = heightDiagram / (maxValue - minValue);
        double centerX = (double)this.MARGIN_TEXT_LEFT - minTime * scaleX;
        double centerY = (double)this.MARGIN_TEXT_UPPER + maxValue * scaleY;
        Edge edge = new Edge();
        root.addEdge(edge);
        ArrayList<Point> points = new ArrayList<Point>();
        Point left = new Point();
        points.add(left);
        left.setX(centerX);
        left.setY(centerY);
        Point right = new Point();
        points.add(right);
        right.setX((double)this.MARGIN_TEXT_LEFT + widthDiagram + (double)this.MARGIN_TEXT_RIGTH);
        right.setY(centerY);
        edge.setPoints(points);
        edge.setForeColor(Color.BLACK);
        edge.doAntiScaleX(true);
        edge.doAntiScaleY(true);
        for (XYChartElement chartElement : this.elements) {
            Edge edge2 = new Edge();
            edgeGroup.addEdge(edge2);
            ArrayList<Point> points2 = new ArrayList<Point>();
            Point lower = new Point();
            points2.add(lower);
            lower.setX(centerX + chartElement.getXValue() * scaleX);
            lower.setY(centerY);
            Point upper = new Point();
            points2.add(upper);
            upper.setX(lower.getX());
            upper.setY(centerY - chartElement.getYValue() * scaleY);
            edge2.setPoints(points2);
            if (chartElement.getBackColor() != null) {
                edge2.setForeColor(chartElement.getBackColor());
            } else {
                edge2.setForeColor(this.barColor);
            }
            edge2.setData((DiagramData)chartElement);
            edge2.setElement((Object)chartElement.getElement());
            edge2.doAntiScaleX(true);
            edge2.doAntiScaleY(true);
            edge2.setArrowType(Edge.ArrowType.ARROW_TARGET);
            if (this.showXLabel) {
                this.showX(upper.getX(), 100 - this.MARGIN_TEXT_LOWER, chartElement, nodeGroup);
            }
            if (!this.showYLabel) continue;
            this.showY(upper.getX(), (upper.getY() + lower.getY()) / 2.0, chartElement, nodeGroup);
        }
        diagram.setSize(new Frame(0.0, 0.0, widthDiagram + (double)this.MARGIN_TEXT_LEFT + (double)this.MARGIN_TEXT_RIGTH, 100.0));
        return diagram;
    }

    private void showX(double x, double y, XYChartElement chartElement, Group parent) {
        Text text = new Text();
        text.doAntiScaleX(true);
        text.doAntiScaleY(true);
        text.setX(x);
        text.setY(y);
        text.setDeltaScreenX(0.0);
        text.setDeltaScreenY(20.0);
        text.setTextAlign(Text.TextAlign.CENTER);
        text.setForeColor(Color.BLACK);
        text.setText(NumberUtil.roundTo2Decimals((double)chartElement.getXValue()) + this.unit);
        parent.addText(text);
    }

    private void showY(double x, double y, XYChartElement chartElement, Group parent) {
        Text text = new Text();
        text.setX(x);
        text.setDeltaScreenX(10.0);
        text.setDeltaScreenY(0.0);
        text.setY(y);
        text.doAntiScaleX(true);
        text.doAntiScaleY(true);
        text.setForeColor(Color.BLACK);
        text.setTextAlign(Text.TextAlign.LEFT);
        text.setText(chartElement.getLabel());
        parent.addText(text);
    }

    @Override
    public Group getChartOverlay(OverlayPaintingContext context) {
        return null;
    }
}

