/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.ui.charts.axis;

import java.util.ArrayList;
import net.edgemind.ibee.core.diagram.Color;
import net.edgemind.ibee.core.diagram.Edge;
import net.edgemind.ibee.core.diagram.Group;
import net.edgemind.ibee.core.diagram.Point;
import net.edgemind.ibee.core.diagram.Text;
import net.edgemind.ibee.ui.charts.OverlayPaintingContext;
import net.edgemind.ibee.ui.charts.axis.Axis;
import net.edgemind.ibee.util.math.NumberUtil;

public class AxisFormatter {
    private int numberOfTicks = 10;
    private Axis currentAxis;
    private OverlayPaintingContext currentContext;
    private Group overlayGroup;

    public void setNumberOfTicks(int numberOfTicks) {
        this.numberOfTicks = numberOfTicks;
    }

    public int getNumberOfTicks() {
        return this.numberOfTicks;
    }

    public Group paintAxis(Axis axis, OverlayPaintingContext context) {
        this.overlayGroup = new Group();
        this.currentAxis = axis;
        this.currentContext = context;
        this.createAxisLabel();
        this.createAxisTicks();
        return this.overlayGroup;
    }

    private void createAxisLabel() {
        if (this.currentAxis.isHorizontalAxis()) {
            this.createXAxisLabel();
        } else {
            this.createYAxisLabel();
        }
    }

    private void createXAxisLabel() {
        Text text = new Text();
        double rightX = this.currentContext.getVisibleScreen().getX() + this.currentContext.getVisibleScreen().getWidth() / 2.0;
        double bottomY = this.currentContext.getVisibleScreen().getY() + this.currentContext.getVisibleScreen().getHeight();
        text.setX(rightX);
        text.setY(bottomY);
        text.doAntiScaleX(true);
        text.doAntiScaleY(true);
        text.setForeColor(Color.BLACK);
        text.setTextAlign(Text.TextAlign.LEFT);
        text.setText(this.currentAxis.getLabel());
        text.setFontStyle(Text.FontStyle.NORMAL);
        text.setFontType(Text.FontType.OPENSANS);
        text.setTextAlign(Text.TextAlign.CENTER);
        text.setTextSize(10.0);
        text.setDeltaScreenX(0.0);
        text.setDeltaScreenY(-25.0);
        this.overlayGroup.addText(text);
    }

    private void createYAxisLabel() {
        Text text = new Text();
        double left = this.currentContext.getVisibleScreen().getX();
        double top = this.currentContext.getVisibleScreen().getY() + this.currentContext.getVisibleScreen().getHeight() / 2.0;
        text.setX(left);
        text.setY(top);
        text.doAntiScaleX(true);
        text.doAntiScaleY(true);
        text.setForeColor(Color.BLACK);
        text.setTextAlign(Text.TextAlign.LEFT);
        text.setText(this.currentAxis.getLabel());
        text.setFontStyle(Text.FontStyle.NORMAL);
        text.setFontType(Text.FontType.OPENSANS);
        text.setTextAlign(Text.TextAlign.LEFT);
        text.setTextSize(10.0);
        text.setDeltaScreenX(25.0);
        text.setDeltaScreenY(0.0);
        text.setRotation(1.5707963267948966);
        this.overlayGroup.addText(text);
    }

    private void createAxisLines() {
        if (this.currentAxis.isHorizontalAxis()) {
            this.createHorizontalLine();
        } else {
            this.createVerticalLine();
        }
    }

    private void createHorizontalLine() {
        double leftX = this.currentContext.getVisibleScreen().getX();
        double rightX = leftX + this.currentContext.getVisibleScreen().getWidth();
        double bottomY = 0.0;
        Edge horizontalLine = new Edge();
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(leftX, bottomY));
        points.add(new Point(rightX, bottomY));
        horizontalLine.setPoints(points);
        horizontalLine.setForeColor(Color.BLACK);
        horizontalLine.setLineWidth(2.0);
        horizontalLine.setArrowType(Edge.ArrowType.ARROW_TARGET);
        horizontalLine.doAntiScaleX(true);
        horizontalLine.doAntiScaleY(true);
        horizontalLine.setDeltaScreenX(-10.0);
        horizontalLine.setDeltaScreenY(0.0);
        this.overlayGroup.addEdge(horizontalLine);
    }

    private void createVerticalLine() {
        double leftX = 0.0;
        double topY = this.currentContext.getVisibleScreen().getY();
        double bottomY = topY + this.currentContext.getVisibleScreen().getHeight();
        Edge verticalLine = new Edge();
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(leftX, bottomY));
        points.add(new Point(leftX, topY));
        verticalLine.setPoints(points);
        verticalLine.setForeColor(Color.BLACK);
        verticalLine.setLineWidth(2.0);
        verticalLine.setArrowType(Edge.ArrowType.ARROW_TARGET);
        verticalLine.doAntiScaleX(true);
        verticalLine.doAntiScaleY(true);
        verticalLine.setDeltaScreenX(0.0);
        verticalLine.setDeltaScreenY(10.0);
        this.overlayGroup.addEdge(verticalLine);
    }

    private void createAxisTicks() {
        if (this.currentAxis.isHorizontalAxis()) {
            this.createHorizontalTicks();
        } else {
            this.createVerticalTicks();
        }
    }

    private void createHorizontalTicks() {
        int numberOfTicks = this.getNumberOfTicks();
        double deltaXAxis = this.currentContext.getVisibleScreen().getWidth() / (double)numberOfTicks;
        double leftx = this.currentContext.getVisibleScreen().getX();
        if (leftx < 0.0) {
            leftx = 0.0;
        }
        int i = 0;
        while (i <= numberOfTicks) {
            double x = leftx + deltaXAxis * (double)i;
            if (!(x - this.currentContext.getVisibleScreen().getX() < 50.0 / this.currentContext.getViewer().getZoomX())) {
                String unit = "";
                Text text = new Text();
                text.setText(NumberUtil.roundTo2Decimals((double)x) + unit);
                text.setX(x);
                text.setY(this.currentContext.getVisibleScreen().getY() + this.currentContext.getVisibleScreen().getHeight());
                text.setDeltaScreenY(-45.0);
                text.doAntiScaleX(true);
                text.doAntiScaleY(true);
                text.setForeColor(Color.BLACK);
                text.setTextAlign(Text.TextAlign.CENTER);
                text.setFontStyle(Text.FontStyle.NORMAL);
                text.setFontType(Text.FontType.OPENSANS);
                text.setTextSize(10.0);
                this.overlayGroup.addText(text);
            }
            ++i;
        }
    }

    private void createVerticalTicks() {
        int numberOfTicks = this.getNumberOfTicks();
        double deltaYAxis = this.currentContext.getVisibleScreen().getHeight() / (double)numberOfTicks;
        double bottomy = this.currentContext.getVisibleScreen().getY() + this.currentContext.getVisibleScreen().getHeight();
        if (bottomy > 0.0) {
            bottomy = 0.0;
        }
        int i = 0;
        while (i <= numberOfTicks) {
            double y = bottomy - deltaYAxis * (double)i;
            if (!(this.currentContext.getVisibleScreen().getY() + this.currentContext.getVisibleScreen().getHeight() - y < 30.0 / this.currentContext.getViewer().getZoomY())) {
                Text text = new Text();
                text.setX(this.currentContext.getVisibleScreen().getX());
                text.setY(y);
                text.setDeltaScreenX(45.0);
                text.doAntiScaleX(true);
                text.doAntiScaleY(true);
                text.setForeColor(Color.BLACK);
                text.setTextAlign(Text.TextAlign.LEFT);
                text.setText("" + NumberUtil.roundTo2Decimals((double)(-y)));
                text.setFontStyle(Text.FontStyle.NORMAL);
                text.setFontType(Text.FontType.OPENSANS);
                text.setTextSize(10.0);
                this.overlayGroup.addText(text);
            }
            ++i;
        }
    }
}

