/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.ui.diagram.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.edgemind.ibee.core.app.EventListener;
import net.edgemind.ibee.core.command.CommandStack;
import net.edgemind.ibee.core.command.ICommand;
import net.edgemind.ibee.core.diagram.Color;
import net.edgemind.ibee.core.diagram.DElement;
import net.edgemind.ibee.core.diagram.Diagram;
import net.edgemind.ibee.core.diagram.Edge;
import net.edgemind.ibee.core.diagram.Group;
import net.edgemind.ibee.core.diagram.Node;
import net.edgemind.ibee.core.diagram.Point;
import net.edgemind.ibee.core.diagram.Rect;
import net.edgemind.ibee.core.diagram.Symbol;
import net.edgemind.ibee.core.diagram.util.IDiagramCreator;
import net.edgemind.ibee.core.diagram.util.ISelectionSupport;
import net.edgemind.ibee.core.iml.LockedElementException;
import net.edgemind.ibee.core.util.Selection;
import net.edgemind.ibee.ui.app.IComponent;
import net.edgemind.ibee.ui.common.event.ModificationEvent;
import net.edgemind.ibee.ui.common.event.MouseClickEvent;
import net.edgemind.ibee.ui.common.event.MouseDblClickEvent;
import net.edgemind.ibee.ui.common.listener.IKeyPressedListener;
import net.edgemind.ibee.ui.common.listener.IKeyReleaseListener;
import net.edgemind.ibee.ui.common.listener.IModificationListener;
import net.edgemind.ibee.ui.common.listener.IMouseClickedListener;
import net.edgemind.ibee.ui.common.listener.IMouseDblClickListener;
import net.edgemind.ibee.ui.common.listener.IMouseDownListener;
import net.edgemind.ibee.ui.common.listener.IMouseMoveListener;
import net.edgemind.ibee.ui.common.listener.IMouseScrollListener;
import net.edgemind.ibee.ui.common.listener.IMouseTraverseListener;
import net.edgemind.ibee.ui.common.listener.IMouseUpListener;
import net.edgemind.ibee.ui.common.listener.IResizedListener;
import net.edgemind.ibee.ui.diagram.CURSOR;
import net.edgemind.ibee.ui.diagram.DiagramPanel;
import net.edgemind.ibee.ui.diagram.DiagramUtil;
import net.edgemind.ibee.ui.diagram.KeyCodes;
import net.edgemind.ibee.ui.diagram.MouseButton;
import net.edgemind.ibee.ui.diagram.editor.DefaultDiagramConfig;
import net.edgemind.ibee.ui.diagram.editor.DefaultEditorMode;
import net.edgemind.ibee.ui.diagram.editor.EditorMode;
import net.edgemind.ibee.ui.diagram.editor.IDiagramEditorConfig;
import net.edgemind.ibee.ui.diagram.editor.IWrappedToolbarItem;
import net.edgemind.ibee.ui.diagram.editor.MODE;
import net.edgemind.ibee.ui.diagram.editor.ModeListener;
import net.edgemind.ibee.ui.diagram.editor.SelectionListener;
import net.edgemind.ibee.ui.diagram.toolbar.TBElementItem;
import net.edgemind.ibee.ui.diagram.toolbar.TBLineItem;
import net.edgemind.ibee.ui.menu.ICommandMenuItem;
import net.edgemind.ibee.ui.menu.IMenu;
import net.edgemind.ibee.ui.menu.IMenuItem;
import net.edgemind.ibee.ui.menu.IMenuProvider;
import net.edgemind.ibee.ui.menu.Menu;
import net.edgemind.ibee.ui.menu.MenuFactory;
import net.edgemind.ibee.ui.toolbar.IToolbar;
import net.edgemind.ibee.ui.toolbar.IToolbarItem;
import net.edgemind.ibee.ui.toolbar.IToolbarProvider;
import net.edgemind.ibee.ui.toolbar.ToolBar;
import net.edgemind.ibee.ui.toolbar.ToolbarItem;
import net.edgemind.ibee.util.math.Frame;

public abstract class DiagramEditor
implements IComponent {
    protected CURSOR cursorMouseOverEdgeSource = CURSOR.CROSS;
    protected CURSOR cursorMouseOverInvalidEdgeSource = CURSOR.ERROR;
    protected CURSOR cursorMouseOverEdgeTarget = CURSOR.CROSS;
    protected CURSOR cursorMouseOverInvalidEdgeTarget = CURSOR.ERROR;
    protected CURSOR cursorMouseOverCreateNode = CURSOR.CROSS;
    protected CURSOR cursorDefault = CURSOR.ARROW;
    protected CommandStack commandStack;
    private boolean mouseIn = true;
    protected boolean centerRequired = false;
    protected boolean viewNewDiagram = false;
    protected EditorMode editorMode;
    protected IDiagramEditorConfig diagramEditorConfig;
    protected Frame pageFrame = new Frame(0.0, 0.0, 5000.0, 5000.0);
    private Map<Object, List<Double>> positionMap = new HashMap<Object, List<Double>>();
    protected MODE state = MODE.SELECTION;
    protected Node transitionSrc;
    protected Node transitionTarget;
    protected IToolbarItem activeTbItem = null;
    protected Selection<Object> selectedElementsIdsOld = new Selection();
    protected Selection<Object> selection = new Selection();
    protected List<DElement> selectedDiagElements = new ArrayList<DElement>();
    protected Object profile = new Object();
    protected Group overlayMove;
    protected Group overlayMarkMultiple;
    protected Group overlayCreation;
    protected Group overlayHovering;
    protected Object model;
    protected Object editElement;
    private Color selectionColor = Color.EMORANGE;
    private boolean enableToolbar1 = true;
    private boolean enableToolbar2 = true;
    protected boolean hover = false;
    private boolean displayToolbarItemNames = true;
    protected boolean readOnly = false;
    protected double downDiagramTranslateX;
    protected double downDiagramTranslateY;
    protected double downX;
    protected double downY;
    protected double downMouseX;
    protected double downMouseY;
    protected double currentX;
    protected double currentY;
    protected int currentKey = -1;
    protected DiagramPanel diagramPanel;
    private List<SelectionListener> selectionListeners;
    private List<EventListener<MouseDblClickEvent<DElement>>> mouseDblClickListeners;
    private List<EventListener<MouseClickEvent<DElement>>> mouseClickListeners;
    private List<IModificationListener<Void>> modificationListeners;
    private List<ModeListener> modeListeners = new ArrayList<ModeListener>();
    private boolean activateDiagramDragging = true;

    protected abstract void redo();

    protected abstract void undo();

    public DiagramEditor(DiagramPanel diagramPanel, IDiagramEditorConfig diagramEditorConfig) {
        this.diagramPanel = diagramPanel;
        this.diagramEditorConfig = diagramEditorConfig;
        if (this.diagramEditorConfig == null) {
            this.diagramEditorConfig = new DefaultDiagramConfig();
        }
        this.readOnly = false;
        this.getDiagramPanel().setContextMenuEnabled(true);
        this.getDiagramPanel().setHorizontalScrollbarEnabled(true);
        this.getDiagramPanel().setVerticalScrollbarEnabled(true);
    }

    public void setActivateDiagramDragging(boolean activateDiagramDragging) {
        this.activateDiagramDragging = activateDiagramDragging;
    }

    public void setSelectionColor(Color color) {
        this.selectionColor = color;
    }

    public void setEditorConfig(IDiagramEditorConfig config) {
        this.diagramEditorConfig = config;
    }

    public void create() {
        this.editorMode = new DefaultEditorMode(this);
        Group overlay = new Group();
        this.overlayMove = new Group();
        this.overlayMarkMultiple = new Group();
        this.overlayHovering = new Group();
        this.overlayCreation = new Group();
        overlay.addGroup(this.overlayMove);
        overlay.addGroup(this.overlayMarkMultiple);
        overlay.addGroup(this.overlayCreation);
        overlay.addGroup(this.overlayHovering);
        this.getDiagramPanel().addOverlay(overlay);
        this.getDiagramPanel().getDiagramRenderer().setSelectedElements(this.selection.getElements());
        this.getDiagramPanel().addMenuProvider(new IMenuProvider(){

            @Override
            public List<IMenuItem> create() {
                return DiagramEditor.this.getContextMenu();
            }
        });
        if (!this.readOnly) {
            if (this.enableToolbar1) {
                this.getDiagramPanel().addToolbarProvider1(new IToolbarProvider(){

                    @Override
                    public IToolbar create() {
                        return DiagramEditor.this.getToolBar1();
                    }
                });
            }
            if (this.enableToolbar2) {
                this.getDiagramPanel().addToolbarProvider2(new IToolbarProvider(){

                    @Override
                    public IToolbar create() {
                        return DiagramEditor.this.getToolBar2();
                    }
                });
            }
        }
        this.getDiagramPanel().addMouseClickListener(new IMouseClickedListener(){

            @Override
            public void mouseClicked(double x, double y, MouseButton btn) {
                try {
                    boolean handled = DiagramEditor.this.editorMode.mouseClick(x, y, btn);
                    if (!handled) {
                        DiagramEditor.this.handleMouseClick(x, y, btn);
                    }
                }
                catch (LockedElementException e) {
                    DiagramEditor.this.cleanup();
                    throw e;
                }
            }
        });
        this.getDiagramPanel().addMouseDownListener(new IMouseDownListener(){

            @Override
            public void mouseDown(double x, double y, MouseButton btn) {
                try {
                    boolean handled = DiagramEditor.this.editorMode.mouseDown(x, y, btn);
                    if (!handled) {
                        DiagramEditor.this.handleMouseDown(x, y, btn);
                    }
                }
                catch (LockedElementException e) {
                    DiagramEditor.this.cleanup();
                    throw e;
                }
            }
        });
        this.getDiagramPanel().addMouseMoveListener(new IMouseMoveListener(){

            @Override
            public void mouseMove(double x, double y) {
                DiagramEditor.this.currentX = x;
                DiagramEditor.this.currentY = y;
                try {
                    boolean handled = DiagramEditor.this.editorMode.mouseMove(x, y);
                    if (!handled) {
                        DiagramEditor.this.handleMouseMove(x, y);
                    }
                }
                catch (LockedElementException e) {
                    DiagramEditor.this.cleanup();
                    throw e;
                }
            }
        });
        this.getDiagramPanel().addMouseUpListener(new IMouseUpListener(){

            @Override
            public void mouseUp(double x, double y, MouseButton btn) {
                try {
                    boolean handled = DiagramEditor.this.editorMode.mouseUp(x, y, btn);
                    if (!handled) {
                        DiagramEditor.this.handleMouseUp(x, y, btn);
                    }
                }
                catch (LockedElementException e) {
                    DiagramEditor.this.cleanup();
                    throw e;
                }
            }
        });
        this.getDiagramPanel().addMouseScrollListener(new IMouseScrollListener(){

            @Override
            public void mouseScroll(int count) {
                try {
                    DiagramEditor.this.handleMouseScrolled(count);
                }
                catch (LockedElementException e) {
                    DiagramEditor.this.cleanup();
                    throw e;
                }
            }
        });
        this.getDiagramPanel().addKeyPressedListener(new IKeyPressedListener(){

            @Override
            public void keyPressed(int keycode) {
                try {
                    DiagramEditor.this.handleKeyPressed(keycode);
                }
                catch (LockedElementException e) {
                    DiagramEditor.this.cleanup();
                    throw e;
                }
            }
        });
        this.getDiagramPanel().addKeyReleaseListener(new IKeyReleaseListener(){

            @Override
            public void keyReleased(int keycode) {
                try {
                    DiagramEditor.this.handleKeyReleased(keycode);
                }
                catch (LockedElementException e) {
                    DiagramEditor.this.cleanup();
                    throw e;
                }
            }
        });
        this.getDiagramPanel().addResizedListener(new IResizedListener(){

            @Override
            public void resized(double width, double height) {
                try {
                    DiagramEditor.this.handleResized(width, height);
                }
                catch (LockedElementException e) {
                    DiagramEditor.this.cleanup();
                    throw e;
                }
            }
        });
        this.getDiagramPanel().addDoubleClickListener(new IMouseDblClickListener(){

            @Override
            public void doubleClicked(double x, double y, MouseButton btn) {
                try {
                    DiagramEditor.this.handleMouseDblClick(x, y, btn);
                }
                catch (LockedElementException e) {
                    DiagramEditor.this.cleanup();
                    throw e;
                }
            }
        });
        this.getDiagramPanel().addMouseTraverseListener(new IMouseTraverseListener(){

            @Override
            public void movedOut() {
                try {
                    DiagramEditor.this.handleMouseOut();
                }
                catch (LockedElementException e) {
                    DiagramEditor.this.cleanup();
                    throw e;
                }
            }

            @Override
            public void movedIn() {
            }
        });
        this.getDiagramPanel().create();
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setResource(Object model) {
        this.model = model;
    }

    protected void handleMouseClick(double screenX, double screenY, MouseButton btn) {
        if (this.diagramPanel.getDiagram() == null) {
            return;
        }
        DElement selectedDiagElement = DiagramUtil.getSelectedDiagramElement(this.getDiagramPanel().getDiagram(), this.createCoord(screenX, screenY));
        if (selectedDiagElement == null) {
            return;
        }
        if (this.mouseClickListeners != null && this.mouseClickListeners.size() > 0) {
            MouseClickEvent<DElement> event = new MouseClickEvent<DElement>(selectedDiagElement);
            for (EventListener<MouseClickEvent<DElement>> l : this.mouseClickListeners) {
                l.handleEvent(event);
                if (!event.isHandled()) continue;
                return;
            }
        }
    }

    private DiagramUtil.Coord createCoord(double screenX, double screenY) {
        DiagramUtil.Coord coord = new DiagramUtil.Coord();
        coord.diagramX = this.translateX(screenX);
        coord.diagramY = this.translateY(screenY);
        coord.screenX = screenX;
        coord.screenY = screenY;
        return coord;
    }

    private DiagramUtil.Coord createCoordInv(double diagramX, double diagramY) {
        DiagramUtil.Coord coord = new DiagramUtil.Coord();
        coord.diagramX = diagramX;
        coord.diagramY = diagramY;
        coord.screenX = this.detranslateX(diagramX);
        coord.screenY = this.detranslateY(diagramY);
        return coord;
    }

    protected void handleMouseDblClick(double screenX, double screenY, MouseButton btn) {
        Object selectedElement;
        if (this.diagramPanel.getDiagram() == null) {
            return;
        }
        DElement selectedDiagElement = DiagramUtil.getSelectedDiagramElement(this.getDiagramPanel().getDiagram(), this.createCoord(screenX, screenY));
        if (selectedDiagElement == null) {
            return;
        }
        if (this.mouseDblClickListeners != null && this.mouseDblClickListeners.size() > 0) {
            MouseDblClickEvent<DElement> event = new MouseDblClickEvent<DElement>(selectedDiagElement);
            for (EventListener<MouseDblClickEvent<DElement>> l : this.mouseDblClickListeners) {
                l.handleEvent(event);
                if (!event.isHandled()) continue;
                return;
            }
        }
        if ((selectedElement = selectedDiagElement.getElement()) != null && this.diagramEditorConfig.hasEditorDialog(selectedElement)) {
            this.diagramEditorConfig.openEditorDialog(selectedElement, this);
        }
    }

    protected void handleMouseDown(double screenX, double screenY, MouseButton btn) {
        if (this.diagramPanel.getDiagram() == null) {
            return;
        }
        if (btn == MouseButton.RIGHT) {
            DElement selectedDiagElement = DiagramUtil.getSelectedDiagramElement(this.getDiagramPanel().getDiagram(), this.createCoord(screenX, screenY));
            if (selectedDiagElement != null && selectedDiagElement.getElement() != null) {
                if (this.diagramEditorConfig.canSelect(selectedDiagElement.getElement())) {
                    if (this.selectedDiagElements.contains(selectedDiagElement)) {
                        return;
                    }
                } else {
                    selectedDiagElement = null;
                }
            }
            Selection newSelection = new Selection();
            this.selectedDiagElements.clear();
            if (selectedDiagElement != null) {
                newSelection.add(selectedDiagElement.getElement());
                this.selectedDiagElements.add(selectedDiagElement);
            }
            this.setSelection((Selection<Object>)newSelection);
            return;
        }
        if (btn != MouseButton.LEFT && btn != MouseButton.MIDDLE) {
            return;
        }
        this.downMouseX = screenX;
        this.downMouseY = screenY;
        DiagramUtil.Coord coord = this.createCoord(screenX, screenY);
        screenX = this.translateX(screenX);
        screenY = this.translateY(screenY);
        DElement selectedDiagElement = DiagramUtil.getSelectedDiagramElement(this.getDiagramPanel().getDiagram(), coord);
        this.downX = screenX;
        this.downY = screenY;
        if (this.state == MODE.SELECTION) {
            if (selectedDiagElement != null && this.diagramEditorConfig.isClickable(selectedDiagElement)) {
                this.diagramEditorConfig.click(selectedDiagElement);
            } else if (selectedDiagElement != null && selectedDiagElement.getElement() != null) {
                if (this.diagramEditorConfig.canSelect(selectedDiagElement.getElement())) {
                    if (this.selectedDiagElements.contains(selectedDiagElement)) {
                        if ((this.currentKey == KeyCodes.CTRL || btn == MouseButton.MIDDLE) && this.selection.contains(selectedDiagElement.getElement())) {
                            this.selection.remove(selectedDiagElement.getElement());
                            this.selectedDiagElements.remove(selectedDiagElement);
                            Selection newSelection = new Selection((Collection)this.selection.getElements());
                            this.setSelection((Selection<Object>)newSelection);
                            this.updateSelection();
                        }
                        if (!this.readOnly && this.diagramEditorConfig.canMove(selectedDiagElement)) {
                            this.state = MODE.SELECTION_MOVING_READY;
                        }
                        this.repaintDiagram();
                    } else {
                        Selection newSelection;
                        if (this.currentKey == KeyCodes.CTRL || btn == MouseButton.MIDDLE) {
                            newSelection = new Selection((Collection)this.selection.getElements());
                        } else {
                            newSelection = new Selection();
                            this.selectedDiagElements.clear();
                            if (!this.readOnly && this.diagramEditorConfig.canMove(selectedDiagElement)) {
                                this.state = MODE.SELECTION_MOVING_READY;
                            }
                        }
                        this.selectedDiagElements.add(selectedDiagElement);
                        newSelection.add(selectedDiagElement.getElement());
                        this.setSelection((Selection<Object>)newSelection);
                    }
                } else if (this.currentKey == KeyCodes.CTRL || btn == MouseButton.MIDDLE) {
                    this.state = MODE.SELECTION_MARK_MULTIPLE;
                } else if (this.activateDiagramDragging || this.currentKey == KeyCodes.SPACE) {
                    this.state = MODE.MOVE_PAGE;
                    this.downDiagramTranslateX = this.diagramPanel.getTranslateX();
                    this.downDiagramTranslateY = this.diagramPanel.getTranslateY();
                }
            } else if (this.currentKey == KeyCodes.CTRL || btn == MouseButton.MIDDLE) {
                this.state = MODE.SELECTION_MARK_MULTIPLE;
            } else if (this.activateDiagramDragging || this.currentKey == KeyCodes.SPACE) {
                this.state = MODE.MOVE_PAGE;
                this.downDiagramTranslateX = this.diagramPanel.getTranslateX();
                this.downDiagramTranslateY = this.diagramPanel.getTranslateY();
            }
        } else if (this.state == MODE.CREATE_EDGE1) {
            TBLineItem item;
            if (selectedDiagElement instanceof Node && (item = (TBLineItem)this.activeTbItem).isSource(selectedDiagElement.getElement())) {
                this.handleCreateEdge1((Node)selectedDiagElement);
            }
        } else if (this.state == MODE.CREATE_NODE) {
            TBElementItem item;
            Object parent = this.editElement;
            if (selectedDiagElement instanceof Node) {
                parent = selectedDiagElement.getElement();
            }
            if (parent == null) {
                parent = this.model;
            }
            if ((item = (TBElementItem)this.activeTbItem).canCreate(parent)) {
                this.handleCreateNode(screenX, screenY, parent);
            }
        }
    }

    protected void handleMouseUp(double screenX, double screenY, MouseButton btn) {
        DElement selectedNode;
        if (this.diagramPanel.getDiagram() == null) {
            return;
        }
        DiagramUtil.Coord coord = this.createCoord(screenX, screenY);
        double diagramX = coord.diagramX;
        double diagramY = coord.diagramY;
        this.clearOverlays();
        if ((this.state == MODE.SELECTION_MOVING_READY || this.state == MODE.MOVE_PAGE) && this.downMouseX == screenX && this.downMouseY == screenY && (selectedNode = DiagramUtil.getSelectedDiagramElement(this.getDiagramPanel().getDiagram(), coord)) == null) {
            this.selectedElementsIdsOld.clear();
            this.selectedDiagElements.clear();
            this.setSelection((Selection<Object>)new Selection());
        }
        if (this.state == MODE.SELECTION_MOVING_READY) {
            this.state = MODE.SELECTION;
        }
        if (this.state == MODE.SELECTION_MOVING) {
            if (screenX > this.getDiagramPanel().getClientWidth() || screenX < 0.0 || screenY < 0.0 || screenY > this.getDiagramPanel().getClientHeight()) {
                this.state = MODE.SELECTION;
                this.repaintOverlay();
                return;
            }
            List<Object> selectedElements = this.getSelectedElements();
            boolean canMove = true;
            for (Object element : selectedElements) {
                if (this.diagramEditorConfig.canMove(element)) continue;
                canMove = false;
            }
            if (canMove) {
                double deltaX = diagramX - this.downX;
                double deltaY = diagramY - this.downY;
                for (DElement diagElement : this.selectedDiagElements) {
                    if (!this.positionMap.containsKey(diagElement)) continue;
                    deltaX = this.positionMap.get(diagElement).get(0);
                    deltaY = this.positionMap.get(diagElement).get(1);
                    break;
                }
                boolean moved = this.diagramEditorConfig.move(this.model, selectedElements, deltaX, deltaY);
                if (moved) {
                    this.rebuildDiagram();
                }
            }
            this.state = MODE.SELECTION;
        }
        if (this.state == MODE.SELECTION_MARK_MULTIPLE) {
            Frame frame = new Frame(screenX, screenY, this.detranslateX(this.downX) - screenX, this.detranslateY(this.downY) - screenY);
            List<DElement> nodeList = DiagramUtil.getSelectedNodes(this.getDiagramPanel().getDiagram(), this.translate(frame));
            this.selectedElementsIdsOld.clear();
            this.selectedElementsIdsOld.addAll(this.selection);
            this.selectedDiagElements.clear();
            Selection newSelection = new Selection();
            for (DElement node : nodeList) {
                this.selectedDiagElements.add(node);
                Object selElement = node.getElement();
                if (selElement == null || newSelection.contains(selElement)) continue;
                newSelection.add(selElement);
            }
            if (this.selectedElementsIdsOld.equals((Object)newSelection)) {
                this.repaintOverlay();
            } else {
                this.setSelection((Selection<Object>)newSelection);
            }
            this.state = MODE.SELECTION;
        } else if (this.state == MODE.CREATE_EDGE2) {
            this.state = MODE.CREATE_EDGE1;
            selectedNode = DiagramUtil.getSelectedNode(this.getDiagramPanel().getDiagram(), coord);
            if (selectedNode != null) {
                TBLineItem item = (TBLineItem)this.activeTbItem;
                if (this.transitionSrc != null && item.isTarget(this.transitionSrc.getElement(), selectedNode.getElement())) {
                    this.handleCreateEdge2((Node)selectedNode);
                } else {
                    this.repaintOverlay();
                }
            } else {
                this.repaintOverlay();
            }
        }
        if (this.state == MODE.MOVE_PAGE) {
            this.state = MODE.SELECTION;
        }
    }

    protected void handleMouseMove(double screenX, double screenY) {
        if (this.diagramPanel.getDiagram() == null) {
            return;
        }
        if (!this.mouseIn) {
            this.mouseIn = true;
        }
        DiagramUtil.Coord coord = this.createCoord(screenX, screenY);
        double diagramX = coord.diagramX;
        double diagramY = coord.diagramY;
        boolean hoverPre = this.hover;
        this.overlayHovering.clear();
        this.hover = false;
        if (this.state == MODE.SELECTION) {
            Group group;
            DElement selectedDiagElement = DiagramUtil.getSelectedDiagramElement(this.getDiagramPanel().getDiagram(), coord);
            if (selectedDiagElement != null && this.diagramEditorConfig.getHoverProvider() != null && (group = this.diagramEditorConfig.getHoverProvider().hover(selectedDiagElement, diagramX, diagramY)) != null) {
                this.overlayHovering.addGroup(group);
                this.hover = true;
                this.repaintOverlay();
            }
            if (selectedDiagElement != null && selectedDiagElement.getElement() != null && this.diagramEditorConfig.canSelect(selectedDiagElement.getElement())) {
                this.setCursor(CURSOR.HAND);
            } else {
                this.setCursor(this.cursorDefault);
            }
        }
        if (hoverPre && !this.hover) {
            this.repaintOverlay();
        }
        if (this.state == MODE.SELECTION_MARK_MULTIPLE) {
            this.setCursor(this.cursorDefault);
            this.overlayMarkMultiple.clear();
            Node rectangle = new Node();
            Frame frame = new Frame(screenX, screenY, this.detranslateX(this.downX) - screenX, this.detranslateY(this.downY) - screenY);
            rectangle.setX(frame.getX());
            rectangle.setY(frame.getY());
            rectangle.setWidth(frame.getWidth());
            rectangle.setHeight(frame.getHeight());
            rectangle.setForeColor(this.selectionColor);
            rectangle.setBackColor(null);
            rectangle.setSymbol((Symbol)new Rect());
            rectangle.setPositioning(DElement.Positioning.Viewer);
            this.overlayMarkMultiple.addNode(rectangle);
            this.repaintOverlay();
        }
        if (this.state == MODE.SELECTION_MOVING_READY) {
            this.setCursor(this.cursorDefault);
            this.state = MODE.SELECTION_MOVING;
        }
        if (this.state == MODE.SELECTION_MOVING) {
            this.setCursor(this.cursorDefault);
            this.overlayMove.clear();
            this.positionMap.clear();
            for (DElement diagElement : this.selectedDiagElements) {
                if (!(diagElement instanceof Node)) continue;
                Node node = (Node)diagElement;
                Node overlayNode = new Node();
                overlayNode.setForeColor(this.selectionColor);
                overlayNode.setSymbol(node.getSymbol());
                overlayNode.setX(node.getX() + (diagramX - this.downX));
                overlayNode.setY(node.getY() + (diagramY - this.downY));
                overlayNode.setWidth(node.getWidth());
                overlayNode.setHeight(node.getHeight());
                int gridWidth = this.getDiagramPanel().getGridWidth();
                overlayNode.setX(DiagramUtil.snapToGrid(overlayNode.getX(), overlayNode.getX() + overlayNode.getWidth(), gridWidth));
                overlayNode.setY(DiagramUtil.snapToGrid(overlayNode.getY(), overlayNode.getY() + overlayNode.getHeight(), gridWidth));
                overlayNode.setBackColor(null);
                if (this.currentKey == KeyCodes.SHIFT) {
                    List<Double> yValues;
                    Edge edge;
                    ArrayList<Point> points;
                    List<Double> xValues;
                    Frame visibleFrame = this.getDiagramPanel().getVisibleFrame();
                    List<Node> allNodes = DiagramUtil.getAllNodes(this.getDiagramPanel().getDiagram());
                    Map<String, List<Double>> map = DiagramUtil.getCloserPosition(allNodes, overlayNode);
                    if (map.containsKey("x") && (xValues = map.get("x")).size() > 2 && xValues.get(0) != null) {
                        overlayNode.setX(xValues.get(0).doubleValue());
                        double yMin = visibleFrame.getY();
                        double yMax = visibleFrame.getY() + visibleFrame.getHeight();
                        points = new ArrayList<Point>();
                        points.add(new Point(xValues.get(2).doubleValue(), yMin));
                        points.add(new Point(xValues.get(2).doubleValue(), yMax));
                        edge = new Edge();
                        edge.setBackColor(Color.RED);
                        edge.setForeColor(Color.RED);
                        edge.setPoints(points);
                        this.overlayMove.addEdge(edge);
                    }
                    if (map.containsKey("y") && (yValues = map.get("y")).size() > 2 && yValues.get(0) != null) {
                        overlayNode.setY(yValues.get(0).doubleValue());
                        double xMin = visibleFrame.getX();
                        double xMax = visibleFrame.getX() + visibleFrame.getWidth();
                        points = new ArrayList();
                        points.add(new Point(xMin, yValues.get(2).doubleValue()));
                        points.add(new Point(xMax, yValues.get(2).doubleValue()));
                        edge = new Edge();
                        edge.setBackColor(Color.RED);
                        edge.setForeColor(Color.RED);
                        edge.setPoints(points);
                        this.overlayMove.addEdge(edge);
                    }
                }
                ArrayList<Double> values = new ArrayList<Double>();
                values.add(overlayNode.getX() - node.getX());
                values.add(overlayNode.getY() - node.getY());
                this.positionMap.put(node, values);
                this.overlayMove.addNode(overlayNode);
            }
            this.repaintOverlay();
        }
        if (this.state == MODE.CREATE_EDGE1) {
            this.handleMouseOverCreateEdge1(diagramX, diagramY);
        }
        if (this.state == MODE.CREATE_EDGE2) {
            this.handleMouseOverCreateEdge2(diagramX, diagramY);
        }
        if (this.state == MODE.CREATE_NODE) {
            this.handleMouseOverCreateNode(diagramX, diagramY);
        }
        if (this.state == MODE.MOVE_PAGE) {
            this.diagramPanel.setTranslateX(this.downDiagramTranslateX - (screenX - this.downMouseX) / this.diagramPanel.getZoomXIntern());
            this.diagramPanel.setTranslateY(this.downDiagramTranslateY - (screenY - this.downMouseY) / this.diagramPanel.getZoomYIntern());
            this.adaptScrollBars();
            this.diagramPanel.paintDiagram();
        }
    }

    protected void handleMouseOverCreateEdge1(double diagramX, double diagramY) {
        Node selectedNode = DiagramUtil.getSelectedNode(this.getDiagramPanel().getDiagram(), this.createCoordInv(diagramX, diagramY));
        TBLineItem item = (TBLineItem)this.activeTbItem;
        if (selectedNode != null && item.isSource(selectedNode.getElement())) {
            this.setCursor(this.cursorMouseOverEdgeSource);
        } else {
            this.setCursor(this.cursorMouseOverInvalidEdgeSource);
        }
    }

    protected void handleCreateEdge1(Node selectedDiagElement) {
        this.state = MODE.CREATE_EDGE2;
        this.transitionSrc = selectedDiagElement;
    }

    protected void handleMouseOverCreateEdge2(double diagramX, double diagramY) {
        Node selectedNode = DiagramUtil.getSelectedNode(this.getDiagramPanel().getDiagram(), this.createCoordInv(diagramX, diagramY));
        TBLineItem item = (TBLineItem)this.activeTbItem;
        if (selectedNode != null && item != null && this.transitionSrc != null && item.isTarget(this.transitionSrc.getElement(), selectedNode.getElement())) {
            this.setCursor(this.cursorMouseOverEdgeTarget);
        } else {
            this.setCursor(this.cursorMouseOverInvalidEdgeTarget);
        }
        this.overlayMarkMultiple.clear();
        Edge e = new Edge();
        ArrayList<Point> points = new ArrayList<Point>();
        if (this.transitionSrc != null) {
            points.add(new Point(this.transitionSrc.getX() + this.transitionSrc.getWidth() / 2.0, this.transitionSrc.getY() + this.transitionSrc.getHeight() / 2.0));
            points.add(new Point(diagramX, diagramY));
            e.setPoints(points);
            e.setForeColor(Color.RED);
            this.overlayMarkMultiple.addEdge(e);
        }
        this.repaintOverlay();
    }

    protected void handleCreateEdge2(Node selectedNode) {
        TBLineItem item = (TBLineItem)this.activeTbItem;
        this.transitionTarget = selectedNode;
        item.create(this.transitionSrc.getElement(), this.transitionTarget.getElement(), this.getCommandStack());
        this.rebuildDiagram();
        this.state = MODE.CREATE_EDGE1;
        this.transitionSrc = null;
    }

    protected void handleMouseOverCreateNode(double diagramX, double diagramY) {
        TBElementItem item;
        Node selectedNode = DiagramUtil.getSelectedNode(this.getDiagramPanel().getDiagram(), this.createCoordInv(diagramX, diagramY));
        Object parent = this.editElement;
        if (selectedNode != null) {
            parent = selectedNode.getElement();
        }
        if (parent == null) {
            parent = this.model;
        }
        if ((item = (TBElementItem)this.activeTbItem).canCreate(parent)) {
            this.setCursor(this.cursorMouseOverCreateNode);
        } else {
            this.setCursor(this.cursorMouseOverInvalidEdgeSource);
        }
    }

    protected void handleCreateNode(double diagramX, double diagramY) {
        this.handleCreateNode(diagramX, diagramY, this.model);
    }

    protected void handleCreateNode(double diagramX, double diagramY, Object parent) {
        TBElementItem item = (TBElementItem)this.activeTbItem;
        Object e = item.create(parent, diagramX, diagramY);
        this.selection.clear();
        if (e != null) {
            this.selection.add(e);
        }
        this.notifySelectionChanged();
        this.rebuildDiagram();
        this.state = MODE.CREATE_NODE;
    }

    protected void handleKeyPressed(int keycode) {
        this.currentKey = keycode;
        if (this.diagramPanel.getDiagram() == null) {
            return;
        }
        if (keycode == KeyCodes.MARK_ALL) {
            this.markAll();
        }
        if (keycode == KeyCodes.ESC) {
            this.deselectAll();
        }
        if (keycode == KeyCodes.SAVE) {
            this.saveModel();
        }
        if (this.readOnly) {
            return;
        }
        if (keycode == KeyCodes.DEL) {
            this.deleteSelection();
        }
        if (keycode == KeyCodes.UNDO) {
            this.undo();
            this.rebuildDiagram();
        }
        if (keycode == KeyCodes.REDO) {
            this.redo();
            this.rebuildDiagram();
        }
    }

    protected void handleKeyReleased(int keycode) {
        this.currentKey = -1;
        if (this.diagramPanel.getDiagram() == null) {
            return;
        }
        if (this.readOnly) {
            return;
        }
    }

    protected void handleResized(double width, double height) {
        if (this.diagramPanel.getDiagram() == null) {
            return;
        }
        this.adaptScrollBars();
        this.repaintDiagram();
    }

    protected void handleMouseScrolled(int count) {
        if (this.diagramPanel.getDiagram() == null) {
            return;
        }
        if (this.currentKey == KeyCodes.CTRL) {
            this.diagramPanel.setTranslateY(this.diagramPanel.getTranslateY() + (double)(count * 40) / this.diagramPanel.getZoomYIntern());
            this.adaptScrollBars();
            this.diagramPanel.paintDiagram();
        } else {
            if (count > 0) {
                this.decZoom(count);
            } else {
                this.incZoom(-count);
            }
            this.adaptScrollBars();
        }
    }

    protected void handleMouseOut() {
        if (this.diagramPanel.getDiagram() == null) {
            return;
        }
        this.mouseIn = false;
    }

    protected boolean isLocked(Object object) {
        return false;
    }

    protected void clearOverlays() {
        this.overlayMarkMultiple.clear();
        this.overlayMove.clear();
        this.overlayCreation.clear();
    }

    protected void markAll() {
        Diagram diagram = this.getDiagramPanel().getDiagram();
        if (diagram != null) {
            for (Group group : diagram.getGroups()) {
                this.markAll(group);
            }
        }
        this.updateSelection();
        this.rebuildDiagram();
    }

    protected void markAll(Group group) {
        for (Node node : group.getNodes()) {
            Object object = node.getElement();
            if (object == null || !this.diagramEditorConfig.canSelect(object)) continue;
            this.selection.add(object);
        }
        for (Group sub : group.getGroups()) {
            this.markAll(sub);
        }
    }

    protected void deselectAll() {
        this.selection.clear();
        this.selectedDiagElements.clear();
        this.updateSelection();
    }

    protected void saveModel() {
    }

    protected void deleteSelection() {
        boolean refreshNeeded;
        if (this.selection.size() == 0) {
            return;
        }
        List<Object> selectedElements = this.getSelectedElements();
        boolean canDelete = true;
        for (Object element : selectedElements) {
            if (this.diagramEditorConfig.canDelete(element)) continue;
            canDelete = false;
        }
        if (canDelete && (refreshNeeded = this.diagramEditorConfig.delete(this.model, selectedElements))) {
            this.selection.clear();
            this.selectedDiagElements.clear();
            this.rebuildDiagram();
        }
    }

    public void rebuildDiagram() {
        this.rebuildDiagram(true);
    }

    public void rebuildDiagram(boolean uiUpdate) {
        if (this.diagramEditorConfig == null) {
            return;
        }
        IDiagramCreator diagramCreator = this.diagramEditorConfig.getDiagramCreator();
        if (diagramCreator == null) {
            return;
        }
        if (diagramCreator instanceof ISelectionSupport) {
            ((ISelectionSupport)diagramCreator).setSelection(this.getSelectedElements());
        }
        Diagram diagram = diagramCreator.create(this.editElement, this.model);
        this.getDiagramPanel().setDiagram(diagram);
        if (uiUpdate) {
            this.adaptScrollBars();
            this.repaintDiagram();
            this.recreateSelectionNodes();
        } else {
            this.getDiagramPanel().createGrid();
            this.getDiagramPanel().createPaper();
            if (this.centerRequired) {
                this.centerDiagram();
                this.centerRequired = false;
            }
        }
    }

    public void repaintDiagram() {
        if (this.getDiagramPanel().getDiagram() != null) {
            if (this.centerRequired) {
                this.centerDiagram();
                this.adaptScrollBars();
                this.centerRequired = false;
            }
            this.getDiagramPanel().paintDiagram();
        }
    }

    protected void adaptScrollBars() {
        this.getDiagramPanel().adaptScrollBars(true);
    }

    public void repaintOverlay() {
        this.getDiagramPanel().paintOverlay();
    }

    protected void recreateSelectionNodes(Group group) {
        Object element;
        for (Node node : group.getNodes()) {
            element = node.getElement();
            if (element == null || !this.selection.contains(element)) continue;
            this.selectedDiagElements.add((DElement)node);
        }
        for (Edge edge : group.getEdges()) {
            element = edge.getElement();
            if (element == null || !this.selection.contains(element)) continue;
            this.selectedDiagElements.add((DElement)edge);
        }
        for (Group subGroup : group.getGroups()) {
            this.recreateSelectionNodes(subGroup);
        }
    }

    protected void recreateSelectionNodes() {
        this.selectedDiagElements.clear();
        if (this.getDiagramPanel().getDiagram() == null) {
            return;
        }
        if (this.selection == null || this.selection.size() == 0) {
            return;
        }
        Diagram diagram = this.getDiagramPanel().getDiagram();
        for (Group group : diagram.getGroups()) {
            this.recreateSelectionNodes(group);
        }
        Collections.sort(this.selectedDiagElements, new Comparator<DElement>(){

            @Override
            public int compare(DElement o1, DElement o2) {
                return DiagramEditor.this.selection.indexOf(o1.getElement()) - DiagramEditor.this.selection.indexOf(o2.getElement());
            }
        });
    }

    public double translateX(double x) {
        return this.getDiagramPanel().translateX(x);
    }

    public double translateY(double y) {
        return this.getDiagramPanel().translateY(y);
    }

    public double detranslateX(double x) {
        return this.getDiagramPanel().detranslateX(x);
    }

    public double detranslateY(double y) {
        return this.getDiagramPanel().detranslateY(y);
    }

    public Frame translate(Frame frame) {
        return this.getDiagramPanel().translate(frame);
    }

    public List<IMenuItem> getContextMenu() {
        if (this.readOnly) {
            return null;
        }
        Menu menu = new Menu();
        this.diagramEditorConfig.addContextMenu(this.selectedDiagElements, menu, this);
        this.addDeletePopupItem(menu);
        return menu.getItems();
    }

    protected void addDeletePopupItem(IMenu parent) {
        final List<Object> selectedElements = this.getSelectedElements();
        if (selectedElements.size() == 0) {
            return;
        }
        boolean canDelete = true;
        for (Object element : selectedElements) {
            if (this.diagramEditorConfig.canDelete(element)) continue;
            canDelete = false;
        }
        if (canDelete) {
            ICommandMenuItem menuItem = MenuFactory.createCommandMenuItem("Remove", new ICommand(){

                public void execute() {
                    boolean refreshNeeded = DiagramEditor.this.diagramEditorConfig.delete(DiagramEditor.this.model, selectedElements);
                    if (refreshNeeded) {
                        DiagramEditor.this.selection.clear();
                        DiagramEditor.this.selectedDiagElements.clear();
                        DiagramEditor.this.rebuildDiagram();
                    }
                }
            });
            parent.addItem(menuItem);
        }
    }

    private ToolBar getToolBar1() {
        ToolBar toolbar = new ToolBar();
        ToolbarItem selectItem = new ToolbarItem("Select", "/img/ui/icon_select_22x22.png"){

            @Override
            public void click() {
                DiagramEditor.this.setActiveItem(null);
            }
        };
        selectItem.setToggle(true);
        IToolbar toggleItems = this.diagramEditorConfig.getToolbar(this);
        if (toggleItems != null) {
            ArrayList<IToolbarItem> items = new ArrayList<IToolbarItem>(toggleItems.getItems());
            items.add(0, selectItem);
            for (IToolbarItem next : items) {
                WrapperToolbarItem wrapper = new WrapperToolbarItem(next);
                toolbar.addItem(wrapper);
            }
        }
        return toolbar;
    }

    private ToolBar getToolBar2() {
        ArrayList<17> items = new ArrayList<17>();
        ToolbarItem item = new ToolbarItem("Undo", "/img/ui/undo.svg"){

            @Override
            public void click() {
                DiagramEditor.this.undo();
                DiagramEditor.this.rebuildDiagram();
            }
        };
        items.add(item);
        item = new ToolbarItem("Redo", "/img/ui/redo.svg"){

            @Override
            public void click() {
                DiagramEditor.this.redo();
                DiagramEditor.this.rebuildDiagram();
            }
        };
        items.add(item);
        item = new ToolbarItem("Zoom -", "/img/ui/zoomminus2.svg"){

            @Override
            public void click() {
                DiagramEditor.this.decZoom(2);
            }
        };
        items.add(item);
        item = new ToolbarItem("Zoom +", "/img/ui/zoomplus2.svg"){

            @Override
            public void click() {
                DiagramEditor.this.incZoom(2);
            }
        };
        items.add(item);
        item = new ToolbarItem("Center", "/img/ui/icon_center_24x24.png"){

            @Override
            public void click() {
                DiagramEditor.this.centerRequired = true;
                DiagramEditor.this.repaintDiagram();
            }
        };
        items.add(item);
        ToolBar toolbar = new ToolBar();
        for (IToolbarItem iToolbarItem : items) {
            WrapperToolbarItem wrapper = new WrapperToolbarItem(iToolbarItem);
            toolbar.addItem(wrapper);
        }
        return toolbar;
    }

    public void decZoom(int cnt) {
        if (this.getDiagramPanel().getZoomX() > 0.1) {
            this.getDiagramPanel().setZoom(this.getDiagramPanel().getZoomX() / Math.pow(1.1, cnt));
            this.repaintDiagram();
        }
    }

    public void incZoom(int cnt) {
        if (this.getDiagramPanel().getZoomX() < 10.0) {
            this.getDiagramPanel().setZoom(this.getDiagramPanel().getZoomX() * Math.pow(1.1, cnt));
            this.repaintDiagram();
        }
    }

    public void center() {
        this.centerRequired = true;
        this.repaintDiagram();
    }

    public void setCenterRequired() {
        this.centerRequired = true;
    }

    public void setCursor(CURSOR cursor) {
        this.getDiagramPanel().setCursor(cursor);
    }

    @Override
    public void refreshPage() {
        this.refreshToolbar();
        this.rebuildDiagram();
    }

    public void refreshToolbar() {
        this.getDiagramPanel().renderToolbar1();
    }

    @Override
    public void setSelection(Selection<Object> selection) {
        if (this.selection.equals(selection)) {
            return;
        }
        this.selection = selection;
        this.updateSelection();
    }

    private void updateSelection() {
        this.getDiagramPanel().setSelection(this.selection);
        this.repaintDiagram();
        this.notifySelectionChanged();
    }

    public void displayToolbarItemNames(boolean value) {
        this.displayToolbarItemNames = value;
    }

    public DiagramPanel getDiagramPanel() {
        return this.diagramPanel;
    }

    public List<Object> getSelection() {
        return this.selection.getElements();
    }

    public void centerDiagram() {
        if (this.diagramPanel.getDiagram() == null) {
            return;
        }
        Frame frame = this.diagramPanel.getDiagram().getSize(false);
        if (frame.getWidth() == 0.0 || frame.getHeight() == 0.0) {
            return;
        }
        this.getDiagramPanel().setTranslateX(frame.getX() + frame.getWidth() / 2.0);
        this.getDiagramPanel().setTranslateY(frame.getY() + frame.getHeight() / 2.0);
        double zoomX = this.getDiagramPanel().getClientWidth() / (frame.getWidth() * 1.2);
        double zoomY = this.getDiagramPanel().getClientHeight() / (frame.getHeight() * 1.2);
        if (zoomX == 0.0) {
            zoomX = 1.0;
        }
        if (zoomY == 0.0) {
            zoomY = 1.0;
        }
        this.getDiagramPanel().setZoom(Math.min(zoomX, zoomY));
    }

    @Override
    public Object getUIComponent() {
        return this.getDiagramPanel().getUIComponent();
    }

    public Object getResource() {
        return this.model;
    }

    public Object getEditElement() {
        return this.editElement;
    }

    public void setEditElement(Object element) {
        if (this.editElement == element) {
            return;
        }
        this.editElement = element;
    }

    public IDiagramEditorConfig getEditorConfig() {
        return this.diagramEditorConfig;
    }

    public void addSelectionListener(SelectionListener listener) {
        if (this.selectionListeners == null) {
            this.selectionListeners = new ArrayList<SelectionListener>();
        }
        this.selectionListeners.add(listener);
    }

    protected void notifySelectionChanged() {
        if (this.selectionListeners == null) {
            return;
        }
        for (SelectionListener listener : this.selectionListeners) {
            listener.selectionChanged(this.selection);
        }
    }

    public MODE getMode() {
        return this.state;
    }

    protected Node getTransitionSrc() {
        return this.transitionSrc;
    }

    public EditorMode getEditorMode() {
        return this.editorMode;
    }

    public void setEditorMode(EditorMode editorMode) {
        if (editorMode == null) {
            editorMode = new DefaultEditorMode(this);
        }
        this.editorMode = editorMode;
    }

    public void addOverlay(Group overlay) {
        this.getDiagramPanel().addOverlay(overlay);
    }

    public void removeOverlay(Group overlay) {
        this.getDiagramPanel().removeOverlay(overlay);
    }

    public List<DElement> getSelectedDiagElements() {
        return this.selectedDiagElements;
    }

    public List<Object> getSelectedElements() {
        return this.selection.getElements();
    }

    public void setActiveItem(IToolbarItem item) {
        this.activeTbItem = item;
        if (item != null) {
            if (item instanceof WrapperToolbarItem) {
                item = ((WrapperToolbarItem)item).getWrappedItem();
            }
            item.click();
            this.state = this.activeTbItem instanceof TBLineItem ? MODE.CREATE_EDGE1 : (this.activeTbItem instanceof TBElementItem ? MODE.CREATE_NODE : MODE.SELECTION);
            for (ModeListener l : this.modeListeners) {
                l.modeSwitched(this.activeTbItem);
            }
        } else {
            this.state = MODE.SELECTION;
            for (ModeListener l : this.modeListeners) {
                l.modeSwitched(null);
            }
        }
    }

    public void addModeListener(ModeListener listener) {
        this.modeListeners.add(listener);
    }

    public void enableToolbar1(boolean value) {
        this.enableToolbar1 = value;
    }

    public void enableToolbar2(boolean value) {
        this.enableToolbar2 = value;
    }

    public void addMouseClickListener(EventListener<MouseClickEvent<DElement>> l) {
        if (this.mouseClickListeners == null) {
            this.mouseClickListeners = new ArrayList<EventListener<MouseClickEvent<DElement>>>();
        }
        this.mouseClickListeners.add(l);
    }

    public void addMouseDblClickListener(EventListener<MouseDblClickEvent<DElement>> l) {
        if (this.mouseDblClickListeners == null) {
            this.mouseDblClickListeners = new ArrayList<EventListener<MouseDblClickEvent<DElement>>>();
        }
        this.mouseDblClickListeners.add(l);
    }

    public void addModificationListener(IModificationListener<Void> l) {
        if (this.modificationListeners == null) {
            this.modificationListeners = new ArrayList<IModificationListener<Void>>();
        }
        this.modificationListeners.add(l);
    }

    private void notifyModified() {
        if (this.modificationListeners == null) {
            return;
        }
        for (IModificationListener<Void> l : this.modificationListeners) {
            l.modified(new ModificationEvent<Object>(null));
        }
    }

    public void setCommandStack(CommandStack cmdStack) {
        this.commandStack = cmdStack;
    }

    public CommandStack getCommandStack() {
        if (this.commandStack != null) {
            return this.commandStack;
        }
        return null;
    }

    protected void cleanup() {
        this.state = MODE.SELECTION;
        this.clearOverlays();
        this.repaintOverlay();
    }

    public class WrapperToolbarItem
    extends ToolbarItem
    implements IWrappedToolbarItem {
        private IToolbarItem wrapped;

        public WrapperToolbarItem(IToolbarItem item) {
            super(item.getText());
            this.wrapped = item;
            super.setIcon(item.getIcon());
            super.setToggle(item.isToggle());
            super.setEnabled(true);
            this.iconClass = item.getIconClass();
        }

        @Override
        public void click() {
            if (this.isToggle) {
                DiagramEditor.this.setActiveItem(this.wrapped);
            } else {
                this.wrapped.click();
            }
        }

        @Override
        public IToolbarItem getWrappedItem() {
            return this.wrapped;
        }

        @Override
        public int getWidth() {
            return this.wrapped.getWidth();
        }

        @Override
        public int getHeight() {
            return this.wrapped.getHeight();
        }

        @Override
        public String getText() {
            if (DiagramEditor.this.displayToolbarItemNames) {
                return super.getText();
            }
            return null;
        }

        @Override
        public boolean isSelected() {
            return this.wrapped.isSelected();
        }

        @Override
        public void setSelected(boolean value) {
            this.wrapped.setSelected(value);
        }

        @Override
        public String getTooltip() {
            return this.wrapped.getTooltip();
        }
    }
}

