/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.ui.diagram.editor;

import net.edgemind.ibee.core.diagram.Color;
import net.edgemind.ibee.core.diagram.Group;
import net.edgemind.ibee.core.diagram.Node;
import net.edgemind.ibee.core.diagram.Rect;
import net.edgemind.ibee.core.diagram.Symbol;
import net.edgemind.ibee.ui.diagram.DiagramUtil;
import net.edgemind.ibee.ui.diagram.MouseButton;
import net.edgemind.ibee.ui.diagram.editor.DiagramEditor;
import net.edgemind.ibee.ui.diagram.editor.EditorMode;
import net.edgemind.ibee.util.math.Frame;

public abstract class ResizeElementMode
extends EditorMode {
    private Node origNode;
    private Group overlay;
    private Frame current;
    private ResizeMode resizeMode;

    protected abstract void commitSize(Frame var1);

    public ResizeElementMode(ResizeMode resizeMode, DiagramEditor editor, Node origNode) {
        super(editor);
        this.resizeMode = resizeMode;
        this.origNode = origNode;
        this.overlay = new Group();
        this.editor.addOverlay(this.overlay);
        this.current = origNode.getFrame();
    }

    @Override
    public boolean mouseMove(double x, double y) {
        double oldX;
        double oldY;
        this.overlay.clear();
        int gridWidth = this.editor.getDiagramPanel().getGridWidth();
        double diagramX = this.editor.translateX(x);
        double diagramY = this.editor.translateY(y);
        if (this.resizeMode == ResizeMode.UP) {
            this.current.setX(this.origNode.getX());
            this.current.setY(diagramY);
            this.current.setWidth(this.origNode.getWidth());
            this.current.setHeight(this.origNode.getY() + this.origNode.getHeight() - diagramY);
            oldY = this.current.getY();
            this.current.setY(DiagramUtil.snapToGrid(this.current.getY(), this.current.getY(), gridWidth));
            this.current.setHeight(this.current.getHeight() + (oldY - this.current.getY()));
        }
        if (this.resizeMode == ResizeMode.DOWN) {
            this.current.setX(this.origNode.getX());
            this.current.setY(this.origNode.getY());
            this.current.setWidth(this.origNode.getWidth());
            this.current.setHeight(diagramY - this.current.getY());
            this.current.setHeight(DiagramUtil.snapToGrid(this.current.getY() + this.current.getHeight(), this.current.getY() + this.current.getHeight(), gridWidth) - this.current.getY());
        }
        if (this.resizeMode == ResizeMode.LEFT) {
            this.current.setX(diagramX);
            this.current.setY(this.origNode.getY());
            this.current.setWidth(this.origNode.getX() + this.origNode.getWidth() - diagramX);
            this.current.setHeight(this.origNode.getHeight());
            oldX = this.current.getX();
            this.current.setX(DiagramUtil.snapToGrid(this.current.getX(), this.current.getX(), gridWidth));
            this.current.setWidth(this.current.getWidth() + (oldX - this.current.getX()));
        }
        if (this.resizeMode == ResizeMode.RIGHT) {
            this.current.setX(this.origNode.getX());
            this.current.setY(this.origNode.getY());
            this.current.setWidth(diagramX - this.current.getX());
            this.current.setHeight(this.origNode.getHeight());
            this.current.setWidth(DiagramUtil.snapToGrid(this.current.getX() + this.current.getWidth(), this.current.getX() + this.current.getWidth(), gridWidth) - this.current.getX());
        }
        if (this.resizeMode == ResizeMode.DIAGONAL_UP_RIGHT) {
            this.current.setX(this.origNode.getX());
            this.current.setY(diagramY);
            this.current.setWidth(diagramX - this.current.getX());
            this.current.setHeight(this.origNode.getY() + this.origNode.getHeight() - diagramY);
            oldY = this.current.getY();
            this.current.setY(DiagramUtil.snapToGrid(this.current.getY(), this.current.getY(), gridWidth));
            this.current.setHeight(this.current.getHeight() + (oldY - this.current.getY()));
            this.current.setWidth(DiagramUtil.snapToGrid(this.current.getX() + this.current.getWidth(), this.current.getX() + this.current.getWidth(), gridWidth) - this.current.getX());
        }
        if (this.resizeMode == ResizeMode.DIAGONAL_DOWN_RIGHT) {
            this.current.setX(this.origNode.getX());
            this.current.setY(this.origNode.getY());
            this.current.setWidth(diagramX - this.current.getX());
            this.current.setHeight(diagramY - this.current.getY());
            this.current.setWidth(DiagramUtil.snapToGrid(this.current.getX() + this.current.getWidth(), this.current.getX() + this.current.getWidth(), gridWidth) - this.current.getX());
            this.current.setHeight(DiagramUtil.snapToGrid(this.current.getY() + this.current.getHeight(), this.current.getY() + this.current.getHeight(), gridWidth) - this.current.getY());
        }
        if (this.resizeMode == ResizeMode.DIAGONAL_UP_LEFT) {
            this.current.setX(diagramX);
            this.current.setY(diagramY);
            this.current.setWidth(this.origNode.getX() + this.origNode.getWidth() - diagramX);
            this.current.setHeight(this.origNode.getY() + this.origNode.getHeight() - diagramY);
            oldY = this.current.getY();
            this.current.setY(DiagramUtil.snapToGrid(this.current.getY(), this.current.getY(), gridWidth));
            this.current.setHeight(this.current.getHeight() + (oldY - this.current.getY()));
            double oldX2 = this.current.getX();
            this.current.setX(DiagramUtil.snapToGrid(this.current.getX(), this.current.getX(), gridWidth));
            this.current.setWidth(this.current.getWidth() + (oldX2 - this.current.getX()));
        }
        if (this.resizeMode == ResizeMode.DIAGONAL_DOWN_LEFT) {
            this.current.setX(diagramX);
            this.current.setY(this.origNode.getY());
            this.current.setWidth(this.origNode.getX() + this.origNode.getWidth() - diagramX);
            this.current.setHeight(diagramY - this.current.getY());
            oldX = this.current.getX();
            this.current.setX(DiagramUtil.snapToGrid(this.current.getX(), this.current.getX(), gridWidth));
            this.current.setWidth(this.current.getWidth() + (oldX - this.current.getX()));
            this.current.setHeight(DiagramUtil.snapToGrid(this.current.getY() + this.current.getHeight(), this.current.getY() + this.current.getHeight(), gridWidth) - this.current.getY());
        }
        this.refreshOverlay();
        return true;
    }

    private void refreshOverlay() {
        Node node = new Node();
        node.setX(this.current.getX());
        node.setY(this.current.getY());
        node.setWidth(this.current.getWidth());
        node.setHeight(this.current.getHeight());
        node.setSymbol((Symbol)new Rect());
        node.setForeColor(new Color(205, 0, 205));
        node.setBackColor(null);
        this.overlay.addNode(node);
        this.editor.repaintOverlay();
    }

    @Override
    public boolean mouseUp(double x, double y, MouseButton btn) {
        this.overlay.clear();
        this.editor.setEditorMode(null);
        Frame finalFrame = new Frame(this.current.getX(), this.current.getY(), this.current.getWidth(), this.current.getHeight());
        this.commitSize(finalFrame);
        this.editor.refreshPage();
        return true;
    }

    @Override
    public boolean mouseDown(double x, double y, MouseButton btn) {
        return true;
    }

    @Override
    public void init() {
    }

    @Override
    public void dispose() {
    }

    public static enum ResizeMode {
        UP,
        DOWN,
        LEFT,
        RIGHT,
        DIAGONAL_UP_LEFT,
        DIAGONAL_DOWN_LEFT,
        DIAGONAL_UP_RIGHT,
        DIAGONAL_DOWN_RIGHT;

    }
}

