/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.ui.diagram.renderer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.edgemind.ibee.core.diagram.Color;
import net.edgemind.ibee.core.diagram.DElement;
import net.edgemind.ibee.ui.diagram.renderer.IDiagramRenderer;
import net.edgemind.ibee.util.math.Frame;

public abstract class DiagramRenderer
implements IDiagramRenderer {
    protected boolean isDiagramCoordSystemX = false;
    protected boolean isDiagramCoordSystemY = false;
    protected double translateX = 0.0;
    protected double translateY = 0.0;
    protected double zoomX = 1.0;
    protected double zoomY = 1.0;
    protected boolean tanslateToCenterX = true;
    protected boolean tanslateToCenterY = true;
    protected Color selectionForeColor = Color.RED;
    protected Color selectionBackColor = null;
    protected Color backgroundColor = Color.WHITE;
    protected int selectionLineWidth = 1;
    protected Set<Object> selection = new HashSet<Object>();
    protected List<DElement> selectedDiagramElements = new ArrayList<DElement>();
    protected Frame visibleFrame = null;

    @Override
    public void setSelectedElements(List<Object> elements) {
        this.selection.clear();
        this.selection.addAll(elements);
    }

    @Override
    public void setTranslate(double translateX, double translateY) {
        this.translateX = translateX;
        this.translateY = translateY;
    }

    @Override
    public void setZoomX(double zoomX) {
        this.zoomX = zoomX;
    }

    @Override
    public void setZoomY(double zoomY) {
        this.zoomY = zoomY;
    }

    @Override
    public List<Object> getSelectedElements() {
        return new ArrayList<Object>(this.selection);
    }

    @Override
    public boolean translateToCenterX() {
        return this.tanslateToCenterX;
    }

    @Override
    public boolean translateToCenterY() {
        return this.tanslateToCenterY;
    }

    @Override
    public void translateToCenterX(boolean value) {
        this.tanslateToCenterX = value;
    }

    @Override
    public void translateToCenterY(boolean value) {
        this.tanslateToCenterY = value;
    }

    protected double getCoordX(double x) {
        if (this.isDiagramCoordSystemX) {
            return x;
        }
        if (this.tanslateToCenterX) {
            double clientWidth = this.getClientWidth();
            return (x - this.translateX) * this.zoomX + clientWidth / 2.0;
        }
        return (x - this.translateX) * this.zoomX;
    }

    protected double getCoordY(double y) {
        if (this.isDiagramCoordSystemY) {
            return y;
        }
        if (this.tanslateToCenterY) {
            double clientHeight = this.getClientHeight();
            return (y - this.translateY) * this.zoomY + clientHeight / 2.0;
        }
        return (y - this.translateY) * this.zoomY;
    }

    @Override
    public void setVisibleFrame(Frame frame) {
        this.visibleFrame = frame;
    }

    @Override
    public void setSelectionForeColor(Color color) {
        this.selectionForeColor = color;
    }

    @Override
    public void setSelectionBackColor(Color color) {
        this.selectionBackColor = color;
    }

    @Override
    public void setSelectionLineWidth(int width) {
        this.selectionLineWidth = width;
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }
}

