/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.ui.diagram.util;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.edgemind.ibee.core.diagram.Circle;
import net.edgemind.ibee.core.diagram.Color;
import net.edgemind.ibee.core.diagram.Diagram;
import net.edgemind.ibee.core.diagram.Edge;
import net.edgemind.ibee.core.diagram.Group;
import net.edgemind.ibee.core.diagram.Node;
import net.edgemind.ibee.core.diagram.Point;
import net.edgemind.ibee.core.diagram.Symbol;
import net.edgemind.ibee.core.diagram.primitives.PPolyline;
import net.edgemind.ibee.core.diagram.primitives.Primitive;
import net.edgemind.ibee.ui.diagram.util.MyEdgeConverter;
import net.edgemind.ibee.util.Tuple;
import net.edgemind.ibee.util.math.Line;
import net.edgemind.ibee.util.math.MathUtil;
import net.edgemind.ibee.util.math.Point2D;
import net.edgemind.ibee.util.misc.IFilter;

public class CrossingLineAvoider {
    private Set<Point2D> joints = new HashSet<Point2D>();
    private Set<Obstacle> edgeObstacles = new HashSet<Obstacle>();
    private IFilter<Edge> edgeFilter;
    private Function<Edge, EdgeConfig> edgeConfigGetter;
    private double distance = 4.0;
    private boolean joinConnectionsWithSameTarget = false;
    private boolean paintBridges = true;
    private boolean paintJoints = false;
    private Set<Line> handledBridgeSegments = new HashSet<Line>();
    private Function<Tuple<Edge, IntersectionGroup>, Boolean> canJoin;
    private Group bridgeGroup;
    private boolean showJoinDirections = false;

    public boolean isShowJoinDirections() {
        return this.showJoinDirections;
    }

    public void setShowJoinDirections(boolean showJoinDirections) {
        this.showJoinDirections = showJoinDirections;
    }

    public boolean setJoinConnectionsWithSameTarget() {
        return this.joinConnectionsWithSameTarget;
    }

    public void setJoinConnectionsWithSameTarget(boolean joinConnectionsWithSameTarget) {
        this.joinConnectionsWithSameTarget = joinConnectionsWithSameTarget;
    }

    public void setFilter(IFilter<Edge> filter) {
        this.edgeFilter = filter;
    }

    public boolean isPaintBridges() {
        return this.paintBridges;
    }

    public void setPaintBridges(boolean paintBridges) {
        this.paintBridges = paintBridges;
    }

    public boolean isPaintJoints() {
        return this.paintJoints;
    }

    public void setPaintJoints(boolean paintJoints) {
        this.paintJoints = paintJoints;
    }

    public void clear() {
        this.edgeObstacles.clear();
    }

    public Function<Edge, EdgeConfig> getEdgeConfigGetter() {
        return this.edgeConfigGetter;
    }

    public void setEdgeConfigGetter(Function<Edge, EdgeConfig> edgeConfigGetter) {
        this.edgeConfigGetter = edgeConfigGetter;
    }

    public static void avoidCuttingLines(Diagram diagram) {
        CrossingLineAvoider avoider = new CrossingLineAvoider();
        avoider.processDiagram(diagram);
    }

    public void processDiagram(Diagram diagram) {
        for (Group g : diagram.getGroups()) {
            this.processGroup(g);
        }
    }

    public void processEdges(Collection<Edge> edges) {
        for (Edge edge : edges) {
            this.processEdge(edge);
        }
    }

    private void processGroup(Group group) {
        for (Edge edge : group.getEdges()) {
            this.processEdge(edge);
        }
        for (Group g : group.getGroups()) {
            this.processGroup(g);
        }
    }

    private void processEdge(Edge edge) {
        if (this.edgeFilter == null || this.edgeFilter.accept((Object)edge)) {
            MyEdge myEdge = this.toMyEdge(edge);
            this.processMyEdge(myEdge);
            this.fromMyEdge(myEdge, edge);
        }
    }

    private void fromMyEdge(MyEdge myEdge, Edge edge) {
        MyEdgeConverter converter = new MyEdgeConverter();
        converter.fromMyEdge(myEdge, edge);
    }

    private MyEdge toMyEdge(Edge edge) {
        MyEdgeConverter converter = new MyEdgeConverter();
        return converter.toMyEdge(edge);
    }

    public void processMyEdges(Collection<MyEdge> edges) {
        for (MyEdge edge : edges) {
            this.processMyEdge(edge);
        }
    }

    public List<Line> clone(List<Line> line) {
        ArrayList<Line> clone = new ArrayList<Line>();
        for (Line part : line) {
            Line clonePart = part.clone();
            clone.add(clonePart);
        }
        return clone;
    }

    private void processMyEdge(MyEdge edge) {
        if (this.edgeConfigGetter != null) {
            edge.config = this.edgeConfigGetter.apply(edge.edge);
        }
        boolean join = this.joinConnectionsWithSameTarget && edge.config.allowJoin;
        boolean bridgeCreation = this.paintBridges && edge.config.allowBridge;
        boolean paintJoints = this.paintJoints;
        if (!(join || bridgeCreation || paintJoints)) {
            return;
        }
        if (edge.obstacle != null) {
            this.edgeObstacles.remove(edge.obstacle);
        }
        Set<Line> noCollidingSegments = this.addLineInternal(edge);
        Obstacle obstacle = new Obstacle();
        obstacle.edge = edge;
        obstacle.segments = new ArrayList<Line>();
        for (Line segment : edge.segments) {
            if (noCollidingSegments.contains(segment)) continue;
            obstacle.segments.add(segment);
        }
        this.edgeObstacles.add(obstacle);
    }

    public Set<Line> addLineInternal(MyEdge edge) {
        MyEdge inEdge = new MyEdge();
        inEdge.edge = edge.edge;
        inEdge.target = edge.target;
        inEdge.config = edge.config;
        for (Line segment : edge.segments) {
            inEdge.segments.add(segment);
        }
        edge.segments.clear();
        HashSet<Line> noCollidingSegments = new HashSet<Line>();
        int edgeIndex = 0;
        for (Line segment : inEdge.segments) {
            boolean join;
            boolean bl = join = this.joinConnectionsWithSameTarget && edge.config.allowJoin;
            if (!join && this.handledBridgeSegments.contains(segment)) {
                edge.segments.add(segment);
                ++edgeIndex;
                continue;
            }
            List<Intersection> intersections = this.getIntersections(segment);
            if (intersections == null || intersections.isEmpty()) {
                edge.segments.add(segment);
            } else {
                List<IntersectionGroup> groups = this.sortIntersectionsAlongSegment(intersections, segment);
                boolean lineJoin = this.processIntersections(edge, inEdge, segment, edgeIndex, groups, noCollidingSegments);
                if (lineJoin) break;
            }
            ++edgeIndex;
        }
        return noCollidingSegments;
    }

    private boolean processIntersections(MyEdge lineToConstruct, MyEdge edge, Line segment, int edgeIndex, List<IntersectionGroup> intersectionGroups, Set<Line> noCollidingSegments) {
        Point2D last = segment.getP1();
        boolean lineJoin = false;
        for (IntersectionGroup group : intersectionGroups) {
            List<Line> bridge;
            boolean intersectionIsOnSegment;
            boolean canJoin;
            Intersection intersectionWithSameTarget = this.getIntersectionWithSameTarget(edge, group);
            boolean bl = canJoin = this.canJoin != null && intersectionWithSameTarget != null && this.canJoin.apply((Tuple<Edge, IntersectionGroup>)new Tuple((Object)edge.edge, (Object)group)) != false;
            if (this.joinConnectionsWithSameTarget && edge.config.allowJoin && canJoin) {
                lineToConstruct.segments.add(new Line(last, intersectionWithSameTarget.p1));
                if (edge.config.replicateJoinedPath) {
                    Line line = new Line(intersectionWithSameTarget.p1, intersectionWithSameTarget.segment.getP2());
                    lineToConstruct.segments.add(line);
                    noCollidingSegments.add(line);
                    int index = intersectionWithSameTarget.edgeIndex + 1;
                    while (index < intersectionWithSameTarget.edge.segments.size()) {
                        line = intersectionWithSameTarget.edge.segments.get(index);
                        lineToConstruct.segments.add(line);
                        noCollidingSegments.add(line);
                        ++index;
                    }
                }
                lineToConstruct.joint = intersectionWithSameTarget.edge;
                lineJoin = true;
            }
            if (this.paintJoints && !this.handledBridgeSegments.contains(segment)) {
                for (Intersection inter : group.intersections) {
                    MyEdge intersectionEdge = inter.edge;
                    if (!intersectionEdge.edge.getForeColor().equals((Object)edge.edge.getForeColor())) continue;
                    this.paintJoint(group.p1, edge, edgeIndex, intersectionEdge, inter.edgeIndex);
                }
            }
            if (lineJoin) break;
            if (!this.paintBridges || !edge.config.allowBridge || this.handledBridgeSegments.contains(segment)) continue;
            boolean bl2 = intersectionIsOnSegment = MathUtil.getPointLineDistanceCut((Point2D)group.p1, (Line)segment) <= 0.0;
            if (!intersectionIsOnSegment || (bridge = this.createBridge(segment, group)) == null) continue;
            lineToConstruct.segments.add(new Line(last, bridge.get(1).getP1()));
            lineToConstruct.segments.add(bridge.get(1));
            lineToConstruct.segments.add(bridge.get(2));
            lineToConstruct.segments.add(bridge.get(3));
            noCollidingSegments.add(bridge.get(1));
            noCollidingSegments.add(bridge.get(2));
            noCollidingSegments.add(bridge.get(3));
            last = bridge.get(3).getP2();
        }
        if (!lineJoin) {
            lineToConstruct.segments.add(new Line(last, segment.getP2()));
        }
        return lineJoin;
    }

    private Point2D getPointBeforeIntersection(MyEdge edge, int edgeIndex, Point2D intersection) {
        Line line = edge.segments.get(edgeIndex);
        while (line != null && MathUtil.getPointPointDistance((Point2D)line.getP1(), (Point2D)intersection) <= 1.0) {
            Line line2 = line = --edgeIndex >= 0 ? edge.segments.get(edgeIndex) : null;
        }
        return line != null ? line.getP1() : null;
    }

    private Point2D getPointAfterIntersection(MyEdge edge, int edgeIndex, Point2D intersection) {
        Line line = edge.segments.get(edgeIndex);
        if (line != null && MathUtil.getPointPointDistance((Point2D)line.getP2(), (Point2D)intersection) <= 1.0) {
            line = ++edgeIndex < edge.segments.size() ? edge.segments.get(edgeIndex) : null;
        }
        return line != null ? line.getP2() : null;
    }

    private void paintJoint(Point2D p, MyEdge edge1, int index1, MyEdge edge2, int index2) {
        if (this.joints.contains(p)) {
            return;
        }
        Point2D p11 = this.getPointBeforeIntersection(edge1, index1, p);
        Point2D p12 = this.getPointAfterIntersection(edge1, index1, p);
        Point2D p21 = this.getPointBeforeIntersection(edge2, index2, p);
        Point2D p22 = this.getPointAfterIntersection(edge2, index2, p);
        if (p11 == null || p12 == null || p21 == null || p22 == null) {
            return;
        }
        long aIn = Math.round(this.alpha(p, p11) * 180.0 / Math.PI);
        long aOut = Math.round(this.alpha(p, p12) * 180.0 / Math.PI);
        long bIn = Math.round(this.alpha(p, p21) * 180.0 / Math.PI);
        long bOut = Math.round(this.alpha(p, p22) * 180.0 / Math.PI);
        int cnt = 0;
        if (aIn == bIn) {
            ++cnt;
        }
        if (aOut == bOut) {
            ++cnt;
        }
        if (cnt == 1) {
            if (this.showJoinDirections) {
                this.paintJoint(p, edge1.edge.getForeColor(), p22, p12);
            } else {
                this.paintJoint(p, edge1.edge.getForeColor(), new Point2D[0]);
            }
        }
    }

    private double alpha(Point2D p1, Point2D p2) {
        return this.alpha(p2.getX() - p1.getX(), p2.getY() - p1.getY());
    }

    private double alpha(double dx, double dy) {
        return Math.atan2(dy, dx);
    }

    private void paintJoint(Point2D p, Color color, Point2D ... directions) {
        this.joints.add(p);
        double R = 2.0;
        Node node = new Node();
        node.setX(p.getX() - R);
        node.setY(p.getY() - R);
        node.setWidth(2.0 * R);
        node.setHeight(2.0 * R);
        node.setSymbol((Symbol)new Circle());
        node.setForeColor(Color.BLACK);
        node.setBackColor(color);
        this.bridgeGroup.addNode(node);
        HashSet<Double> handledDirections = new HashSet<Double>();
        Point2D[] point2DArray = directions;
        int n = directions.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D outDirection = point2DArray[n2];
            double angle = Math.atan2(outDirection.getY() - p.getY(), outDirection.getX() - p.getX());
            if (!handledDirections.contains(angle)) {
                handledDirections.add(angle);
                Point2D a1 = this.rotate(new Point2D(0.0, 0.0), angle);
                Point2D a3 = this.rotate(new Point2D(1.0, 0.5), angle);
                Point2D a4 = this.rotate(new Point2D(0.0, 1.0), angle);
                Symbol s = new Symbol();
                PPolyline polyLine = new PPolyline();
                polyLine.setXArray(new double[]{a1.getX(), a3.getX(), a4.getX()});
                polyLine.setYArray(new double[]{a1.getY(), a3.getY(), a4.getY()});
                polyLine.setFill(true);
                s.addPrimitive((Primitive)polyLine);
                polyLine.setBackColor(Color.BLACK);
                Point2D pDir = MathUtil.movePoint((Point2D)p, (Point2D)outDirection, (double)3.0);
                R = 1.0;
                node = new Node();
                node.setX(pDir.getX() - R);
                node.setY(pDir.getY() - R);
                node.setWidth(2.0 * R);
                node.setHeight(2.0 * R);
                node.setSymbol(s);
                node.setForeColor(Color.BLACK);
                node.setBackColor(Color.WHITE);
                this.bridgeGroup.addNode(node);
            }
            ++n2;
        }
    }

    private Point2D rotate(Point2D p, double angle) {
        Point2D center = new Point2D(0.5, 0.5);
        double x = p.getX() - center.getX();
        double y = p.getY() - center.getY();
        double x2 = x * Math.cos(angle) - y * Math.sin(angle);
        double y2 = x * Math.sin(angle) + y * Math.cos(angle);
        return new Point2D(x2 + center.getX(), y2 + center.getY());
    }

    private boolean hasSameTarget(MyEdge edge, IntersectionGroup group) {
        for (Intersection intersection : group.intersections) {
            if (this.hasSameTarget(intersection.edge, edge)) continue;
            return false;
        }
        return true;
    }

    private Intersection getIntersectionWithSameTarget(MyEdge edge, IntersectionGroup group) {
        for (Intersection intersection : group.intersections) {
            if (!this.hasSameTarget(intersection.edge, edge)) continue;
            return intersection;
        }
        return null;
    }

    private List<IntersectionGroup> sortIntersectionsAlongSegment(List<Intersection> intersections, Line segment) {
        HashMap groups = new HashMap();
        intersections.forEach(intersection -> {
            boolean bl = map.computeIfAbsent(intersection.p1, (Function<Point2D, IntersectionGroup>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$1(net.edgemind.ibee.util.math.Point2D ), (Lnet/edgemind/ibee/util/math/Point2D;)Lnet/edgemind/ibee/ui/diagram/util/CrossingLineAvoider$IntersectionGroup;)()).intersections.add((Intersection)intersection);
        });
        Comparator sorter = (i1, i2) -> {
            double d2;
            double d1 = MathUtil.getPointPointDistance((Point2D)i1.p1, (Point2D)segment.getP1());
            double dist = d1 - (d2 = MathUtil.getPointPointDistance((Point2D)i2.p1, (Point2D)segment.getP1()));
            return dist < 0.0 ? -1 : (dist == 0.0 ? 0 : 1);
        };
        return groups.values().stream().sorted(sorter).collect(Collectors.toList());
    }

    private void mergeCloseIntersections(List<IntersectionGroup> intersections) {
        IntersectionGroup prev = null;
        for (IntersectionGroup next : new ArrayList<IntersectionGroup>(intersections)) {
            double d;
            if (prev != null && (d = MathUtil.getPointPointDistance((Point2D)prev.p2, (Point2D)next.p1)) < 10.0) {
                prev.p2 = next.p1;
                prev.intersections.addAll(next.intersections);
                intersections.remove(next);
                continue;
            }
            prev = next;
        }
    }

    private List<Intersection> getOverlappings(Line segment) {
        ArrayList<Intersection> intersections = new ArrayList<Intersection>();
        for (Obstacle obstacle : this.edgeObstacles) {
            int index = -1;
            for (Line obstacleSegment : obstacle.segments) {
                ++index;
                Line overlapping = this.getOverLapping(segment, obstacleSegment);
                if (overlapping == null) continue;
                Intersection intersection = new Intersection();
                intersection.edge = obstacle.edge;
                intersection.edgeIndex = index;
                intersection.p1 = overlapping.getP1();
                intersection.p2 = overlapping.getP2();
                intersection.segment = obstacleSegment;
                intersections.add(intersection);
            }
        }
        return intersections;
    }

    private List<Intersection> getIntersections(Line segment) {
        ArrayList<Intersection> intersections = new ArrayList<Intersection>();
        Line longerSegment = this.makeLonger(segment, 5.0);
        for (Obstacle obstacle : this.edgeObstacles) {
            int index = -1;
            for (Line existingSegment : obstacle.segments) {
                ++index;
                Point2D p = MathUtil.getLineIntersectionCut((Line)longerSegment, (Line)existingSegment);
                if (p == null) continue;
                Intersection intersection = new Intersection();
                intersection.edge = obstacle.edge;
                intersection.edgeIndex = index;
                intersection.p1 = p;
                intersection.p2 = p;
                intersection.segment = existingSegment;
                intersections.add(intersection);
            }
        }
        return intersections;
    }

    public Line makeLonger(Line line, double delta) {
        double dy;
        double dx = line.getX2() - line.getX1();
        double length = Math.sqrt(dx * dx + (dy = line.getY2() - line.getY1()) * dy);
        if (length == 0.0) {
            return line;
        }
        double unitDx = dx / length;
        double unitDy = dy / length;
        double newX2 = line.getX2() + unitDx * delta;
        double newY2 = line.getY2() + unitDy * delta;
        Line longerLine = new Line(line);
        longerLine.setX2(newX2);
        longerLine.setY2(newY2);
        return longerLine;
    }

    private Line getOverLapping(Line l1, Line l2) {
        double y2;
        double y1;
        if (this.isHorizontal(l1) && this.isHorizontal(l2) && l1.getY1() == l2.getY1()) {
            double x2;
            double x1 = Math.max(Math.min(l1.getX1(), l1.getX2()), Math.min(l2.getX1(), l2.getX2()));
            if (x1 < (x2 = Math.min(Math.max(l1.getX1(), l1.getX2()), Math.max(l2.getX1(), l2.getX2())))) {
                return new Line(x1, l1.getY1(), x2, l1.getY1());
            }
        } else if (this.isVertical(l1) && this.isVertical(l2) && l2.getX1() == l2.getX2() && (y1 = Math.max(Math.min(l1.getY1(), l1.getY2()), Math.min(l2.getY1(), l2.getY2()))) < (y2 = Math.min(Math.max(l1.getY1(), l1.getY2()), Math.max(l2.getY1(), l2.getY2())))) {
            return new Line(l1.getX1(), y1, l1.getX1(), y2);
        }
        return null;
    }

    private boolean isVertical(Line l) {
        return l.getX1() == l.getX2();
    }

    private boolean isHorizontal(Line l) {
        return l.getY1() == l.getY2();
    }

    private List<Line> createBridge(Line segment, IntersectionGroup group) {
        Point2D p0 = new Point2D(segment.getX1(), segment.getY1());
        Point2D p5 = new Point2D(segment.getX2(), segment.getY2());
        double test = MathUtil.getPointPointDistance((Point2D)p0, (Point2D)group.p1);
        if (test <= this.distance) {
            return null;
        }
        test = MathUtil.getPointPointDistance((Point2D)p5, (Point2D)group.p2);
        if (test <= this.distance) {
            return null;
        }
        for (Intersection intersection : group.intersections) {
            test = MathUtil.getPointPointDistance((Point2D)new Point2D(intersection.segment.getX1(), intersection.segment.getY1()), (Point2D)group.p1);
            if (test <= this.distance) {
                return null;
            }
            test = MathUtil.getPointPointDistance((Point2D)new Point2D(intersection.segment.getX2(), intersection.segment.getY2()), (Point2D)group.p2);
            if (!(test <= this.distance)) continue;
            return null;
        }
        Point2D p1 = MathUtil.movePoint((Point2D)group.p1, (Point2D)p0, (double)this.distance);
        Point2D p4 = MathUtil.movePoint((Point2D)group.p2, (Point2D)p5, (double)this.distance);
        Point2D p2 = MathUtil.movePoint((Point2D)p1, (Point2D)p0, (double)2.0943951023931953, (double)this.distance);
        Point2D p3 = MathUtil.movePoint((Point2D)p4, (Point2D)p5, (double)-2.0943951023931953, (double)this.distance);
        ArrayList<Line> result = new ArrayList<Line>();
        result.add(new Line(p0.getX(), p0.getY(), p1.getX(), p1.getY()));
        result.add(new Line(p1.getX(), p1.getY(), p2.getX(), p2.getY()));
        result.add(new Line(p2.getX(), p2.getY(), p3.getX(), p3.getY()));
        result.add(new Line(p3.getX(), p3.getY(), p4.getX(), p4.getY()));
        result.add(new Line(p4.getX(), p4.getY(), p5.getX(), p5.getY()));
        Edge edge = new Edge();
        edge.setForeColor(new Color(0, 255, 255));
        edge.setLineWidth(3.0);
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(Point.from((Point2D)p1));
        points.add(Point.from((Point2D)p4));
        edge.setPoints(points);
        return result;
    }

    private boolean hasSameTarget(MyEdge edge1, MyEdge edge2) {
        return edge1.target != null && edge1.target == edge2.target;
    }

    private boolean equals(Point2D target, Point2D curr) {
        return target.getX() == curr.getX() && target.getY() == curr.getY();
    }

    private boolean equals(Line target, Line curr) {
        return target.getX1() == curr.getX1() && target.getY1() == curr.getY1();
    }

    private Line getLast(List<Line> lines) {
        return this.getLast(lines, 0);
    }

    Line getLast(List<Line> lines, int index) {
        index = lines.size() - 1 - index;
        if (index >= 0) {
            return lines.get(index);
        }
        return null;
    }

    Point2D getLastPoint(List<Point2D> points) {
        return this.getLastPoint(points, 0);
    }

    Point2D getLastPoint(List<Point2D> points, int index) {
        index = points.size() - 1 - index;
        if (index >= 0) {
            return points.get(index);
        }
        return null;
    }

    public Group getBridgeGroup() {
        return this.bridgeGroup;
    }

    public void setBridgeGroup(Group bridgeGroup) {
        this.bridgeGroup = bridgeGroup;
    }

    public void setCanJoin(Function<Tuple<Edge, IntersectionGroup>, Boolean> canJoin) {
        this.canJoin = canJoin;
    }

    private static /* synthetic */ IntersectionGroup lambda$1(Point2D next) {
        return new IntersectionGroup(next, next);
    }

    public static class EdgeConfig {
        public boolean allowBridge = true;
        public boolean allowJoin = true;
        public boolean replicateJoinedPath = true;
    }

    public static class Intersection {
        public Point2D p1;
        public Point2D p2;
        public MyEdge edge;
        public Line segment;
        public int edgeIndex;
    }

    public static class IntersectionGroup {
        public List<Intersection> intersections = new ArrayList<Intersection>();
        public Point2D p1;
        public Point2D p2;

        public IntersectionGroup(Point2D p1, Point2D p2) {
            this.p1 = p1;
            this.p2 = p2;
        }
    }

    public static class MyEdge {
        public List<Line> segments = new ArrayList<Line>();
        public Object target;
        public MyEdge joint;
        public Edge edge;
        public EdgeConfig config = new EdgeConfig();
        public int joinIndex;
        public Obstacle obstacle;
    }

    public static class Obstacle {
        public MyEdge edge;
        public List<Line> segments = new ArrayList<Line>();
    }
}

