/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.ui.diagram.util;

import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.core.diagram.Diagram;
import net.edgemind.ibee.core.diagram.Edge;
import net.edgemind.ibee.core.diagram.Group;
import net.edgemind.ibee.core.diagram.Point;
import net.edgemind.ibee.ui.diagram.util.CrossingLineAvoider;
import net.edgemind.ibee.ui.diagram.util.MyEdgeSet;
import net.edgemind.ibee.util.math.Line;
import net.edgemind.ibee.util.misc.IFilter;

public class MyEdgeConverter {
    private IFilter<Edge> edgeFilter;

    public void setFilter(IFilter<Edge> edgeFilter) {
        this.edgeFilter = edgeFilter;
    }

    public MyEdgeSet convert(Diagram diagram) {
        MyEdgeSet myEdges = new MyEdgeSet();
        for (Group g : diagram.getGroups()) {
            this.convertToMyEdges(g, myEdges);
        }
        return myEdges;
    }

    private void convertToMyEdges(Group group, MyEdgeSet myEdges) {
        for (Edge edge : group.getEdges()) {
            this.convertToMyEdges(edge, myEdges);
        }
        for (Group g : group.getGroups()) {
            this.convertToMyEdges(g, myEdges);
        }
    }

    private void convertToMyEdges(Edge edge, MyEdgeSet edges) {
        CrossingLineAvoider.MyEdge tmpEdge;
        if ((this.edgeFilter == null || this.edgeFilter.accept((Object)edge)) && (tmpEdge = this.toMyEdge(edge)) != null) {
            edges.add(tmpEdge);
        }
    }

    public CrossingLineAvoider.MyEdge toMyEdge(Edge edge) {
        CrossingLineAvoider.MyEdge result = new CrossingLineAvoider.MyEdge();
        result.edge = edge;
        result.target = edge.getTarget();
        List points = edge.getPoints();
        int i = 1;
        while (i < points.size()) {
            Line segment = new Line(((Point)points.get(i - 1)).getX(), ((Point)points.get(i - 1)).getY(), ((Point)points.get(i)).getX(), ((Point)points.get(i)).getY());
            result.segments.add(segment);
            ++i;
        }
        return result;
    }

    public void fromMyEdge(CrossingLineAvoider.MyEdge myEdge, Edge edge) {
        if (myEdge.segments.size() == 0) {
            edge.setPoints(new ArrayList());
            return;
        }
        ArrayList<Point> points = new ArrayList<Point>();
        int i = 0;
        while (i < myEdge.segments.size()) {
            Line segment = myEdge.segments.get(i);
            points.add(new Point(segment.getX1(), segment.getY1()));
            ++i;
        }
        Line lastSegment = myEdge.segments.get(myEdge.segments.size() - 1);
        points.add(new Point(lastSegment.getX2(), lastSegment.getY2()));
        edge.setPoints(points);
    }
}

