/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.ui.diagram.viewer;

import jsinterop.annotations.JsIgnore;
import jsinterop.annotations.JsType;
import net.edgemind.ibee.core.diagram.Diagram;
import net.edgemind.ibee.core.diagram.Group;
import net.edgemind.ibee.ui.diagram.DiagramPanel;
import net.edgemind.ibee.ui.diagram.DiagramUtil;
import net.edgemind.ibee.ui.diagram.viewer.IDiagramViewer;

@JsType(namespace="ui")
public class DiagramViewer
implements IDiagramViewer {
    protected DiagramPanel diagramPanel;
    protected double marginY = 0.0;
    protected double marginX = 0.0;

    public DiagramViewer(DiagramPanel diagramPanel) {
        this.diagramPanel = diagramPanel;
    }

    @Override
    public double getMarginX() {
        return this.marginX;
    }

    @Override
    public double getMarginY() {
        return this.marginY;
    }

    @JsIgnore
    public void setMargin(int marginX, int marginY) {
        this.marginX = marginX;
        this.marginY = marginY;
    }

    @Override
    public DiagramPanel getDiagramPanel() {
        return this.diagramPanel;
    }

    @Override
    public Diagram getDiagram() {
        return this.diagramPanel.getDiagram();
    }

    @Override
    public void paintOverlay() {
        this.diagramPanel.paintOverlay();
    }

    @Override
    public void addOverlay(Group overlay) {
        this.diagramPanel.addOverlay(overlay);
    }

    @Override
    public void refresh() {
        this.diagramPanel.paintDiagram();
    }

    @Override
    public void setDiagram(Diagram diagram) {
        this.diagramPanel.setDiagram(diagram);
    }

    @Override
    public void create() {
        this.getDiagramPanel().create();
    }

    @Override
    public void setMargin(double marginX, double marginY) {
        this.marginX = marginX;
        this.marginY = marginY;
    }

    @Override
    public double getZoomX() {
        return this.diagramPanel.getZoomX();
    }

    @Override
    public double getZoomY() {
        return this.diagramPanel.getZoomY();
    }

    @Override
    public void setZoomX(double zoomX) {
        this.diagramPanel.setZoomX(zoomX);
    }

    @Override
    public void setZoomY(double zoomY) {
        this.diagramPanel.setZoomY(zoomY);
    }

    @Override
    public double getScreenWidth() {
        return this.diagramPanel.getClientWidth();
    }

    @Override
    public double getScreenHeight() {
        return this.diagramPanel.getClientHeight();
    }

    @Override
    public void setTranslateX(double translateX) {
        this.diagramPanel.setTranslateX(translateX);
    }

    @Override
    public void setTranslateY(double translateY) {
        this.diagramPanel.setTranslateY(translateY);
    }

    @Override
    public double getTranslateX() {
        return this.diagramPanel.getTranslateX();
    }

    @Override
    public double getTranslateY() {
        return this.diagramPanel.getTranslateY();
    }

    protected DiagramUtil.Coord createCoord(double screenX, double screenY) {
        DiagramUtil.Coord coord = new DiagramUtil.Coord();
        coord.diagramX = this.diagramPanel.translateX(screenX);
        coord.diagramY = this.diagramPanel.translateY(screenY);
        coord.screenX = screenX;
        coord.screenY = screenY;
        return coord;
    }
}

