/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.ui.diagram.viewer;

import jsinterop.annotations.JsType;
import net.edgemind.ibee.core.diagram.DElement;
import net.edgemind.ibee.core.diagram.Diagram;
import net.edgemind.ibee.core.diagram.DiagramData;
import net.edgemind.ibee.core.diagram.Node;
import net.edgemind.ibee.ui.charts.YChartElement;
import net.edgemind.ibee.ui.common.listener.IMouseDownListener;
import net.edgemind.ibee.ui.common.listener.IMouseMoveListener;
import net.edgemind.ibee.ui.common.listener.IMouseScrollListener;
import net.edgemind.ibee.ui.common.listener.IMouseUpListener;
import net.edgemind.ibee.ui.diagram.DiagramPanel;
import net.edgemind.ibee.ui.diagram.DiagramUtil;
import net.edgemind.ibee.ui.diagram.MouseButton;
import net.edgemind.ibee.ui.diagram.viewer.DiagramViewer;
import net.edgemind.ibee.util.math.Frame;

@JsType(namespace="ui")
public class ScrolledViewer
extends DiagramViewer {
    private boolean down = false;
    double lastX;
    double lastY;
    double offsetX = 0.0;
    double offsetY = 0.0;
    protected boolean canZoomHorizontal = false;
    protected boolean canZoomVertical = false;
    protected boolean canTranslateHorizontal = false;
    protected boolean canTranslateVertical = false;

    public void canZoomHorizontal(boolean value) {
        this.canZoomHorizontal = value;
    }

    public void canZoomVertical(boolean value) {
        this.canZoomVertical = value;
    }

    public void canTranslateHorizontal(boolean value) {
        this.canTranslateHorizontal = value;
    }

    public void canTranslateVertical(boolean value) {
        this.canTranslateVertical = value;
    }

    protected void decZoomX() {
        if (this.canZoomHorizontal) {
            double newZoom = this.getDiagramPanel().getZoomX() / 1.2;
            this.getDiagramPanel().setZoomX(newZoom);
        }
    }

    protected void decZoomY() {
        if (this.canZoomVertical) {
            this.getDiagramPanel().setZoomY(this.getDiagramPanel().getZoomY() / 1.2);
        }
    }

    protected void incZoomX() {
        if (this.canZoomHorizontal) {
            double newZoom = this.getDiagramPanel().getZoomX() * 1.2;
            this.getDiagramPanel().setZoomX(newZoom);
        }
    }

    protected void incZoomY() {
        if (this.canZoomVertical) {
            this.getDiagramPanel().setZoomY(this.getDiagramPanel().getZoomY() * 1.2);
        }
    }

    public ScrolledViewer(DiagramPanel diagramPanel) {
        super(diagramPanel);
        this.getDiagramPanel().setToolbarEnabled(true);
        this.getDiagramPanel().setContextMenuEnabled(true);
        this.getDiagramPanel().setHorizontalScrollbarEnabled(true);
        this.getDiagramPanel().setVerticalScrollbarEnabled(true);
        this.diagramPanel.translateToCenterX(true);
        this.diagramPanel.translateToCenterY(true);
    }

    @Override
    public void create() {
        this.diagramPanel.addMouseScrollListener(new IMouseScrollListener(){

            @Override
            public void mouseScroll(int count) {
                if (!(ScrolledViewer.this.canTranslateHorizontal || ScrolledViewer.this.canTranslateVertical || ScrolledViewer.this.canZoomVertical || ScrolledViewer.this.canZoomHorizontal)) {
                    return;
                }
                ScrolledViewer.this.offsetX = ScrolledViewer.this.diagramPanel.getTranslateX() + ScrolledViewer.this.marginX;
                ScrolledViewer.this.offsetY = ScrolledViewer.this.diagramPanel.getTranslateY() + ScrolledViewer.this.marginY;
                boolean zoomed = false;
                boolean translated = false;
                if (ScrolledViewer.this.canZoomVertical) {
                    if (count > 0) {
                        ScrolledViewer.this.decZoomY();
                    } else {
                        ScrolledViewer.this.incZoomY();
                    }
                    zoomed = true;
                }
                if (ScrolledViewer.this.canTranslateVertical && !zoomed) {
                    ScrolledViewer.this.offsetY += (double)(count * 30) / ScrolledViewer.this.diagramPanel.getZoomY();
                    translated = true;
                }
                if (ScrolledViewer.this.canZoomHorizontal && !translated) {
                    if (count > 0) {
                        ScrolledViewer.this.decZoomX();
                    } else {
                        ScrolledViewer.this.incZoomX();
                    }
                    zoomed = true;
                }
                if (ScrolledViewer.this.canTranslateHorizontal && !translated && !zoomed) {
                    ScrolledViewer.this.offsetX += (double)(count * 30) / ScrolledViewer.this.diagramPanel.getZoomX();
                }
                ScrolledViewer.this.refresh();
            }
        });
        this.diagramPanel.addMouseDownListener(new IMouseDownListener(){

            @Override
            public void mouseDown(double x, double y, MouseButton btn) {
                DiagramData data;
                DElement e = DiagramUtil.getSelectedDiagramElement(ScrolledViewer.this.diagramPanel.getDiagram(), ScrolledViewer.this.createCoord(x, y), ScrolledViewer.this.diagramPanel.getZoomX(), ScrolledViewer.this.diagramPanel.getZoomY());
                if (e != null && e instanceof Node && (data = e.getData()) instanceof YChartElement) {
                    return;
                }
                ScrolledViewer.this.down = true;
                ScrolledViewer.this.lastX = x / ScrolledViewer.this.diagramPanel.getZoomX();
                ScrolledViewer.this.lastY = y / ScrolledViewer.this.diagramPanel.getZoomY();
            }
        });
        this.diagramPanel.addMouseUpListener(new IMouseUpListener(){

            @Override
            public void mouseUp(double x, double y, MouseButton btn) {
                ScrolledViewer.this.down = false;
                ScrolledViewer.this.refresh();
            }
        });
        this.diagramPanel.addMouseMoveListener(new IMouseMoveListener(){

            @Override
            public void mouseMove(double x, double y) {
                ScrolledViewer.this.offsetX = ScrolledViewer.this.diagramPanel.getTranslateX() + ScrolledViewer.this.marginX;
                ScrolledViewer.this.offsetY = ScrolledViewer.this.diagramPanel.getTranslateY() + ScrolledViewer.this.marginY;
                if (ScrolledViewer.this.down) {
                    if (ScrolledViewer.this.canTranslateHorizontal) {
                        ScrolledViewer.this.offsetX -= (x /= ScrolledViewer.this.diagramPanel.getZoomX()) - ScrolledViewer.this.lastX;
                        ScrolledViewer.this.lastX = x;
                    }
                    if (ScrolledViewer.this.canTranslateVertical) {
                        ScrolledViewer.this.offsetY -= (y /= ScrolledViewer.this.diagramPanel.getZoomY()) - ScrolledViewer.this.lastY;
                        ScrolledViewer.this.lastY = y;
                    }
                    if (ScrolledViewer.this.canTranslateHorizontal || ScrolledViewer.this.canTranslateVertical) {
                        ScrolledViewer.this.refresh();
                    }
                }
            }
        });
        super.create();
    }

    @Override
    public void setDiagram(Diagram diagram) {
        super.setDiagram(diagram);
        if (diagram != null) {
            Frame frame = new Frame();
            frame.copy(this.diagramPanel.getDiagram().getSize(false));
            frame.setX(frame.getX() - this.marginX);
            frame.setY(frame.getY() - this.marginY);
            frame.setWidth(frame.getWidth() + 2.0 * this.marginX);
            frame.setHeight(frame.getHeight() + 2.0 * this.marginY);
            if (!this.diagramPanel.translateToCenterX()) {
                double width = this.diagramPanel.getClientWidth();
                frame.setWidth(frame.getWidth() - width / this.diagramPanel.getZoomX());
            }
            if (!this.diagramPanel.translateToCenterY()) {
                double height = this.diagramPanel.getClientHeight();
                frame.setHeight(frame.getHeight() - height / this.diagramPanel.getZoomY());
            }
            this.diagramPanel.setScrollableFrame(frame);
            this.diagramPanel.center(true);
            this.offsetX = this.diagramPanel.getTranslateX();
            this.offsetY = this.diagramPanel.getTranslateY();
        }
    }

    @Override
    public void refresh() {
        if (this.diagramPanel.getDiagram() != null) {
            Frame frame = new Frame();
            frame.copy(this.diagramPanel.getDiagram().getSize(false));
            frame.setX(frame.getX() - this.marginX);
            frame.setY(frame.getY() - this.marginY);
            frame.setWidth(frame.getWidth() + 2.0 * this.marginX);
            frame.setHeight(frame.getHeight() + 2.0 * this.marginY);
            this.diagramPanel.setTranslateX(this.offsetX);
            this.diagramPanel.setTranslateY(this.offsetY);
            if (!this.diagramPanel.translateToCenterX()) {
                double width = this.diagramPanel.getClientWidth();
                frame.setWidth(frame.getWidth() - width / this.diagramPanel.getZoomX());
            }
            if (!this.diagramPanel.translateToCenterY()) {
                double height = this.diagramPanel.getClientHeight();
                frame.setHeight(frame.getHeight() - height / this.diagramPanel.getZoomY());
            }
            this.diagramPanel.setScrollableFrame(frame);
        }
        this.diagramPanel.adaptScrollBars(true);
        this.diagramPanel.paintDiagram();
    }
}

