/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.ui.dialog;

import java.util.List;
import net.edgemind.ibee.core.command.CommandStack;
import net.edgemind.ibee.core.command.IUndoRedoCommand;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.resource.edit.RecordCommand;
import net.edgemind.ibee.ui.dialog.Dialog;
import net.edgemind.ibee.ui.dialog.OpenPropertyDialogCommand;
import net.edgemind.ibee.ui.dialog.PropertyDialogDesc;
import net.edgemind.ibee.ui.property.ICommitAble;
import net.edgemind.ibee.ui.property.IProperty;
import net.edgemind.ibee.ui.property.IPropertySheet;

public class PropertyDialog
extends Dialog {
    public static String SELECT_FULL_TEXT = "SELECT_FULL_TEXT";
    public static String SET_FOCUS = "SET_FOCUS";
    public static String SET_IS_FILE = "SET_IS_FILE";
    public static String SET_IS_FOLDER = "SET_IS_FOLDER";
    public static String SET_FILE_WRITE = "SET_FILE_WRITE";

    public PropertyDialog(PropertyDialogDesc dialogDesc) {
        super(dialogDesc);
    }

    public PropertyDialog() {
        super(new PropertyDialogDesc());
    }

    public void addProperty(IProperty<?> property) {
        this.getDialogDesc().addProperty(property);
    }

    public void addProperties(List<? extends IProperty<?>> properties) {
        for (IProperty<?> p : properties) {
            this.addProperty(p);
        }
    }

    @Override
    public void open() {
        OpenPropertyDialogCommand cmd = new OpenPropertyDialogCommand(this);
        cmd.execute();
    }

    @Override
    public PropertyDialogDesc getDialogDesc() {
        return (PropertyDialogDesc)this.dialogDesc;
    }

    public boolean isValid() {
        return this.getDialogDesc().isValid();
    }

    public void setValid(boolean valid) {
        this.getDialogDesc().setValid(valid);
    }

    public IPropertySheet getPropertySheet() {
        return this.getDialogDesc().getPropertySheet();
    }

    public void applyProperties(IbeeResource resource) {
        this.applyProperties(resource, resource.getEditingDomain().getCommandStack());
    }

    public void applyProperties(IbeeResource resource, CommandStack cmdStack) {
        cmdStack.executeWithoutError((IUndoRedoCommand)new RecordCommand(resource){

            protected void executeRecorded() {
                for (IProperty<?> property : PropertyDialog.this.getPropertySheet().getProperties()) {
                    if (!(property instanceof ICommitAble)) continue;
                    ((ICommitAble)((Object)property)).commit();
                }
            }
        });
    }
}

