/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.ui.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.edgemind.ibee.core.app.IEventHandler;
import net.edgemind.ibee.core.util.Selection;
import net.edgemind.ibee.ui.column.Column;
import net.edgemind.ibee.ui.column.IValueProvider;
import net.edgemind.ibee.ui.common.event.MouseDblClickEvent;
import net.edgemind.ibee.ui.common.event.SelectionEvent;
import net.edgemind.ibee.ui.z.renderer.AZComponent;
import net.edgemind.ibee.util.misc.IFilter;

public class Table<T>
extends AZComponent {
    protected List<Column<T>> tableColumns;
    protected List<T> tableData;
    protected Selection<T> selection = new Selection();
    private IFilter<T> filter;
    private boolean tooltipEnabled = true;
    private boolean sortEnabled = true;
    private boolean cellSelectionEnabled = false;

    public Table() {
        this.tableColumns = new ArrayList<Column<T>>();
    }

    public List<Column<T>> getTableColumns() {
        return this.tableColumns;
    }

    public void setTableData(List<T> data) {
        this.tableData = data;
    }

    public List<T> getTableData() {
        return this.tableData;
    }

    public void addColumn(Column<T> column) {
        this.tableColumns.add(column);
    }

    public Column<T> createColumn(String title, IValueProvider<T> valueProvider) {
        Column<T> col = new Column<T>();
        col.setTitle(title);
        col.setValueProvider(valueProvider);
        this.addColumn(col);
        return col;
    }

    public void removeColumn(Column<T> column) {
        this.tableColumns.remove(column);
    }

    public int getColumnCount() {
        return this.tableColumns.size();
    }

    public int getRowCount() {
        if (this.tableData == null) {
            return 0;
        }
        return this.tableData.size();
    }

    public void onSelect(IEventHandler<SelectionEvent<T>> listener) {
        this.onEvent(SelectionEvent.class, event -> {
            this.selection = new Selection();
            this.selection.addAll(event.getItems());
            listener.handleEvent(event);
        });
    }

    public void onDoubleClick(IEventHandler<MouseDblClickEvent<T>> listener) {
        this.onEvent(MouseDblClickEvent.class, arg_0 -> listener.handleEvent(arg_0));
    }

    public Selection<T> getSelection() {
        return this.selection;
    }

    public void changeSelection(T selection) {
        ArrayList<T> sel = new ArrayList<T>();
        sel.add(selection);
        this.changeSelection((Collection<T>)sel);
    }

    public void changeSelection(Collection<T> selection) {
        if (selection == null && this.selection == null) {
            return;
        }
        if (selection != null && this.selection != null && selection.equals(this.selection.getElements())) {
            return;
        }
        this.selection.clear();
        this.selection.addAll(selection);
        this.fireEvent(new SelectionEvent<T>(selection));
    }

    public void setFilter(IFilter<T> filter) {
        this.filter = filter;
    }

    public IFilter<T> getFilter() {
        return this.filter;
    }

    public void resetColumns() {
        this.tableColumns.clear();
    }

    public boolean isCellSelectionEnabled() {
        return this.cellSelectionEnabled;
    }

    public void setCellSelectionEnabled(boolean cellSelectionEnabled) {
        this.cellSelectionEnabled = cellSelectionEnabled;
    }

    public boolean isTooltipEnabled() {
        return this.tooltipEnabled;
    }

    public void setTooltipEnabled(boolean tooltipEnabled) {
        this.tooltipEnabled = tooltipEnabled;
    }

    public boolean isSortEnabled() {
        return this.sortEnabled;
    }

    public void setSortEnabled(boolean sortEnabled) {
        this.sortEnabled = sortEnabled;
    }
}

