/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.ui.toolbar;

import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.ui.toolbar.IToolbar;
import net.edgemind.ibee.ui.toolbar.IToolbarItem;

public class ToolBar
implements IToolbar {
    protected List<IToolbarItem> tbItems = new ArrayList<IToolbarItem>();
    protected List<IToolbar.SelectionListener> selectionListeners;
    private boolean refreshNeeded = false;

    @Override
    public List<IToolbarItem> getItems() {
        return this.tbItems;
    }

    @Override
    public void addItems(List<IToolbarItem> items) {
        this.tbItems.addAll(items);
        this.refreshNeeded = true;
    }

    @Override
    public void addItem(IToolbarItem item) {
        this.tbItems.add(item);
        this.refreshNeeded = true;
    }

    @Override
    public void addItem(IToolbarItem item, int index) {
        this.tbItems.add(index, item);
        this.refreshNeeded = true;
    }

    @Override
    public void removeItem(IToolbarItem item) {
        this.tbItems.remove(item);
        this.refreshNeeded = true;
    }

    @Override
    public void clear() {
        this.tbItems.clear();
        this.refreshNeeded = true;
    }

    @Override
    public void addSelectionListener(IToolbar.SelectionListener listener) {
        if (this.selectionListeners == null) {
            this.selectionListeners = new ArrayList<IToolbar.SelectionListener>();
        }
        this.selectionListeners.add(listener);
    }

    public void notifySelection(IToolbarItem item) {
        if (this.selectionListeners == null) {
            return;
        }
        for (IToolbar.SelectionListener listener : this.selectionListeners) {
            listener.select(item);
        }
    }

    @Override
    public boolean refreshNeeded() {
        return this.refreshNeeded;
    }

    @Override
    public void refreshNeeded(boolean value) {
        this.refreshNeeded = value;
    }
}

