/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.ui.toolbar;

import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.ui.common.listener.IMouseClickedListener;
import net.edgemind.ibee.ui.diagram.MouseButton;
import net.edgemind.ibee.ui.toolbar.Direction;
import net.edgemind.ibee.ui.toolbar.IToolbarRenderer;

public abstract class ToolbarPanel {
    protected List<IMouseClickedListener> mouseClickedListeners;
    protected Direction direction;

    public abstract IToolbarRenderer getToolbarRenderer();

    public ToolbarPanel(Direction direction) {
        this.direction = direction;
    }

    public void addMouseClickListener(IMouseClickedListener listener, Direction direction) {
        if (this.mouseClickedListeners == null) {
            this.mouseClickedListeners = new ArrayList<IMouseClickedListener>();
        }
        this.mouseClickedListeners.add(listener);
    }

    public void mouseClick(double x, double y, MouseButton btn) {
        if (this.mouseClickedListeners == null) {
            return;
        }
        for (IMouseClickedListener listener : this.mouseClickedListeners) {
            listener.mouseClicked(x, y, btn);
        }
    }
}

