/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.ui.z;

import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.ui.common.event.MouseOverEvent;
import net.edgemind.ibee.ui.common.event.SelectionEvent;
import net.edgemind.ibee.ui.common.listener.MouseOverListener;
import net.edgemind.ibee.ui.common.listener.SelectionListener;
import net.edgemind.ibee.ui.z.ZImage;
import net.edgemind.ibee.ui.z.renderer.AZComponent;

public class ZButton
extends AZComponent {
    private String text;
    private ZImage image;
    private String tooltip;
    private boolean canToggle = false;
    private boolean toggleStatus = false;
    private List<SelectionListener<ZButton>> clickHandler = new ArrayList<SelectionListener<ZButton>>();
    private List<MouseOverListener<ZButton>> mouseOverHandler = new ArrayList<MouseOverListener<ZButton>>();

    public ZButton() {
        this.text = "";
    }

    public ZButton(String text) {
        this.text = text;
    }

    public void canToggle(boolean v) {
        this.canToggle = v;
        if (this.canToggle) {
            this.addStyle("btntoggle");
            this.removeStyle("btnnontoggle");
        } else {
            this.addStyle("btnnontoggle");
            this.removeStyle("btntoggle");
        }
    }

    public boolean canToggle() {
        return this.canToggle;
    }

    public boolean getToggleStatus() {
        return this.toggleStatus;
    }

    public void setToggleStatus(boolean clicked) {
        this.toggleStatus = clicked;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setImage(ZImage image) {
        this.image = image;
    }

    public ZImage getImage() {
        return this.image;
    }

    public void addClickHandler(SelectionListener<ZButton> l) {
        this.clickHandler.add(l);
    }

    public void addMouseMoveHandler(MouseOverListener<ZButton> l) {
        this.mouseOverHandler.add(l);
    }

    public List<SelectionListener<ZButton>> getClickHandler() {
        return this.clickHandler;
    }

    public void fireClick(double x, double y) {
        for (SelectionListener<ZButton> l : this.clickHandler) {
            l.onSelect(new SelectionEvent<ZButton>(this, x, y));
        }
    }

    public void fireMouseOver(double x, double y) {
        for (MouseOverListener<ZButton> l : this.mouseOverHandler) {
            l.onMouseOver(new MouseOverEvent<ZButton>(this, x, y));
        }
    }

    @Override
    protected String[] getDefaultStyles() {
        return new String[]{"zbutton"};
    }
}

