/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.ui.z.renderer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.edgemind.ibee.core.app.IEvent;
import net.edgemind.ibee.core.app.IEventHandler;
import net.edgemind.ibee.ui.z.renderer.IZComponent;
import net.edgemind.ibee.ui.z.renderer.IZRenderer;

public abstract class AZComponent
implements IZComponent {
    protected IZRenderer<IZComponent> renderer;
    protected String id;
    protected List<String> styles;
    private Object uiObject;
    private Map<Class<?>, IEventHandler<?>> eventHandlers = new HashMap();

    protected AZComponent() {
        String[] defaultStyles = this.getDefaultStyles();
        if (defaultStyles != null) {
            String[] stringArray = defaultStyles;
            int n = defaultStyles.length;
            int n2 = 0;
            while (n2 < n) {
                String style = stringArray[n2];
                this.addStyle(style);
                ++n2;
            }
        }
    }

    @Override
    public void refresh() {
        if (this.renderer == null) {
            return;
        }
        this.renderer.render(this);
    }

    public void setRenderer(IZRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public IZRenderer<IZComponent> getRenderer() {
        return this.renderer;
    }

    public List<String> getStyles() {
        if (this.styles == null) {
            return Collections.emptyList();
        }
        return this.styles;
    }

    public void addStyle(String style) {
        if (this.styles == null) {
            this.styles = new ArrayList<String>();
        }
        if (this.styles.contains(style)) {
            return;
        }
        this.styles.add(style);
    }

    public void removeStyle(String style) {
        if (this.styles == null) {
            return;
        }
        this.styles.remove(style);
    }

    protected String[] getDefaultStyles() {
        return null;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public Object getUIObject() {
        return this.uiObject;
    }

    @Override
    public void setUIObject(Object object) {
        this.uiObject = object;
    }

    public <U extends IEvent> void onEvent(Class<U> clazz, IEventHandler<U> eventHandler) {
        this.eventHandlers.put(clazz, eventHandler);
    }

    public <U extends IEvent> void fireEvent(U event) {
        IEventHandler<?> eventHandler = this.eventHandlers.get(event.getClass());
        if (eventHandler != null) {
            eventHandler.handleEvent(event);
        }
    }
}

