/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.util.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.edgemind.ibee.util.exec.IRunnableWithException1E;
import net.edgemind.ibee.util.misc.IFilter;
import net.edgemind.ibee.util.system.SystemUtil;

public class FileUtil {
    public static boolean acceptFile(String filename, String extension) {
        if (extension == null) {
            return true;
        }
        return filename.endsWith(extension);
    }

    public static String addExtension(String path, String extension) {
        if (extension == null) {
            return path;
        }
        if (!((String)path).toLowerCase().endsWith("." + extension.toLowerCase())) {
            path = (String)path + "." + extension;
        }
        return path;
    }

    public static boolean copyFileOrDir(File fileOrDir, File targetDir) throws IOException {
        return FileUtil.copyFileOrDir(fileOrDir.getAbsolutePath(), targetDir.getAbsolutePath());
    }

    public static boolean copyFileOrDir(String fileOrDir, String targetDir) throws IOException {
        boolean isAsterisk;
        File file;
        if (!FileUtil.fileExists(targetDir)) {
            FileUtil.createDir(targetDir);
        }
        if ((file = (isAsterisk = FileUtil.extractFileName(fileOrDir).equals("*")) ? new File(FileUtil.extractFileDir(fileOrDir)) : new File(fileOrDir)).exists()) {
            if (file.isDirectory()) {
                File[] files;
                Object subDir = targetDir + File.separator + file.getName();
                if (isAsterisk) {
                    subDir = targetDir;
                }
                if ((files = file.listFiles()) != null) {
                    int index = 0;
                    while (index < files.length) {
                        FileUtil.copyFileOrDir(files[index].getAbsolutePath(), (String)subDir);
                        ++index;
                    }
                }
            }
            if (file.isFile()) {
                FileUtil.copyFile(file, new File(targetDir + File.separator + file.getName()));
            }
        }
        return true;
    }

    public static void copyFile(InputStream input, OutputStream output) throws IOException {
        input.transferTo(output);
    }

    public static void copyFile(InputStream input, File dest) throws IOException {
        Files.copy(input, dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void copyFile(File source, File dest) throws IOException {
        Files.copy(source.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void createDir(File dir) throws IOException {
        FileUtil.createDir(dir.getAbsolutePath());
    }

    public static void createDir(String dirName) throws IOException {
        File f = new File(dirName);
        if (f.exists()) {
            if (f.isDirectory()) {
                return;
            }
            throw new IOException("cannot create directory " + dirName + ": file with same name exists");
        }
        if (!new File(dirName).mkdirs()) {
            throw new IOException("cannot create directory " + dirName + ": no permission?");
        }
    }

    public static void createFile(String filePath, String content) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(filePath, new String[0]), StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
            writer.write(content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static File createTempDirectory() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }

    public static boolean deleteFile(String path) {
        File f = new File(path);
        return FileUtil.deleteFile(f);
    }

    public static boolean deleteFile(File f) {
        if (f.exists()) {
            File[] files;
            if (f.isDirectory() && (files = f.listFiles()) != null) {
                int index = 0;
                while (index < files.length) {
                    File file = files[index];
                    FileUtil.deleteFile(file);
                    ++index;
                }
            }
            return f.delete();
        }
        return false;
    }

    public static boolean dirExists(String fileName) {
        File f = new File(fileName);
        return f.exists() && f.isDirectory();
    }

    public static boolean dirIsEmpty(String dir) {
        File testFile = new File(dir);
        if (!testFile.exists()) {
            return true;
        }
        return testFile.listFiles() != null && testFile.listFiles().length == 0;
    }

    public static String extractFileDir(String filePath) {
        if (filePath == null) {
            return null;
        }
        return FileUtil.extractFileDir(new File(filePath));
    }

    public static String extractFileDir(File file) {
        if (file == null) {
            return null;
        }
        String parent = file.getParent();
        if (parent == null) {
            parent = "";
        }
        return parent;
    }

    public static String extractFileName(String filePath) {
        if (filePath == null) {
            return null;
        }
        return new File(filePath).getName();
    }

    public static boolean fileExists(File file) {
        return file.exists();
    }

    public static boolean fileExists(String fileName) {
        if (fileName == null) {
            return false;
        }
        if (fileName.startsWith("file://")) {
            fileName = fileName.substring("file://".length());
        }
        File file = new File(fileName);
        return file.exists();
    }

    public static String getDir(String path) {
        int index = -1;
        index = path.length() - 1;
        while (index >= 0) {
            if (path.charAt(index) == '/' || path.charAt(index) == '\\') break;
            --index;
        }
        if (index >= 0) {
            path = path.substring(0, index + 1);
        }
        return path;
    }

    public static String getExtension(String path) {
        if (path == null) {
            return null;
        }
        int index = path.lastIndexOf(".");
        if (index >= 0) {
            String extension = path.substring(index + 1);
            if (extension.contains(File.separator)) {
                return null;
            }
            return extension;
        }
        return null;
    }

    public static String getExtension(File file) {
        return FileUtil.getExtension(file.getAbsolutePath());
    }

    public static String getFileName(String path) {
        return FileUtil.extractFileName(path);
    }

    public static long getFolderSize(String dirName) {
        return FileUtil.getFolderSize(new File(dirName));
    }

    public static long getFolderSize(File directory) {
        long length = 0L;
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            length = file.isFile() ? (length += file.length()) : (length += FileUtil.getFolderSize(file));
            ++n2;
        }
        return length;
    }

    public static String getRelativePath(String path, String base) {
        return FileUtil.getRelativePath(new File(path), new File(base));
    }

    public static String getRelativePath(File path, File base) {
        URI relative = FileUtil.getRelativeURI(path, base);
        if (relative != null) {
            return relative.getPath();
        }
        return null;
    }

    public static URI getRelativeURI(File child, File parent) {
        URI childURI;
        URI parentURI = parent.toURI();
        URI rel = parentURI.relativize(childURI = child.toURI());
        if (rel == null || rel == childURI) {
            return null;
        }
        return rel;
    }

    public static String getParentDir(String dir) {
        while (dir.endsWith(File.separator)) {
            dir = dir.substring(0, dir.length() - 1);
        }
        String result = FileUtil.getDir(dir);
        return result;
    }

    public static String getTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static File getWorkingDir() {
        return new File(System.getProperty("user.dir"));
    }

    public static boolean hasExtension(File file, String ext) {
        return FileUtil.hasExtension(file.getAbsolutePath(), ext);
    }

    public static boolean hasExtension(String path, String ext) {
        return path.toLowerCase().endsWith("." + ext.toLowerCase());
    }

    public static boolean hasParent(File file, File parent) {
        try {
            return file.getCanonicalPath().startsWith(parent.getCanonicalPath() + File.separator);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isXmlFile(File file) {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (BufferedReader reader = FileUtil.openReader(file, Charset.defaultCharset());){
                String line;
                do {
                    if ((line = reader.readLine()) != null) continue;
                    return false;
                } while ((line = line.trim()).equals(""));
                if (!line.startsWith("<")) return false;
                return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static InputStream ensureUnzippedStream(InputStream in, String zipEntry) throws IOException {
        return FileUtil.openZippedInputStream(in, zipEntry);
    }

    public static InputStream ensureResetableStream(File file) throws IOException {
        return FileUtil.ensureResetableStream(FileUtil.openInputStream(file));
    }

    public static InputStream ensureResetableStream(InputStream stream) throws IOException {
        if (!(stream instanceof ByteArrayInputStream)) {
            stream = new ByteArrayInputStream(stream.readAllBytes());
        }
        return stream;
    }

    public static InputStream ensureResetableZippedStream(File file, String zipEntry) throws IOException {
        return FileUtil.ensureResetableZippedStream(FileUtil.openInputStream(file), zipEntry);
    }

    public static InputStream ensureResetableZippedStream(InputStream stream, String zipEntry) throws IOException {
        return FileUtil.ensureResetableStream(FileUtil.ensureUnzippedStream(stream, zipEntry));
    }

    public static boolean isZipStream(InputStream stream) {
        DataInputStream in = null;
        try {
            stream.mark(4);
            in = new DataInputStream(stream);
            int test = in.readInt();
            stream.reset();
            return test == 1347093252;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isZipFile(File file) {
        if (file.isDirectory()) {
            return false;
        }
        if (!file.canRead()) {
            return false;
        }
        if (file.length() < 4L) {
            return false;
        }
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (DataInputStream in = new DataInputStream(FileUtil.openInputStream(file));){
                int test = in.readInt();
                boolean bl = test == 1347093252;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static String lineSeparator() {
        return System.lineSeparator();
    }

    public static String normalizeDir(String dir) {
        if (!((String)dir).endsWith(File.separator)) {
            dir = (String)dir + File.separator;
        }
        return dir;
    }

    public static void openFile(File file) throws IOException {
        try {
            String[] cmdarray = SystemUtil.isWindows() ? new String[]{"cmd.exe", "/c", "start", "\"\"", "\"" + file.getAbsolutePath() + "\""} : new String[]{"xdg-open", file.getAbsolutePath()};
            Runtime.getRuntime().exec(cmdarray);
        }
        catch (IOException e) {
            throw new IOException(e);
        }
    }

    public static List<File> readDirs(File dir, Boolean recursive, String pattern) throws IOException {
        return FileUtil.readDirs(dir.getAbsolutePath(), recursive, pattern, dir.getAbsolutePath() + "/").stream().map(filePath -> new File((String)filePath)).collect(Collectors.toList());
    }

    public static List<String> readDirs(String dirpath, Boolean recursive, String pattern, String leadingChars) throws IOException {
        File f = new File(dirpath);
        ArrayList<String> dirs = new ArrayList<String>();
        if (!f.isDirectory()) {
            return dirs;
        }
        File[] filehandles = f.listFiles();
        if (filehandles == null) {
            throw new IOException(String.format("Cannot read files from directory %s, maybe permission problem.", dirpath));
        }
        int i = 0;
        while (i < filehandles.length) {
            if (filehandles[i].isDirectory()) {
                String fileName = filehandles[i].getName();
                if (pattern == null) {
                    dirs.add(leadingChars + fileName);
                } else {
                    Pattern p = Pattern.compile(pattern, 2);
                    Matcher matcher = p.matcher(fileName);
                    if (matcher.find()) {
                        dirs.add(leadingChars + fileName);
                    }
                }
                if (recursive.booleanValue()) {
                    List<String> filesSubdir = FileUtil.readDirs(filehandles[i].getAbsolutePath(), recursive, pattern, leadingChars + filehandles[i].getName() + File.separator);
                    dirs.addAll(filesSubdir);
                }
            }
            ++i;
        }
        return dirs;
    }

    public static List<File> readFilesFromDir(File dir, boolean recursive, String pattern) throws IOException {
        return FileUtil.readFiles(dir.getAbsolutePath(), recursive, pattern, dir.getAbsolutePath() + "/").stream().map(filePath -> new File((String)filePath)).collect(Collectors.toList());
    }

    public static List<File> findFiles(File dir, boolean recursive, IFilter<File> fileFilter) throws IOException {
        return FileUtil.findFiles(dir.getAbsolutePath(), recursive, fileFilter, dir.getAbsolutePath() + "/").stream().map(filePath -> new File((String)filePath)).collect(Collectors.toList());
    }

    public static List<String> readFiles(String dirpath, Boolean recursive, String pattern, String leadingChars) throws IOException {
        IFilter<File> fileFilter = pattern == null ? null : file -> {
            Pattern p = Pattern.compile(pattern, 2);
            Matcher matcher = p.matcher(file.getName());
            return matcher.find();
        };
        return FileUtil.findFiles(dirpath, recursive, fileFilter, leadingChars);
    }

    public static List<String> findFiles(String dirpath, Boolean recursive, IFilter<File> fileFilter, String leadingChars) throws IOException {
        File f = new File(dirpath);
        ArrayList<String> files = new ArrayList<String>();
        if (!f.isDirectory()) {
            return files;
        }
        File[] filehandles = f.listFiles();
        Arrays.sort(filehandles, (f1, f2) -> f1.getName().compareTo(f2.getName()));
        if (filehandles == null) {
            throw new IOException(String.format("Cannot read files from directory %s, maybe permission problem.", dirpath));
        }
        int i = 0;
        while (i < filehandles.length) {
            if (filehandles[i].isDirectory() && recursive.booleanValue()) {
                List<String> filesSubdir = FileUtil.findFiles(filehandles[i].getAbsolutePath(), recursive, fileFilter, leadingChars + filehandles[i].getName() + File.separator);
                files.addAll(filesSubdir);
            }
            if (filehandles[i].isFile()) {
                File file = filehandles[i];
                if (fileFilter == null || fileFilter.accept(file)) {
                    String fileName = file.getName();
                    files.add(leadingChars + fileName);
                }
            }
            ++i;
        }
        return files;
    }

    public static String readFileContent(File file) {
        try {
            return new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static String removeEndingSlashes(String path) {
        while (path.endsWith("/") || path.endsWith("\\")) {
            path = path.substring(0, path.length());
        }
        return path;
    }

    public static boolean rename(File file, String newName) {
        File newFile = new File(file.getParentFile(), newName);
        if (newFile.exists()) {
            return false;
        }
        return file.renameTo(newFile);
    }

    public static File replaceExtension(File path, String newExtension) {
        return new File(FileUtil.replaceExtension(path.getAbsolutePath(), newExtension));
    }

    /*
     * Unable to fully structure code
     */
    public static String replaceExtension(String path, String newExtension) {
        block1: {
            extension = FileUtil.getExtension(path);
            if (newExtension != null) ** GOTO lbl6
            newPath = extension != null ? path.substring(0, path.length() - extension.length() - 1) : path;
            break block1;
lbl-1000:
            // 1 sources

            {
                newExtension = newExtension.substring(1, newExtension.length());
lbl6:
                // 2 sources

                ** while (newExtension.startsWith((String)"."))
            }
lbl7:
            // 1 sources

            newPath = extension == null ? path.concat(".").concat(newExtension) : path.substring(0, path.length() - extension.length()).concat(newExtension);
        }
        return newPath;
    }

    public static void readZippedInputStream(File zipFile, String zipEntry, Consumer<InputStream> reader) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream in = FileUtil.openZippedInputStream(FileUtil.openInputStream(zipFile), zipEntry);){
            reader.accept(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <E extends Exception> void readZippedInputStream(File zipFile, String zipEntry, IRunnableWithException1E<InputStream, E> reader) throws IOException, E {
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream in = FileUtil.openZippedInputStream(FileUtil.openInputStream(zipFile), zipEntry);){
            reader.run(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void readInputStream(File file, Consumer<InputStream> reader) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream in = FileUtil.openInputStream(file);){
            reader.accept(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <E extends Exception> void readInputStream(File file, IRunnableWithException1E<InputStream, E> reader) throws IOException, E {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream in = FileUtil.openInputStream(file);){
            reader.run(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static InputStream openZippedOrFileInputStream(File potentialZipFile, String path) throws IOException {
        if (FileUtil.isZipFile(potentialZipFile)) {
            return FileUtil.openZippedInputStream(potentialZipFile, path);
        }
        return FileUtil.openInputStream(potentialZipFile);
    }

    public static InputStream openZippedInputStream(File zipFile, String path) throws IOException {
        InputStream in = FileUtil.openInputStream(zipFile);
        return FileUtil.openZippedInputStream(in, path);
    }

    public static InputStream openZippedInputStream(InputStream stream, String zipEntry) throws IOException {
        stream = FileUtil.ensureBufferedFIS(stream);
        ZipInputStream zippedStream = new ZipInputStream(stream);
        ZipEntry entry = null;
        ZipEntry next = zippedStream.getNextEntry();
        while (next != null) {
            if (next.getName().equals(zipEntry)) {
                entry = next;
                break;
            }
            next = zippedStream.getNextEntry();
        }
        if (entry == null) {
            throw new IOException("No '" + zipEntry + "' entry found in compressed zip stream");
        }
        return zippedStream;
    }

    public static void writeOutputStream(File file, Consumer<OutputStream> consumer) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (OutputStream out = FileUtil.openOutputStream(file);){
            consumer.accept(out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <E extends Exception> void writeOutputStream(File file, IRunnableWithException1E<OutputStream, E> consumer) throws IOException, E {
        Throwable throwable = null;
        Object var3_4 = null;
        try (OutputStream out = FileUtil.openOutputStream(file);){
            consumer.run(out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void writeZippedOutputStream(File zipFile, String path, Consumer<OutputStream> consumer) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipOutputStream out = FileUtil.openZippedOutputStream(FileUtil.openOutputStream(zipFile), path);){
            consumer.accept(out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <E extends Exception> void writeZippedOutputStream(File zipFile, String path, IRunnableWithException1E<OutputStream, E> consumer) throws IOException, E {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipOutputStream out = FileUtil.openZippedOutputStream(FileUtil.openOutputStream(zipFile), path);){
            consumer.run(out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static BufferedReader openReader(InputStream in, Charset charset) throws IOException {
        return new BufferedReader(new InputStreamReader(in, charset));
    }

    public static BufferedReader openReader(File file, Charset charset) throws IOException {
        return FileUtil.openReader(new FileInputStream(file), charset);
    }

    public static BufferedReader openReader(File file, String charset) throws IOException {
        return FileUtil.openReader(file, Charset.forName(charset));
    }

    public static InputStream openInputStream(File file) throws IOException {
        return FileUtil.openInputStream(file, true);
    }

    public static InputStream openInputStream(File file, boolean buffered) throws IOException {
        if (buffered) {
            return new BufferedInputStream(new FileInputStream(file));
        }
        return new FileInputStream(file);
    }

    public static BufferedWriter openWriter(OutputStream out, String charset) throws IOException {
        return new BufferedWriter(new OutputStreamWriter(out, charset));
    }

    public static BufferedWriter openWriter(OutputStream out, Charset charset) throws IOException {
        return new BufferedWriter(new OutputStreamWriter(out, charset));
    }

    public static BufferedWriter openWriter(File file, Charset charset) throws IOException {
        return FileUtil.openWriter((OutputStream)new FileOutputStream(file), charset);
    }

    public static BufferedWriter openWriter(File file, String charset) throws IOException {
        return FileUtil.openWriter(file, Charset.forName(charset));
    }

    public static OutputStream openOutputStream(File file) throws IOException {
        return FileUtil.openOutputStream(file, true);
    }

    public static OutputStream openOutputStream(File file, boolean buffered) throws IOException {
        if (buffered) {
            return new BufferedOutputStream(new FileOutputStream(file));
        }
        return new FileOutputStream(file);
    }

    public static ZipOutputStream openZippedOutputStream(File zipFile, String path) throws IOException {
        return FileUtil.openZippedOutputStream(FileUtil.openOutputStream(zipFile), path);
    }

    public static ZipOutputStream openZippedOutputStream(OutputStream stream, String path) throws IOException {
        stream = FileUtil.ensureBufferedFOS(stream);
        ZipOutputStream zipOut = new ZipOutputStream(stream);
        ZipEntry zipEntry = new ZipEntry(path);
        zipOut.putNextEntry(zipEntry);
        return zipOut;
    }

    public static boolean unzip(File zipFile, File destDir) throws IOException {
        return FileUtil.unzip(zipFile, destDir, null);
    }

    public static boolean unzip(File zipFile, File destDir, IFilter<String> pathFilter) throws IOException {
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        boolean success = false;
        Throwable throwable = null;
        Object var5_6 = null;
        try (ZipInputStream zipIn = new ZipInputStream(FileUtil.openInputStream(zipFile));){
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                String filePath = String.valueOf(destDir) + File.separator + entry.getName();
                if (pathFilter != null && !pathFilter.accept(filePath)) continue;
                if (!entry.isDirectory()) {
                    FileUtil.extractFile(zipIn, filePath);
                } else {
                    File dir = new File(filePath);
                    dir.mkdirs();
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
                success = true;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return success;
    }

    public static void zipFile(File fileToZip, File zipFile) throws IOException {
        FileUtil.zipFile(fileToZip, zipFile, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void zipFile(File fileToZip, File zipFile, boolean createRootDir) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            OutputStream fos = FileUtil.openOutputStream(zipFile);
            try {
                try (ZipOutputStream zipOut = new ZipOutputStream(fos);){
                    if (fileToZip.exists() && fileToZip.isDirectory() && !createRootDir) {
                        File[] children;
                        File[] fileArray = children = fileToZip.listFiles();
                        int n = children.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File childFile = fileArray[n2];
                            FileUtil.zipFile(childFile, childFile.getName(), zipOut);
                            ++n2;
                        }
                    } else {
                        FileUtil.zipFile(fileToZip, fileToZip.getName(), zipOut);
                    }
                }
                if (fos == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fos == null) throw throwable;
                fos.close();
                throw throwable;
            }
            fos.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static void zipFile(File fileToZip, String fileName, ZipOutputStream zipOut) throws IOException {
        if (fileToZip.isHidden()) {
            return;
        }
        if (fileToZip.isDirectory()) {
            File[] children;
            if (!((String)fileName).endsWith("/") && !((String)fileName).isEmpty()) {
                fileName = (String)fileName + "/";
            }
            zipOut.putNextEntry(new ZipEntry((String)fileName));
            zipOut.closeEntry();
            File[] fileArray = children = fileToZip.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File childFile = fileArray[n2];
                FileUtil.zipFile(childFile, (String)fileName + childFile.getName(), zipOut);
                ++n2;
            }
            return;
        }
        Throwable throwable = null;
        Object var4_12 = null;
        try (InputStream fis = FileUtil.openInputStream(fileToZip);){
            ZipEntry zipEntry = new ZipEntry((String)fileName);
            zipOut.putNextEntry(zipEntry);
            FileUtil.copyFile(fis, zipOut);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        FileUtil.createDir(new File(filePath).getParentFile());
        Throwable throwable = null;
        Object var3_4 = null;
        try (OutputStream outStream = FileUtil.openOutputStream(new File(filePath));){
            FileUtil.copyFile((InputStream)zipIn, outStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static File correctFile(File file) {
        return FileUtil.findFileIgnoreCase(file, file);
    }

    public static File findFileIgnoreCase(File file, File defaultFile) {
        File[] files;
        File dir;
        if (file == null) {
            return defaultFile;
        }
        if (file.exists()) {
            return file;
        }
        if (!SystemUtil.isWindows() && (dir = FileUtil.correctFile(file.getParentFile())) != null && dir.exists() && (files = dir.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.getAbsolutePath().equalsIgnoreCase(file.getAbsolutePath())) {
                    return f;
                }
                ++n2;
            }
        }
        return defaultFile;
    }

    public static OutputStream ensureBufferedFOS(OutputStream outStream) {
        if (outStream instanceof FileOutputStream) {
            return new BufferedOutputStream(outStream);
        }
        return outStream;
    }

    public static InputStream ensureBufferedFIS(InputStream inStream) {
        if (inStream instanceof FileInputStream) {
            return new BufferedInputStream(inStream);
        }
        return inStream;
    }

    public static String replaceInvalidFileCharacters(String path, String replacement) {
        return path.replaceAll("[^\\w\\-.]", replacement);
    }
}

