/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.util.math;

import java.util.Objects;
import net.edgemind.ibee.util.math.Point2D;

public class Line {
    private double mX1 = 0.0;
    private double mX2 = 0.0;
    private double mY1 = 0.0;
    private double mY2 = 0.0;

    public Line(Point2D p1, Point2D p2) {
        this.mX1 = p1.getX();
        this.mY1 = p1.getY();
        this.mX2 = p2.getX();
        this.mY2 = p2.getY();
    }

    public Line(double x1, double y1, double x2, double y2) {
        this.mX1 = x1;
        this.mY1 = y1;
        this.mX2 = x2;
        this.mY2 = y2;
    }

    public Line(Line other) {
        this.mX1 = other.mX1;
        this.mY1 = other.mY1;
        this.mX2 = other.mX2;
        this.mY2 = other.mY2;
    }

    public void setX1(double value) {
        this.mX1 = value;
    }

    public void setX2(double value) {
        this.mX2 = value;
    }

    public void setY1(double value) {
        this.mY1 = value;
    }

    public void setY2(double value) {
        this.mY2 = value;
    }

    public double getX1() {
        return this.mX1;
    }

    public double getX2() {
        return this.mX2;
    }

    public double getY1() {
        return this.mY1;
    }

    public double getY2() {
        return this.mY2;
    }

    public Point2D getP1() {
        return new Point2D(this.mX1, this.mY1);
    }

    public Point2D getP2() {
        return new Point2D(this.mX2, this.mY2);
    }

    public Line clone() {
        Line clone = new Line(this.mX1, this.mY1, this.mX2, this.mY2);
        return clone;
    }

    public double getAngle() {
        return Math.atan2(this.mY2 - this.mY1, this.mX2 - this.mX1);
    }

    public double getDistance() {
        double dx = this.mX2 - this.mX1;
        double dy = this.mY2 - this.mY1;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Line other = (Line)obj;
        return Double.compare(this.mX1, other.mX1) == 0 && Double.compare(this.mX2, other.mX2) == 0 && Double.compare(this.mY1, other.mY1) == 0 && Double.compare(this.mY2, other.mY2) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.mX1, this.mX2, this.mY1, this.mY2);
    }
}

