/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.util.math;

import net.edgemind.ibee.util.math.Frame;
import net.edgemind.ibee.util.math.Line;
import net.edgemind.ibee.util.math.Point2D;

public class MathUtil {
    public static double ceil(double v, int dec) {
        double factor = Math.pow(10.0, dec);
        return Math.ceil(v * factor) / factor;
    }

    public static boolean equals(Point2D p1, Point2D p2) {
        return p1.getX() == p2.getX() && p1.getY() == p2.getY();
    }

    public static double exp(double v, int a) {
        double res = 1.0;
        int i = 0;
        while (i < a) {
            res *= v;
            ++i;
        }
        return res;
    }

    public static double floor(double v, int dec) {
        double factor = Math.pow(10.0, dec);
        return Math.floor(v * factor) / factor;
    }

    public static double getBezierDistance(Point2D p, Point2D[] curve) {
        double res = 0.0;
        Point2D bp = new Point2D(0.0, 0.0);
        double delta = 1.0 / MathUtil.getPointPointDistance(curve[0], curve[curve.length - 1]);
        double t = 0.0;
        while (t < 1.0) {
            double x = curve[0].getX() * MathUtil.exp(1.0 - t, 3) + 3.0 * curve[1].getX() * t * MathUtil.exp(1.0 - t, 2) + 3.0 * curve[2].getX() * MathUtil.exp(t, 2) * (1.0 - t) + curve[3].getX() * MathUtil.exp(t, 3);
            double y = curve[0].getY() * MathUtil.exp(1.0 - t, 3) + 3.0 * curve[1].getY() * t * MathUtil.exp(1.0 - t, 2) + 3.0 * curve[2].getY() * MathUtil.exp(t, 2) * (1.0 - t) + curve[3].getY() * MathUtil.exp(t, 3);
            bp.setX(x);
            bp.setY(y);
            double d = MathUtil.getPointPointDistance(bp, p);
            if (t == 0.0 || d < res) {
                res = d;
            }
            t += delta;
        }
        return res;
    }

    public static Point2D getFrameIntersection(Line l, Frame f) {
        Line l2 = new Line(f.getX(), f.getY(), f.getX() + f.getWidth(), f.getY());
        Point2D p = MathUtil.getLineIntersectionCut(l, l2);
        if (p != null) {
            return p;
        }
        l2 = new Line(f.getX() + f.getWidth(), f.getY(), f.getX() + f.getWidth(), f.getY() + f.getHeight());
        p = MathUtil.getLineIntersectionCut(l, l2);
        if (p != null) {
            return p;
        }
        l2 = new Line(f.getX() + f.getWidth(), f.getY() + f.getHeight(), f.getX(), f.getY() + f.getHeight());
        p = MathUtil.getLineIntersectionCut(l, l2);
        if (p != null) {
            return p;
        }
        l2 = new Line(f.getX(), f.getY() + f.getHeight(), f.getX(), f.getY());
        p = MathUtil.getLineIntersectionCut(l, l2);
        if (p != null) {
            return p;
        }
        return null;
    }

    public static Point2D getIntersection(Line l, Frame f) {
        Line l2 = new Line(f.getX(), f.getY(), f.getX() + f.getWidth(), f.getY());
        Point2D p = MathUtil.getLineIntersectionCut(l, l2);
        if (p != null) {
            return p;
        }
        l2 = new Line(f.getX() + f.getWidth(), f.getY(), f.getX() + f.getWidth(), f.getY() + f.getHeight());
        p = MathUtil.getLineIntersectionCut(l, l2);
        if (p != null) {
            return p;
        }
        l2 = new Line(f.getX() + f.getWidth(), f.getY() + f.getHeight(), f.getX(), f.getY() + f.getHeight());
        p = MathUtil.getLineIntersectionCut(l, l2);
        if (p != null) {
            return p;
        }
        l2 = new Line(f.getX(), f.getY() + f.getHeight(), f.getX(), f.getY());
        p = MathUtil.getLineIntersectionCut(l, l2);
        if (p != null) {
            return p;
        }
        return null;
    }

    public static Point2D getLineIntersection(Line l1, Line l2) {
        double a1 = l1.getY2() - l1.getY1();
        double b1 = l1.getX1() - l1.getX2();
        double c1 = a1 * l1.getX1() + b1 * l1.getY1();
        double a2 = l2.getY2() - l2.getY1();
        double b2 = l2.getX1() - l2.getX2();
        double c2 = a2 * l2.getX1() + b2 * l2.getY1();
        double det = a1 * b2 - a2 * b1;
        if (det == 0.0) {
            return null;
        }
        double intersectionX = (b2 * c1 - b1 * c2) / det;
        double intersectionY = (a1 * c2 - a2 * c1) / det;
        return new Point2D(intersectionX, intersectionY);
    }

    public static Point2D getLineIntersectionCut(Line l1, Line l2) {
        Point2D intersection = MathUtil.getLineIntersection(l1, l2);
        if (intersection == null) {
            return null;
        }
        Line lotl1_1 = new Line(l1.getX1(), l1.getY1(), l1.getX1() + (l1.getY2() - l1.getY1()), l1.getY1() - (l1.getX2() - l1.getX1()));
        Line lotl1_2 = new Line(l1.getX2(), l1.getY2(), l1.getX2() + (l1.getY2() - l1.getY1()), l1.getY2() - (l1.getX2() - l1.getX1()));
        Line lotl2_1 = new Line(l2.getX1(), l2.getY1(), l2.getX1() + (l2.getY2() - l2.getY1()), l2.getY1() - (l2.getX2() - l2.getX1()));
        Line lotl2_2 = new Line(l2.getX2(), l2.getY2(), l2.getX2() + (l2.getY2() - l2.getY1()), l2.getY2() - (l2.getX2() - l2.getX1()));
        double d1 = MathUtil.getPointLineDistance(intersection, lotl1_1);
        double d2 = MathUtil.getPointLineDistance(intersection, lotl1_2);
        double d3 = MathUtil.getPointLineDistance(intersection, lotl2_1);
        double d4 = MathUtil.getPointLineDistance(intersection, lotl2_2);
        if (d1 >= -0.01 && d2 <= 0.01 && d3 >= -0.01 && d4 <= 0.01) {
            return intersection;
        }
        return null;
    }

    public static double getPointLineDistance(Point2D p, Line l) {
        double nX = -(l.getY2() - l.getY1());
        double nY = l.getX2() - l.getX1();
        double betrag = Math.sqrt(MathUtil.sqr(nX) + MathUtil.sqr(nY));
        double c = -(l.getX1() * (nX /= betrag) + l.getY1() * (nY /= betrag));
        double d = nX * p.getX() + nY * p.getY() + c;
        return d;
    }

    public static double getPointLineDistanceCut(Point2D p, Line l) {
        double nX = -(l.getY2() - l.getY1());
        double nY = l.getX2() - l.getX1();
        double d1 = MathUtil.getPointLineDistance(p, new Line(l.getX1(), l.getY1(), l.getX1() + nX, l.getY1() + nY));
        double d2 = MathUtil.getPointLineDistance(p, new Line(l.getX2(), l.getY2(), l.getX2() + nX, l.getY2() + nY));
        if (d1 >= 0.0 && d2 <= 0.0 || d1 <= 0.0 && d2 >= 0.0) {
            return Math.abs(MathUtil.getPointLineDistance(p, l));
        }
        if (Math.abs(d1) < Math.abs(d2)) {
            return Math.sqrt(MathUtil.sqr(l.getX1() - p.getX()) + MathUtil.sqr(l.getY1() - p.getY()));
        }
        return Math.sqrt(MathUtil.sqr(l.getX2() - p.getX()) + MathUtil.sqr(l.getY2() - p.getY()));
    }

    public static double getPointPointDistance(Point2D p1, Point2D p2) {
        return Math.sqrt(MathUtil.sqr(p2.mX - p1.mX) + MathUtil.sqr(p2.mY - p1.mY));
    }

    public static Point2D movePoint(Point2D from, Point2D to, double angle, double distance) {
        if (MathUtil.equals(from, to)) {
            return from;
        }
        double dxTotal = to.getX() - from.getX();
        double dyTotal = to.getY() - from.getY();
        double dxT = Math.cos(angle) * dxTotal - Math.sin(angle) * dyTotal;
        double dyT = Math.sin(angle) * dxTotal + Math.cos(angle) * dyTotal;
        double distanceT = MathUtil.getPointPointDistance(from, to);
        double dx = distance / distanceT * dxT;
        double dy = distance / distanceT * dyT;
        Point2D result = new Point2D(from.getX() + dx, from.getY() + dy);
        return result;
    }

    public static Point2D movePoint(Point2D from, double distance, double angle) {
        double dx = Math.cos(angle) * distance;
        double dy = Math.sin(angle) * distance;
        Point2D result = new Point2D(from.getX() + dx, from.getY() + dy);
        return result;
    }

    public static Point2D movePoint(Point2D from, Point2D to, double distance) {
        if (MathUtil.equals(from, to)) {
            return from;
        }
        double dxT = to.getX() - from.getX();
        double dyT = to.getY() - from.getY();
        double distanceT = MathUtil.getPointPointDistance(from, to);
        double dx = distance / distanceT * dxT;
        double dy = distance / distanceT * dyT;
        Point2D result = new Point2D(from.getX() + dx, from.getY() + dy);
        return result;
    }

    public static double mult(Point2D p1, Point2D p2) {
        return p1.getX() * p2.getX() + p1.getY() * p2.getY();
    }

    public static double sqr(double v) {
        return v * v;
    }
}

