/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.util.string;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    public static List<String> combineLists(ArrayList<String> list1, ArrayList<String> list2) {
        ArrayList<String> combined = new ArrayList<String>();
        int indexList1 = 0;
        while (indexList1 < list1.size()) {
            if (!combined.contains(list1.get(indexList1))) {
                combined.add(list1.get(indexList1));
            }
            ++indexList1;
        }
        int indexList2 = 0;
        while (indexList2 < list2.size()) {
            if (!combined.contains(list2.get(indexList2))) {
                combined.add(list2.get(indexList2));
            }
            ++indexList2;
        }
        return combined;
    }

    public static int countChars(String s, char c) {
        int cnt = 0;
        int next = -1;
        while ((next = s.indexOf(c, next + 1)) >= 0) {
            ++cnt;
        }
        return cnt;
    }

    public static List<String> cutLines(String line, int maxLength) {
        ArrayList<String> linesWithMaxLineLength = new ArrayList<String>();
        while (line.length() > 0) {
            int cut = line.length() > maxLength ? maxLength : line.length();
            boolean wordIsCutted = false;
            if (cut < line.length() && line.charAt(cut) != ' ') {
                wordIsCutted = true;
            }
            if (wordIsCutted) {
                while (cut > 0 && line.charAt(cut - 1) != ' ') {
                    --cut;
                }
            }
            if (cut == 0) {
                cut = line.length() > maxLength ? maxLength : line.length();
            }
            linesWithMaxLineLength.add(line.substring(0, cut).trim());
            line = line.substring(cut, line.length());
        }
        return linesWithMaxLineLength;
    }

    public static String deleteMatchingLines(String text, String regex) {
        Matcher matcher;
        Pattern pattern = Pattern.compile("(^|\\n).*(" + regex + ").*(\\n|$)");
        while ((matcher = pattern.matcher((CharSequence)text)).find()) {
            Object temp = ((String)text).substring(0, matcher.start());
            text = temp = (String)temp + ((String)text).substring(matcher.end(), ((String)text).length());
        }
        return text;
    }

    public static boolean equals(Object s1, Object s2, boolean ignoreCase) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null) {
            return false;
        }
        if (s2 == null) {
            return false;
        }
        if (ignoreCase) {
            return s1.toString().equalsIgnoreCase(s2.toString());
        }
        return s1.toString().equals(s2.toString());
    }

    public static boolean equals(String s1, String s2, boolean ignoreCase) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (ignoreCase) {
            return s1.equalsIgnoreCase(s2);
        }
        return s1.equals(s2);
    }

    public static String fromDouble(double d, int nrDigits) {
        if (Double.isNaN(d)) {
            return "nan";
        }
        if (Double.isInfinite(d)) {
            return "inf";
        }
        BigDecimal bigDecimal = new BigDecimal(d);
        Object s = "0.";
        int i = 0;
        while (i < nrDigits) {
            s = (String)s + "0";
            ++i;
        }
        s = (String)s + "E0";
        DecimalFormat format = new DecimalFormat((String)s);
        return format.format(bigDecimal);
    }

    public static String[] insertString(String s, int index, String[] lines) {
        String[] newLines = new String[lines.length + 1];
        int i = 0;
        while (i < index) {
            newLines[i] = lines[i];
            ++i;
        }
        newLines[index] = s;
        i = index;
        while (i < lines.length) {
            newLines[i + 1] = lines[i];
            ++i;
        }
        return newLines;
    }

    public static boolean isCharacter(char c, char[] del) {
        char[] cArray = del;
        int n = del.length;
        int n2 = 0;
        while (n2 < n) {
            char d = cArray[n2];
            if (d == c) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isSpecialChar(char c) {
        return c == '/' || c == '\"' || c == ':' || c == '[' || c == ']';
    }

    private static boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n';
    }

    public static String makeFirstUpper(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static String makeDisplayName(String s) {
        s = StringUtil.makeFirstUpper(s);
        s = s.replace("_", " ");
        return StringUtil.addSpaceBetweenSmallerAndUpperChar(s);
    }

    public static String addSpaceBetweenSmallerAndUpperChar(String s) {
        Object result = "";
        int index = 0;
        while (index < s.length() - 1) {
            char c1 = s.charAt(index);
            char c2 = s.charAt(index + 1);
            result = (String)result + c1;
            if (!Character.isUpperCase(c1) && Character.isUpperCase(c2)) {
                result = (String)result + " ";
            }
            ++index;
        }
        result = (String)result + s.charAt(s.length() - 1);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static int parseString(String line, int index, StringBuffer result, char[] del) {
        modeText = false;
        modeSpecial = false;
        record = "";
        while (index < line.length()) {
            block10: {
                block9: {
                    c = line.charAt(index);
                    if (modeSpecial || c != '\\') break block9;
                    modeSpecial = true;
                    break block10;
                }
                if (modeSpecial) ** GOTO lbl22
                if (!modeText && c == '\"') {
                    modeText = true;
                } else if (modeText && c == '\"') {
                    modeText = false;
                } else {
                    if (!modeText && StringUtil.isCharacter(c, del)) {
                        if (result != null) {
                            result.append(record.toString());
                        }
                        return index;
                    }
lbl22:
                    // 3 sources

                    modeSpecial = false;
                    if (result != null) {
                        record = (String)record + c;
                    }
                }
            }
            ++index;
        }
        if (result != null) {
            result.append(record.toString());
        }
        return index;
    }

    public static int skipWhiteSpaces(String line, int index) {
        while (index < line.length() && StringUtil.isWhiteSpace(line.charAt(index))) {
            ++index;
        }
        return index;
    }

    public static String smoothString(String s) {
        s = s.replaceAll("(\\s|\\.|-)", "");
        return s.toLowerCase();
    }

    public static List<String> split(String line) {
        List<String> list = StringUtil.split(line, 0, line.length(), new char[]{'\t', ' ', '\n'});
        ArrayList<String> list2 = new ArrayList<String>();
        for (String s : list) {
            if ((s = s.trim()).length() <= 0) continue;
            list2.add(s);
        }
        return list2;
    }

    public static List<String> split(String line, char delimiter) {
        return StringUtil.split(line, -1, -1, new char[]{delimiter});
    }

    public static List<String> split(String line, int begin, int end, char delimiter) {
        return StringUtil.split(line, begin, end, new char[]{delimiter});
    }

    public static List<String> split(String line, int begin, int end, char[] delimiter) {
        if (begin < 0) {
            begin = 0;
        }
        if (end < 0) {
            end = line.length();
        }
        ArrayList<String> args = new ArrayList<String>();
        int index = begin;
        while (index <= end) {
            StringBuffer string = new StringBuffer();
            index = StringUtil.parseString(line, index, string, delimiter);
            args.add(string.toString());
            ++index;
        }
        return args;
    }

    public static Boolean toBoolean(String s) {
        return StringUtil.toBoolean(s, false);
    }

    public static Boolean toBoolean(String s, Boolean defaultValue) {
        if (s == null || s.length() == 0) {
            return defaultValue;
        }
        if (!s.equalsIgnoreCase("false") && !s.equalsIgnoreCase("true")) {
            return defaultValue;
        }
        return Boolean.parseBoolean(s);
    }

    public static Double toDouble(String s) {
        return StringUtil.toDouble(s, 0.0);
    }

    public static Double toDouble(String s, Double def) {
        if (s == null) {
            if (def == null) {
                return null;
            }
            return def + 0.0;
        }
        if ((s = s.replaceAll(",", ".")) == null) {
            if (def == null) {
                return null;
            }
            return def + 0.0;
        }
        try {
            return new Double(s) + 0.0;
        }
        catch (NumberFormatException numberFormatException) {
            if (def == null) {
                return null;
            }
            return def + 0.0;
        }
    }

    public static double toDouble(String s, double defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        s = s.replaceAll(",", ".");
        double d = 0.0;
        if (s == null) {
            return defaultValue;
        }
        try {
            d = Double.parseDouble(s);
        }
        catch (NumberFormatException numberFormatException) {
            d = defaultValue;
        }
        return d;
    }

    public static float toFloat(String s) {
        return StringUtil.toFloat(s, 0.0f);
    }

    public static float toFloat(String s, float defaultValue) {
        float f = 0.0f;
        if (s == null) {
            return defaultValue;
        }
        try {
            f = new Float(s).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            f = defaultValue;
        }
        return f;
    }

    public static Integer toInt(String s) {
        return StringUtil.toInt(s, 0);
    }

    public static Integer toInt(String s, Integer def) {
        if (s == null) {
            if (def == null) {
                return null;
            }
            return def + 0;
        }
        try {
            return new Integer(s) + 0;
        }
        catch (NumberFormatException numberFormatException) {
            if (def == null) {
                return null;
            }
            return def + 0;
        }
    }

    public static Long toLong(String s, Long def) {
        if (s == null) {
            if (def == null) {
                return null;
            }
            return def + 0L;
        }
        try {
            return new Long(s) + 0L;
        }
        catch (NumberFormatException numberFormatException) {
            if (def == null) {
                return null;
            }
            return def + 0L;
        }
    }

    public static String toString(Boolean value) {
        return StringUtil.toString(value, null);
    }

    public static String toString(Integer value) {
        return StringUtil.toString(value, null);
    }

    public static String toString(Long value) {
        return StringUtil.toString(value, null);
    }

    public static String toString(Double value) {
        return StringUtil.toString(value, null);
    }

    public static String toString(String value, String defaultString) {
        if (value == null) {
            return defaultString;
        }
        return value;
    }

    public static String toString(Boolean value, String defaultString) {
        if (value == null) {
            return defaultString;
        }
        return String.valueOf(value);
    }

    public static String toString(Integer value, String defaultString) {
        if (value == null) {
            return defaultString;
        }
        return String.valueOf(value);
    }

    public static String toString(Long value, String defaultString) {
        if (value == null) {
            return defaultString;
        }
        return String.valueOf(value);
    }

    public static String toString(Double value, String defaultString) {
        if (value == null) {
            return defaultString;
        }
        return String.valueOf(value);
    }

    public static String[] toString(List<String> list) {
        String[] result = new String[list.size()];
        return list.toArray(result);
    }

    public static boolean wildCardMatch(String text, String pattern, boolean caseInSensitive) {
        return StringUtil.wildCardMatch(text, pattern, caseInSensitive, false, false);
    }

    public static boolean wildCardMatch(String text, String pattern, boolean caseInSensitive, boolean matchBeginRequired, boolean matchEndRequired) {
        if (caseInSensitive) {
            text = text.toLowerCase();
            pattern = pattern.toLowerCase();
        }
        String[] cards = pattern.split("\\*");
        if (pattern.endsWith("*")) {
            matchEndRequired = false;
        }
        if (pattern.startsWith("*")) {
            matchBeginRequired = false;
        }
        int cardNr = 0;
        while (cardNr < cards.length) {
            String card = cards[cardNr];
            int idx = -1;
            int start = 0;
            if (cardNr == cards.length - 1 && matchEndRequired && (start = text.length() - card.length()) < 0) {
                return false;
            }
            int i = start;
            while (i <= text.length() - card.length()) {
                boolean found = true;
                int j = 0;
                while (j < card.length()) {
                    if (text.charAt(i + j) != card.charAt(j) && card.charAt(j) != '?') {
                        found = false;
                        break;
                    }
                    ++j;
                }
                if (found) {
                    idx = i;
                    break;
                }
                ++i;
            }
            if (cardNr == 0 && matchBeginRequired && idx != 0) {
                return false;
            }
            if (idx == -1) {
                return false;
            }
            text = text.substring(idx + card.length());
            ++cardNr;
        }
        return true;
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static String md5(String s) {
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] digest = md5.digest(s.getBytes(Charset.forName("utf8")));
        BigInteger no = new BigInteger(1, digest);
        return no.toString(16);
    }

    public static String sha256(String s) {
        MessageDigest msgDigest;
        try {
            msgDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] digest = msgDigest.digest(s.getBytes(Charset.forName("utf8")));
        BigInteger no = new BigInteger(1, digest);
        return no.toString(16);
    }

    public static List<String> performStringSort(Collection<String> set) {
        ArrayList<String> list = new ArrayList<String>(set);
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        return list;
    }

    public static boolean isIntValue(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isFloatValue(String str) {
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isBoolValue(String value) {
        return "true".equals(value = value.toLowerCase()) || "false".equals(value);
    }

    public static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public static List<String> sort(List<String> list) {
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String value1, String value2) {
                return value1.compareToIgnoreCase(value2);
            }
        });
        return list;
    }
}

