/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.util.system;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EnvUtil {
    public static String replaceEnvVars(String expr) {
        Pattern pattern = Pattern.compile("\\$\\{([\\w\\.-]+)\\}");
        Matcher matcher = pattern.matcher(expr);
        StringBuilder buf = new StringBuilder();
        int last = 0;
        while (matcher.find()) {
            String var = matcher.group(1);
            String envVar = EnvUtil.getEnv(var, true);
            buf.append(expr.substring(last, matcher.start()));
            if (envVar == null) {
                throw new RuntimeException(String.format("Unknown Env Variable '%s' in expr '%s'. Please ensure that the environment variable is set.", var, expr));
            }
            buf.append(envVar);
            last = matcher.end();
        }
        buf.append(expr.substring(last));
        return buf.toString();
    }

    public static String getEnv(String var, boolean allowProperty) {
        String envVar = System.getenv().get(var);
        if (envVar == null && allowProperty) {
            envVar = System.getProperty(var);
        }
        return envVar;
    }
}

