/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.util.system;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class WindowsRegistryUtil {
    public static boolean keyExists(String keyPath) {
        try {
            Process process = new ProcessBuilder("reg", "query", keyPath).start();
            int exitCode = process.waitFor();
            return exitCode == 0;
        }
        catch (IOException | InterruptedException exception) {
            return false;
        }
    }

    public static String getKeyValue(String keyPath, String valueName) {
        try {
            String line;
            Process process = new ProcessBuilder("reg", "query", keyPath, "/v", valueName).start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                String[] parts;
                if (!line.trim().startsWith(valueName) || (parts = line.trim().split("\\s+")).length <= 2) continue;
                return parts[2];
            }
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                return null;
            }
        }
        catch (IOException | InterruptedException exception) {}
        return null;
    }
}

