/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.util.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.edgemind.ibee.util.xml.DomUtil;

public class DomElement {
    public String name;
    public List<DomElement> children = new ArrayList<DomElement>();
    public Map<String, String> attributes = new HashMap<String, String>();
    public String text;

    public DomElement(String tag) {
        this.name = tag;
    }

    public DomElement attr(String key, String value) {
        this.attributes.put(key, value);
        return this;
    }

    public DomElement attr(String key, double value) {
        this.attributes.put(key, "" + value);
        return this;
    }

    public DomElement text(String text) {
        this.text = text;
        return this;
    }

    public String text() {
        return this.text;
    }

    public DomElement add(DomElement child) {
        this.children.add(child);
        return this;
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public List<DomElement> getChildren(String tag) {
        ArrayList<DomElement> res = new ArrayList<DomElement>();
        for (DomElement child : this.children) {
            if (tag != null && !child.name.equals(tag)) continue;
            res.add(child);
        }
        return this.children;
    }

    public double getDoubleAttr(String name, double def) {
        if (this.attributes.containsKey(name)) {
            try {
                Double d = new Double(this.attributes.get(name));
                return d;
            }
            catch (NumberFormatException numberFormatException) {
                return def;
            }
        }
        return def;
    }

    public void setDoubleAttr(String name, double value) {
        this.attributes.put(name, "" + value);
    }

    public int getIntAttr(String name, int def) {
        if (this.attributes.containsKey(name)) {
            try {
                Integer d = new Integer(this.attributes.get(name));
                return d;
            }
            catch (NumberFormatException numberFormatException) {
                return def;
            }
        }
        return def;
    }

    public void setIntAttr(String name, int value) {
        this.attributes.put(name, "" + value);
    }

    public long getLongAttr(String name, long def) {
        if (this.attributes.containsKey(name)) {
            try {
                Long d = new Long(this.attributes.get(name));
                return d;
            }
            catch (NumberFormatException numberFormatException) {
                return def;
            }
        }
        return def;
    }

    public void setLongAttr(String name, long value) {
        this.attributes.put(name, "" + value);
    }

    public String getStringAttr(String name, String def) {
        if (this.attributes.containsKey(name)) {
            return this.attributes.get(name);
        }
        return def;
    }

    public String toXml() {
        DomUtil creator = new DomUtil();
        return creator.getAsText(this);
    }

    public static class DomAtrribute {
        public String name;
        public String value;
    }
}

