/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.util.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import net.edgemind.ibee.util.file.FileUtil;
import net.edgemind.ibee.util.xml.EvalException;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SchemeValidator {
    public Schema scheme = null;

    public List<SAXParseException> validate(File xmlFile, Schema scheme) throws EvalException, IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream input = FileUtil.openInputStream(xmlFile);){
            return this.validate(input, scheme);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public List<SAXParseException> validate(InputStream xmlInput, Schema scheme) throws EvalException {
        StreamSource xmlSource = new StreamSource(xmlInput);
        return this.validate(xmlSource, scheme);
    }

    public List<SAXParseException> validate(Document xmlInput, Schema scheme) throws EvalException {
        DOMSource xmlSource = new DOMSource(xmlInput);
        return this.validate(xmlSource, scheme);
    }

    public List<SAXParseException> validate(Source xmlSource, Schema scheme) throws EvalException {
        final LinkedList<SAXParseException> exceptions = new LinkedList<SAXParseException>();
        try {
            Validator validator = scheme.newValidator();
            validator.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    exceptions.add(exception);
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    exceptions.add(exception);
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    exceptions.add(exception);
                }
            });
            validator.validate(xmlSource);
            validator.reset();
        }
        catch (SAXException e) {
            throw new EvalException(e);
        }
        catch (IOException e) {
            throw new EvalException(e);
        }
        return exceptions;
    }
}

