/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.util.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import net.edgemind.ibee.util.file.FileUtil;
import net.edgemind.ibee.util.xml.ClosingXmlStreamWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

public class XmlUtil {
    private static DocumentBuilder docBuilder;

    public static synchronized Schema getScheme(String resourceUrl, Class<?> clazz) throws SAXException, IOException {
        URL url = clazz.getResource(resourceUrl);
        if (url == null) {
            throw new IOException("scheme '" + resourceUrl + "' not found.");
        }
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema scheme = factory.newSchema(url);
        return scheme;
    }

    private static synchronized DocumentBuilder getBuilder() {
        if (docBuilder == null) {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            try {
                docBuilder = docFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        return docBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document createNewDocument() {
        DocumentBuilder builder;
        DocumentBuilder documentBuilder = builder = XmlUtil.getBuilder();
        synchronized (documentBuilder) {
            return builder.newDocument();
        }
    }

    public static Document readXmlFile(File file) throws IOException {
        return XmlUtil.readXmlFile(file.getAbsolutePath());
    }

    public static Document readXmlFile(String fileName) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream bis = FileUtil.openInputStream(new File(fileName));){
            return XmlUtil.readXmlFile(bis);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Document readXmlFile(InputStream inputStream) throws IOException {
        DocumentBuilder builder = XmlUtil.getBuilder();
        inputStream = FileUtil.ensureBufferedFIS(inputStream);
        DocumentBuilder documentBuilder = builder;
        synchronized (documentBuilder) {
            try {
                return builder.parse(inputStream);
            }
            catch (SAXException e) {
                throw new IOException(e);
            }
            catch (IOException e) {
                throw new IOException(e);
            }
        }
    }

    public static ClosingXmlStreamWriter createStreamWriter(OutputStream outStream, String encoding) throws XMLStreamException {
        outStream = FileUtil.ensureBufferedFOS(outStream);
        XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
        return new ClosingXmlStreamWriter(xmlOutputFactory.createXMLStreamWriter(outStream, encoding), outStream);
    }

    public static ClosingXmlStreamWriter createStreamWriter(OutputStream outStream) throws XMLStreamException {
        outStream = FileUtil.ensureBufferedFOS(outStream);
        XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
        return new ClosingXmlStreamWriter(xmlOutputFactory.createXMLStreamWriter(outStream), outStream);
    }

    public static ClosingXmlStreamWriter createStreamWriter(Writer writer) throws XMLStreamException {
        XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
        return new ClosingXmlStreamWriter(xmlOutputFactory.createXMLStreamWriter(writer), writer);
    }

    public static void writeXmlFile(Document document, String filename) throws IOException {
        XmlUtil.writeXmlFile(document, new File(filename));
    }

    public static void writeXmlFile(Document document, File file) throws IOException {
        XmlUtil.writeXmlFile(document, file, false);
    }

    public static void writeXmlFile(Document document, String filename, boolean omitXmlDeclaration) throws IOException {
        XmlUtil.writeXmlFile(document, new File(filename), omitXmlDeclaration);
    }

    public static void writeXmlFile(Document document, File file, boolean omitXmlDeclaration) throws IOException {
        FileUtil.createDir(FileUtil.extractFileDir(file));
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStream out = FileUtil.openOutputStream(file);){
            XmlUtil.writeXmlFile(document, out, omitXmlDeclaration);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void writeXmlFile(Document document, OutputStream out) throws IOException {
        XmlUtil.writeXmlFile(document, out, false);
    }

    public static void writeXmlFile(Document document, OutputStream out, boolean omitXmlDeclaration) throws IOException {
        try {
            DOMSource source = new DOMSource(document);
            out = FileUtil.ensureBufferedFOS(out);
            StreamResult result = new StreamResult(out);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer xformer = transformerFactory.newTransformer();
            xformer.setOutputProperty("omit-xml-declaration", omitXmlDeclaration ? "yes" : "no");
            xformer.setOutputProperty("indent", "yes");
            xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
            xformer.transform(source, result);
            out.flush();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeXmlFile2(Document document, OutputStream output) throws Exception {
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        DOMImplementationLS domImplLS = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
        LSSerializer ser = domImplLS.createLSSerializer();
        ser.getDomConfig().setParameter("format-pretty-print", true);
        LSOutput out = domImplLS.createLSOutput();
        output = FileUtil.ensureBufferedFOS(output);
        OutputStreamWriter writer = new OutputStreamWriter(output, Charset.forName("UTF-8").newEncoder());
        out.setCharacterStream(writer);
        out.setEncoding("UTF-8");
        ser.write(document, out);
        writer.flush();
        output.flush();
        writer.close();
    }

    public static void writeXmlFile2(Document document, String filename) throws Exception {
        XmlUtil.writeXmlFile2(document, new File(filename));
    }

    public static void writeXmlFile2(Document document, File file) throws Exception {
        FileUtil.createDir(FileUtil.extractFileDir(file));
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (OutputStream outStream = FileUtil.openOutputStream(file);){
                XmlUtil.writeXmlFile2(document, outStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    public static List<Node> convertNsList(NodeList ns) {
        int length = ns.getLength();
        ArrayList<Node> nodeList = new ArrayList<Node>(length);
        int index = 0;
        while (index < length) {
            Node n = ns.item(index);
            if (n != null) {
                nodeList.add(n);
            }
            ++index;
        }
        return nodeList;
    }

    public static Element getFirstChildByTagName(String tagName, Element parent) {
        NodeList nodeList = parent.getChildNodes();
        int length = nodeList.getLength();
        int i = 0;
        while (i < length) {
            Node n = nodeList.item(i);
            if (n.getNodeType() == 1 && n.getNodeName().equals(tagName)) {
                return (Element)n;
            }
            ++i;
        }
        return null;
    }

    public static List<Element> getChildrenByTagName(String tagname, Element parent) {
        NodeList nodeList = parent.getChildNodes();
        ArrayList<Element> nodes = new ArrayList<Element>(nodeList.getLength());
        int length = nodeList.getLength();
        int i = 0;
        while (i < length) {
            Node n = nodeList.item(i);
            if (n.getNodeType() == 1 && n.getNodeName().equals(tagname)) {
                nodes.add((Element)n);
            }
            ++i;
        }
        return nodes;
    }

    public static List<Element> getChildren(Element parent) {
        NodeList nodeList = parent.getChildNodes();
        ArrayList<Element> nodes = new ArrayList<Element>();
        Node node = nodeList.item(0);
        while (node != null) {
            if (node.getNodeType() == 1) {
                nodes.add((Element)node);
            }
            node = node.getNextSibling();
        }
        return nodes;
    }

    public static Element getFirstElementByTagName(String tagName, Document doc) {
        try {
            return XmlUtil.getFirstElementByTagName(tagName, doc, false);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Element getFirstElementByTagName(String tagName, Document doc, boolean required) throws Exception {
        NodeList nodelist = doc.getElementsByTagName(tagName);
        if (nodelist.getLength() > 0) {
            return (Element)nodelist.item(0);
        }
        if (required) {
            throw new Exception("no element " + tagName + " found");
        }
        return null;
    }

    public static String getFistValueByTagName(String tagName, Document doc) {
        try {
            return XmlUtil.getFirstValueByTagName(tagName, doc, false);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getFirstValueByTagName(String tagName, Document doc, boolean required) throws Exception {
        NodeList nodelist = doc.getElementsByTagName(tagName);
        if (nodelist.getLength() > 0) {
            return nodelist.item(0).getTextContent();
        }
        if (required) {
            throw new Exception("no element " + tagName + " found");
        }
        return "";
    }

    public static void moveNodes(NodeList ns, Element nodeTo) {
        List<Node> nodeList = XmlUtil.convertNsList(ns);
        for (Node node : nodeList) {
            Node nodeFrom = node.getParentNode();
            if (nodeFrom == nodeTo) continue;
            nodeFrom.removeChild(node);
            nodeTo.appendChild(node);
        }
    }

    public static void removeNodes(NodeList ns) {
        List<Node> nodeList = XmlUtil.convertNsList(ns);
        for (Node node : nodeList) {
            Node parent = node.getParentNode();
            parent.removeChild(node);
        }
    }

    public static void removeNodes(List<Element> nodeList) {
        for (Node node : nodeList) {
            Node parent = node.getParentNode();
            parent.removeChild(node);
        }
    }

    public static List<Node> renameNodes(NodeList ns, String newTag, Document doc) {
        List<Node> nodeList = XmlUtil.convertNsList(ns);
        for (Node node : nodeList) {
            doc.renameNode(node, null, newTag);
        }
        return nodeList;
    }

    public static void destroy(Node el) {
        List<Node> children = XmlUtil.convertNsList(el.getChildNodes());
        for (Node child : children) {
            XmlUtil.destroy(child);
            el.removeChild(child);
        }
    }

    public static void destroy(Document doc) {
        List<Node> children = XmlUtil.convertNsList(doc.getChildNodes());
        for (Node child : children) {
            XmlUtil.destroy(child);
            doc.removeChild(child);
        }
    }

    public static void setAttribute(Element e, String attr, boolean value, boolean isNode) {
        String s = value ? "true" : "false";
        XmlUtil.setAttribute(e, attr, s, isNode);
    }

    public static void setAttribute(Element parent, String name, String value, boolean isNode) {
        if (name == null || name.length() == 0 || value == null || value.length() == 0) {
            return;
        }
        if (isNode) {
            Element attributeNode = parent.getOwnerDocument().createElement(name);
            parent.appendChild(attributeNode);
            attributeNode.setTextContent(value);
        } else {
            parent.setAttribute(name, value);
        }
    }

    public static boolean testAttribute(String value, Element element, String attr, boolean isNode) {
        String attrValue = XmlUtil.getAttribute(element, attr, isNode);
        if (attrValue == null) {
            attrValue = "";
        }
        if (value == null) {
            value = "";
        }
        return attrValue.equalsIgnoreCase(value);
    }

    public static String getAttribute(Element element, String attr, boolean isNode, String defaultValue) {
        String value = XmlUtil.getAttribute(element, attr, isNode);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return value;
    }

    public static String getAttribute(Element element, String attr, boolean isNode) {
        if (isNode) {
            Element child = XmlUtil.getFirstChildByTagName(attr, element);
            if (child == null) {
                return null;
            }
            return child.getTextContent();
        }
        return element.getAttribute(attr);
    }

    public static boolean getAttributeBoolean(Element element, String attr, boolean isNode, boolean defaultValue) {
        String s = XmlUtil.getAttribute(element, attr, isNode, null);
        if (s == null) {
            return defaultValue;
        }
        return !s.equals("false");
    }

    public static List<Attr> getAttributes(Element element) {
        ArrayList<Attr> attributes = new ArrayList<Attr>();
        NamedNodeMap ns = element.getAttributes();
        int i = 0;
        while (i < ns.getLength()) {
            Node node = ns.item(i);
            if (node.getNodeType() == 2) {
                attributes.add((Attr)node);
            }
            ++i;
        }
        return attributes;
    }
}

