/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.gendoc;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.edgemind.ibee.gendoc.ItemRepo;
import net.edgemind.ibee.gendoc.LogUtil;
import net.edgemind.ibee.gendoc.filter.ConsistencyTestFilter;
import net.edgemind.ibee.gendoc.filter.ItemFilter;
import net.edgemind.ibee.gendoc.filter.NoExportItemFilter;
import net.edgemind.ibee.gendoc.filter.ProductFilter;
import net.edgemind.ibee.gendoc.html.HtmlGenerator;
import net.edgemind.ibee.gendoc.html.HtmlGeneratorConfig;
import net.edgemind.ibee.gendoc.image.ImageGenerator;
import net.edgemind.ibee.gendoc.image.ImageGeneratorConfig;
import net.edgemind.ibee.gendoc.input.item.ManualItemAdder;
import net.edgemind.ibee.gendoc.input.item.ManualItemConfig;
import net.edgemind.ibee.gendoc.org.OrgExtractorConfig;
import net.edgemind.ibee.gendoc.org.OrgItemExtractor;
import net.edgemind.ibee.gendoc.out.write.ItemWriter;
import net.edgemind.ibee.gendoc.out.write.ItemWriterConfig;
import net.edgemind.ibee.gendoc.pdf.OrgToPdfGenerator;
import net.edgemind.ibee.gendoc.pdf.OrgToPdfGeneratorConfig;
import net.edgemind.ibee.gendoc.toc.TocGenerator;
import net.edgemind.ibee.gendoc.toc.TocGeneratorConfig;
import net.edgemind.ibee.util.file.FileUtil;
import net.edgemind.ibee.util.misc.IFilter;
import net.edgemind.ibee.util.string.PatternUtil;
import net.edgemind.ibee.util.system.EnvUtil;
import net.edgemind.ibee.util.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DocGenerator {
    private StringBuffer reportBuf = new StringBuffer();

    public static void main(String[] args) throws IOException {
        if (args == null || args.length == 0) {
            throw new RuntimeException("Usage: DocGenerator <xml-file> [xml-file]+");
        }
        DocGenerator generator = new DocGenerator();
        generator.generate(Arrays.asList(args).stream().map(arg -> new File((String)arg)).collect(Collectors.toList()));
    }

    public void generate(List<File> xmlFilesOrDirs) throws IOException {
        boolean sucess = true;
        for (File fileOrDir : xmlFilesOrDirs) {
            if (fileOrDir.isDirectory()) {
                this.generateForConfig(fileOrDir);
                continue;
            }
            File parentDir = fileOrDir.getParentFile();
            String filePattern = fileOrDir.getName();
            if (filePattern.contains("*")) {
                IFilter fileFilter = file -> PatternUtil.wildCardMatchTotal((String)file.getName(), (String)filePattern);
                for (File file2 : FileUtil.findFiles((File)parentDir, (boolean)false, (IFilter)fileFilter)) {
                    sucess &= this.generateForConfig(file2);
                }
                continue;
            }
            sucess &= this.generateForConfig(fileOrDir);
        }
        this.showReport();
        System.exit(sucess ? 0 : -1);
    }

    public boolean generateForConfig(File cfgFileOrDir) throws IOException {
        boolean sucess = true;
        if (!cfgFileOrDir.exists()) {
            throw new RuntimeException("File not found " + String.valueOf(cfgFileOrDir));
        }
        if (cfgFileOrDir.isDirectory()) {
            sucess &= this.generateFolder(cfgFileOrDir);
        } else if (cfgFileOrDir.isFile()) {
            sucess &= this.generateFile(cfgFileOrDir);
        }
        return sucess;
    }

    private boolean generateFolder(File cfgFolder) throws IOException {
        boolean sucess = true;
        for (String cfgFile : FileUtil.readFiles((String)cfgFolder.getAbsolutePath(), (Boolean)false, (String)"xml$", (String)(cfgFolder.getAbsolutePath() + "/"))) {
            sucess &= this.generateFile(new File(cfgFile));
        }
        return sucess;
    }

    private boolean generateFile(File cfgFile) throws IOException {
        try {
            LogUtil.log("-----------------");
            LogUtil.log("Generation of " + cfgFile.getAbsolutePath());
            LogUtil.log("-----------------");
            DocGenerator gen = new DocGenerator();
            gen.doGenerate(cfgFile);
            this.reportBuf.append(String.format("File %s: OK\n", cfgFile.getAbsolutePath()));
            return true;
        }
        catch (Throwable t) {
            this.reportBuf.append(String.format("!!! File %s: NOK !!!\n", cfgFile.getAbsolutePath()));
            t.printStackTrace();
            return false;
        }
    }

    private void showReport() {
        LogUtil.log("-----------------");
        LogUtil.log("Generation Report");
        LogUtil.log("-----------------");
        String[] stringArray = this.reportBuf.toString().split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            LogUtil.log(line);
            ++n2;
        }
    }

    private void doGenerate(File configFile) throws Exception {
        Element elFilter;
        Element elInput;
        ItemRepo repo = new ItemRepo();
        Document doc = XmlUtil.readXmlFile((File)configFile);
        this.replaceConditions(doc);
        Element elRoot = doc.getDocumentElement();
        Element elExecuteScript = XmlUtil.getFirstChildByTagName((String)"execute-script", (Element)elRoot);
        if (elExecuteScript != null) {
            String scriptPath = XmlUtil.getAttribute((Element)elExecuteScript, (String)"path", (boolean)false).trim();
            File scriptFile = new File(configFile.getParentFile().getAbsolutePath() + File.separator + scriptPath);
            LogUtil.log(String.format("Execute sub script %s with variable :", scriptFile.getAbsolutePath()));
            for (Element el : XmlUtil.getChildrenByTagName((String)"variable", (Element)elExecuteScript)) {
                String varName = XmlUtil.getAttribute((Element)el, (String)"name", (boolean)false).trim();
                String varValue = el.getTextContent();
                varValue = EnvUtil.replaceEnvVars((String)varValue);
                LogUtil.log(String.format("[%s]\t : %s", varName, varValue));
                System.getProperties().put(varName, varValue);
            }
            Document subdoc = XmlUtil.readXmlFile((File)scriptFile);
            this.replaceConditions(subdoc);
            elRoot = subdoc.getDocumentElement();
        }
        if ((elInput = XmlUtil.getFirstChildByTagName((String)"input", (Element)elRoot)) != null) {
            for (Element el : XmlUtil.getChildren((Element)elInput)) {
                if (el.getTagName().equals("items")) {
                    ManualItemConfig manualCfg = new ManualItemConfig();
                    manualCfg.fromXml(el);
                    ManualItemAdder itemAdder = new ManualItemAdder(repo);
                    itemAdder.apply(manualCfg);
                }
                if (!el.getTagName().equals("org")) continue;
                Object orgFile = XmlUtil.getAttribute((Element)el, (String)"file", (boolean)true).trim();
                orgFile = EnvUtil.replaceEnvVars((String)orgFile);
                OrgExtractorConfig extractorCfg = new OrgExtractorConfig();
                extractorCfg.fromXml(el);
                OrgItemExtractor extractor = new OrgItemExtractor(repo);
                extractor.extractItems(new File((String)orgFile), extractorCfg);
            }
        }
        if ((elFilter = XmlUtil.getFirstChildByTagName((String)"filter", (Element)elRoot)) != null) {
            for (Element el : XmlUtil.getChildren((Element)elFilter)) {
                if (!el.getTagName().equals("consistency-test")) continue;
                ConsistencyTestFilter filter = new ConsistencyTestFilter();
                repo.getAllItems().forEach(filter::apply);
            }
        }
        this.applyDefaultIgnoreFilter(repo);
        Element elOutput = XmlUtil.getFirstChildByTagName((String)"output", (Element)elRoot);
        if (elOutput != null) {
            for (Element el : XmlUtil.getChildren((Element)elOutput)) {
                Object gen;
                Object genCfg;
                if (el.getTagName().equals("html")) {
                    genCfg = new HtmlGeneratorConfig();
                    ((HtmlGeneratorConfig)genCfg).fromXml(el);
                    gen = new HtmlGenerator(repo);
                    ((HtmlGenerator)gen).generate((HtmlGeneratorConfig)genCfg);
                    continue;
                }
                if (el.getTagName().equals("elipse-toc")) {
                    genCfg = new TocGeneratorConfig();
                    ((TocGeneratorConfig)genCfg).fromXml(el);
                    gen = new TocGenerator(repo);
                    ((TocGenerator)gen).generate((TocGeneratorConfig)genCfg);
                    continue;
                }
                if (el.getTagName().equals("config-gen-org")) {
                    genCfg = new TocGeneratorConfig();
                    ((TocGeneratorConfig)genCfg).fromXml(el);
                    gen = new TocGenerator(repo);
                    ((TocGenerator)gen).generate((TocGeneratorConfig)genCfg);
                    continue;
                }
                if (el.getTagName().equals("org-to-pdf")) {
                    genCfg = new OrgToPdfGeneratorConfig();
                    ((OrgToPdfGeneratorConfig)genCfg).fromXml(el);
                    gen = new OrgToPdfGenerator(repo);
                    ((OrgToPdfGenerator)gen).generate((OrgToPdfGeneratorConfig)genCfg);
                    continue;
                }
                if (el.getTagName().equals("generate-images")) {
                    genCfg = new ImageGeneratorConfig();
                    ((ImageGeneratorConfig)genCfg).fromXml(el);
                    gen = new ImageGenerator();
                    ((ImageGenerator)gen).generate((ImageGeneratorConfig)genCfg);
                    continue;
                }
                if (!el.getTagName().equals("write")) continue;
                genCfg = new ItemWriterConfig();
                ((ItemWriterConfig)genCfg).fromXml(el);
                gen = new ItemWriter(repo);
                ((ItemWriter)gen).generate((ItemWriterConfig)genCfg);
            }
        }
    }

    private void applyDefaultIgnoreFilter(ItemRepo repo) {
        LogUtil.log(String.format("Apply 'noexport' Filter", new Object[0]));
        this.applyDefaultIgnoreFilter(repo, new NoExportItemFilter());
        String product = EnvUtil.getEnv((String)"product", (boolean)true);
        if (product != null && product.length() > 0) {
            LogUtil.log(String.format("Apply Product Filter '%s'", product));
            this.applyDefaultIgnoreFilter(repo, new ProductFilter(product));
        }
    }

    private void applyDefaultIgnoreFilter(ItemRepo repo, ItemFilter filter) {
        repo.getAllItems().forEach(filter::apply);
    }

    private void replaceConditions(Document doc) {
        Element elRoot = doc.getDocumentElement();
        for (Element child : XmlUtil.getChildren((Element)elRoot)) {
            this.replaceConditions(child, elRoot);
        }
    }

    private void replaceConditions(Element el, Element parent) {
        if (el.getNodeName().equalsIgnoreCase("ifdef")) {
            String varName = el.getAttribute("variable");
            if (EnvUtil.getEnv((String)varName, (boolean)true) != null) {
                for (Element child : XmlUtil.getChildren((Element)el)) {
                    parent.appendChild(child);
                }
            }
            parent.removeChild(el);
        } else {
            for (Element child : XmlUtil.getChildren((Element)el)) {
                this.replaceConditions(child, el);
            }
        }
    }
}

