/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.gendoc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.edgemind.ibee.gendoc.Item;
import net.edgemind.ibee.gendoc.ItemFormatConverter;
import net.edgemind.ibee.gendoc.ItemRepo;
import net.edgemind.ibee.gendoc.LogUtil;

public class ItemReplacer {
    private ItemRepo repo;
    private Map<String, String> resolvedContent = new HashMap<String, String>();
    private String targetFormat;
    private boolean resolve = true;
    private boolean withChilds = true;
    ItemFormatConverter formatConverter = new ItemFormatConverter();

    public ItemReplacer(ItemRepo repo, String targetFormat) {
        this.repo = repo;
        this.targetFormat = targetFormat;
    }

    public boolean isResolve() {
        return this.resolve;
    }

    public void setResolve(boolean resolve) {
        this.resolve = resolve;
    }

    public String getContent(Item item, int depth) {
        String key = String.format("%s-%d", item.getId(), depth);
        if (this.resolvedContent.containsKey(key)) {
            return this.resolvedContent.get(key);
        }
        Object content = this.getContentInTargetFormat(item);
        if (this.resolve) {
            content = this.resolve((String)content, depth);
        }
        if (this.withChilds) {
            StringBuffer buf = new StringBuffer();
            for (Item child : item.getChilds()) {
                String chapterText = this.produceChapter(child.getTitle(), depth + 1);
                String chapterLine = this.getContentInTargetFormat(chapterText, "orgMode");
                buf.append("\n");
                buf.append(chapterLine);
                buf.append("\n");
                buf.append(this.getContent(child, depth + 1));
            }
            String childsString = buf.toString().trim();
            if (!childsString.isEmpty()) {
                content = (String)content + "\n" + childsString;
            }
        }
        this.resolvedContent.put(key, (String)content);
        return content;
    }

    private String produceChapter(String title, int depth) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < depth) {
            buf.append("*");
            ++i;
        }
        buf.append(" ");
        buf.append(title);
        return buf.toString();
    }

    private String getContentInTargetFormat(Item item) {
        return this.formatConverter.getContentInTargetFormat(item, this.targetFormat);
    }

    private String getContentInTargetFormat(String content, String format) {
        return this.formatConverter.getContentInTargetFormat(content, format, this.targetFormat);
    }

    private String resolve(String content, int depth) {
        StringBuffer buf = new StringBuffer();
        String[] stringArray = content.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (buf.length() > 0) {
                buf.append("\n");
            }
            line = this.replace(line, depth);
            line = this.replace2(line, depth);
            buf.append(line);
            ++n2;
        }
        return buf.toString();
    }

    private String replace(String line, int depth) {
        Pattern pattern = Pattern.compile("\\{\\{([\\w-]+)\\}\\}|<em:insert\\s+id\\s*=\\s*\"(.+)\"\\s*/>");
        Matcher matcher = pattern.matcher(line);
        StringBuffer buf = new StringBuffer();
        int last = 0;
        while (matcher.find()) {
            String varName = matcher.group(1);
            Item item = this.repo.findItem(varName);
            String replacement = matcher.group();
            if (item != null) {
                replacement = this.getContent(item, depth);
            } else {
                LogUtil.error(String.format("Cannot resolve item '%s'", varName));
            }
            buf.append(line.subSequence(last, matcher.start()));
            buf.append(replacement);
            last = matcher.end();
        }
        buf.append(line.subSequence(last, line.length()));
        return buf.toString();
    }

    private String replace2(String line, int depth) {
        Pattern pattern = Pattern.compile("<%(([\\w-*]+)\\.)?([\\w-*]+)%>");
        Matcher matcher = pattern.matcher(line);
        StringBuffer buf = new StringBuffer();
        int last = 0;
        while (matcher.find()) {
            String ns = matcher.group(2);
            String itemId = matcher.group(3);
            List<Item> items = this.repo.findItems(itemId, ns);
            Object replacement = "";
            if (items.isEmpty()) {
                LogUtil.error(String.format("Cannot resolve item '%s'", itemId));
                replacement = matcher.group();
            } else {
                for (Item item : items) {
                    String chapterText = this.produceChapter(item.getTitle(), depth + 1);
                    String chapterLine = this.getContentInTargetFormat(chapterText, "orgMode");
                    replacement = (String)replacement + "\n" + chapterLine + "\n";
                    replacement = (String)replacement + this.getContent(item, depth + 1);
                }
            }
            buf.append(line.subSequence(last, matcher.start()));
            buf.append((String)replacement);
            last = matcher.end();
        }
        buf.append(line.subSequence(last, line.length()));
        return buf.toString();
    }

    public boolean isWithChilds() {
        return this.withChilds;
    }

    public void setWithChilds(boolean withChilds) {
        this.withChilds = withChilds;
    }
}

