/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.gendoc.common;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.gendoc.DocUtil;
import net.edgemind.ibee.gendoc.common.DirReplication;
import net.edgemind.ibee.gendoc.common.Replication;
import net.edgemind.ibee.util.system.EnvUtil;
import net.edgemind.ibee.util.xml.XmlUtil;
import org.w3c.dom.Element;

public class ReplicationParser {
    private File workDir;

    public List<Replication> scanReplications(Element xml) {
        ArrayList<Replication> replications = new ArrayList<Replication>();
        for (Element elReplicate : XmlUtil.getChildrenByTagName((String)"replicate", (Element)xml)) {
            for (Element el : XmlUtil.getChildren((Element)elReplicate)) {
                if (!el.getTagName().equals("dir")) continue;
                this.addDirReplication(el, replications);
            }
        }
        return replications;
    }

    private void addDirReplication(Element el, List<Replication> replications) {
        String from = DocUtil.getAttributeWithEnv(el, "from");
        String to = DocUtil.getAttributeWithEnv(el, "to");
        DirReplication rep = new DirReplication();
        replications.add(rep);
        rep.setFrom(this.getAbsFile(from));
        rep.setTo(this.getAbsFile(to));
    }

    private File getAbsFile(String file) {
        if (file == null) {
            return this.workDir;
        }
        file = EnvUtil.replaceEnvVars((String)file);
        if (new File(file = file.trim()).isAbsolute()) {
            return new File(file);
        }
        return new File(this.workDir, file);
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(File workDir) {
        this.workDir = workDir;
    }
}

