/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.gendoc.html;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.gendoc.DocUtil;
import net.edgemind.ibee.gendoc.common.Replication;
import net.edgemind.ibee.gendoc.common.ReplicationParser;
import net.edgemind.ibee.util.string.StringUtil;
import net.edgemind.ibee.util.xml.XmlUtil;
import org.w3c.dom.Element;

public class HtmlGeneratorConfig {
    private List<ItemConfig> itemConfigs = new ArrayList<ItemConfig>();
    private List<Replication> replications = new ArrayList<Replication>();
    private File outDir;
    private AutoGeneration autoGeneration = null;

    public AutoGeneration getAutoGeneration() {
        return this.autoGeneration;
    }

    public void setAutoGeneration(AutoGeneration autoGeneration) {
        this.autoGeneration = autoGeneration;
    }

    public File getOutDir() {
        return this.outDir;
    }

    public void setOutDir(File outDir) {
        this.outDir = outDir;
    }

    public List<Replication> getReplications() {
        return this.replications;
    }

    public void setReplications(List<Replication> replications) {
        this.replications = replications;
    }

    public List<ItemConfig> getItemConfigs() {
        return this.itemConfigs;
    }

    public void setItemConfigs(List<ItemConfig> itemConfigs) {
        this.itemConfigs = itemConfigs;
    }

    public void fromXml(Element xml) throws IOException {
        String outdir = DocUtil.getAttributeWithEnv(xml, "outdir");
        this.setOutDir(new File(outdir));
        for (Element elItem : XmlUtil.getChildrenByTagName((String)"item", (Element)xml)) {
            ItemConfig newConfig = new ItemConfig();
            this.itemConfigs.add(newConfig);
            newConfig.setFile(DocUtil.getAttributeWithEnv(elItem, "file"));
            newConfig.setTitle(DocUtil.getAttributeWithEnv(elItem, "title"));
            newConfig.setId(DocUtil.getAttributeWithEnv(elItem, "id"));
            newConfig.setRecursive(DocUtil.getAttributeWithEnv(elItem, "recursive", "false").equalsIgnoreCase("true"));
            Element cssFiles = XmlUtil.getFirstChildByTagName((String)"css-files", (Element)elItem);
            if (cssFiles == null) continue;
            for (Element elPath : XmlUtil.getChildrenByTagName((String)"path", (Element)cssFiles)) {
                this.autoGeneration.addCssFile(elPath.getNodeValue());
            }
        }
        ReplicationParser replicationParser = new ReplicationParser();
        replicationParser.setWorkDir(this.outDir);
        this.replications = replicationParser.scanReplications(xml);
        Element elAuto = XmlUtil.getFirstChildByTagName((String)"auto", (Element)xml);
        if (elAuto != null) {
            Element cssFiles;
            AutoGeneration autoGeneration = new AutoGeneration();
            autoGeneration.setRecursive(DocUtil.getAttributeWithEnv(elAuto, "recursive", "false").equalsIgnoreCase("true"));
            this.setAutoGeneration(autoGeneration);
            String levels = DocUtil.getAttributeWithEnv(elAuto, "levels");
            if (levels != null) {
                String[] stringArray = levels.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String level = stringArray[n2];
                    autoGeneration.addLevel(StringUtil.toInt((String)level));
                    ++n2;
                }
            }
            if ((cssFiles = XmlUtil.getFirstChildByTagName((String)"css-files", (Element)elAuto)) != null) {
                for (Element elPath : XmlUtil.getChildrenByTagName((String)"path", (Element)cssFiles)) {
                    autoGeneration.addCssFile(elPath.getTextContent());
                }
            }
            autoGeneration.setNamespace(DocUtil.getAttributeWithEnv(elAuto, "namespace"));
        }
    }

    public static class AutoGeneration {
        private List<Integer> levels = new ArrayList<Integer>();
        private boolean recursive;
        private List<String> cssFiles = new ArrayList<String>();
        private String namespace;

        public boolean isRecursive() {
            return this.recursive;
        }

        public void setRecursive(boolean recursive) {
            this.recursive = recursive;
        }

        public List<Integer> getLevels() {
            return this.levels;
        }

        public void setLevels(List<Integer> levels) {
            this.levels = levels;
        }

        public void addLevel(Integer level) {
            this.levels.add(level);
        }

        public void addCssFile(String cssFile) {
            this.cssFiles.add(cssFile);
        }

        public List<String> getCssFiles() {
            return this.cssFiles;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }
    }

    public static class ItemConfig {
        private String title;
        private String id;
        private boolean recursive = false;
        private String file;
        private List<String> cssFiles = new ArrayList<String>();

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public boolean isRecursive() {
            return this.recursive;
        }

        public void setRecursive(boolean recursive) {
            this.recursive = recursive;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void addCssFile(String cssFile) {
            this.cssFiles.add(cssFile);
        }

        public List<String> getCssFiles() {
            return this.cssFiles;
        }
    }
}

