/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.gendoc.image;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.gendoc.DocUtil;
import net.edgemind.ibee.util.xml.XmlUtil;
import org.w3c.dom.Element;

public class ImageGeneratorConfig {
    private File imgFolder;
    private File outputFolder;
    private List<String> inputTypes = new ArrayList<String>();
    private List<String> outputTypes = new ArrayList<String>();

    public File getImgFolder() {
        return this.imgFolder;
    }

    public void setImgFolder(File imgFolder) {
        this.imgFolder = imgFolder;
    }

    public File getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(File outputFolder) {
        this.outputFolder = outputFolder;
    }

    public void fromXml(Element xml) throws IOException {
        String imgFolder = DocUtil.getAttributeWithEnv(xml, "img-folder");
        this.setImgFolder(new File(imgFolder));
        String outputFolder = DocUtil.getAttributeWithEnv(xml, "output-folder");
        this.setOutputFolder(new File(outputFolder));
        this.parseInputTypes(xml);
        this.parseOutputTypes(xml);
        if (this.inputTypes.size() == 0) {
            throw new RuntimeException("Image generation: no input types specified");
        }
        if (this.outputTypes.size() == 0) {
            throw new RuntimeException("Image generation: no output types specified");
        }
    }

    private void parseInputTypes(Element xml) {
        Element elInputTypes = XmlUtil.getFirstChildByTagName((String)"input-types", (Element)xml);
        if (elInputTypes != null) {
            for (Element elInputType : XmlUtil.getChildrenByTagName((String)"type", (Element)elInputTypes)) {
                String typeName = elInputType.getTextContent().trim();
                if (typeName.length() > 0) {
                    this.inputTypes.add(typeName);
                    continue;
                }
                throw new RuntimeException("img generation input type cannot be empty");
            }
        }
    }

    private void parseOutputTypes(Element xml) {
        Element elOutoutTypes = XmlUtil.getFirstChildByTagName((String)"output-types", (Element)xml);
        if (elOutoutTypes != null) {
            for (Element elOutputType : XmlUtil.getChildrenByTagName((String)"type", (Element)elOutoutTypes)) {
                String typeName = elOutputType.getTextContent().trim();
                if (typeName.length() > 0) {
                    this.outputTypes.add(typeName);
                    continue;
                }
                throw new RuntimeException("img generation output type cannot be empty");
            }
        }
    }

    public List<String> getInputTypes() {
        return this.inputTypes;
    }

    public List<String> getOutputTypes() {
        return this.outputTypes;
    }
}

