/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.gendoc.org;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.edgemind.ibee.util.string.StringUtil;

public class EmToOrgConverter {
    StringBuffer buf;
    int ulIndent = -1;
    StringBuffer controlBuf;
    String mode = "";

    public String convert(String in) {
        this.buf = new StringBuffer();
        String[] stringArray = in.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            line = this.replace("<pre>", "</pre>", "<", ">", line);
            line = this.replace("<strong>", "</strong>", "=", "=", line);
            line = this.replace("<i>", "</i>", "/", "/", line);
            line = this.replace("<strong>", "</strong>", "*", "*", line);
            this.buf.append(line);
            this.buf.append("\n");
            ++n2;
        }
        return this.buf.toString();
    }

    private String replace(String enclosingStr1, String enclosingStr2, String newEnclosingTag1, String newEnclosingTag2, String line) {
        Pattern pattern = Pattern.compile(enclosingStr1 + "([^\"]+?)" + enclosingStr2);
        Matcher matcher = pattern.matcher(line);
        StringBuffer buf = new StringBuffer();
        int last = 0;
        while (matcher.find()) {
            buf.append(line.subSequence(last, matcher.start()));
            buf.append(newEnclosingTag1);
            buf.append(matcher.group(1));
            buf.append(newEnclosingTag2);
            last = matcher.end();
        }
        buf.append(line.subSequence(last, line.length()));
        return buf.toString();
    }

    private void addFigure(String line) {
        line = line.trim();
        String imgSource = line.substring(2, line.length() - 2);
        if ((imgSource = imgSource.replaceAll("\\.pdf", ".png")).endsWith(".pdf")) {
            this.writeln(String.format("<embed src='%s'/>", imgSource));
        } else {
            String width = this.getWidthFromControlBuf();
            StringBuffer buf = new StringBuffer();
            buf.append(String.format("<img src='%s'", imgSource));
            if (width != null) {
                buf.append(String.format(" width='%s'", width));
            }
            buf.append("/>");
            this.writeln(buf.toString());
        }
    }

    private String getLatexArgAfter(String key, String line) {
        Pattern pattern = Pattern.compile(key + "\\s+(.+?)(\\s+|$)");
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            return line.substring(matcher.start(1), matcher.end(1)).trim();
        }
        return null;
    }

    private String getWidthFromControlBuf() {
        String[] stringArray = this.controlBuf.toString().split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if ((line = line.trim()).startsWith("#+ATTR_LATEX:") && line.contains(":width")) {
                String width = this.getLatexArgAfter(":width", line);
                if (width != null && width.endsWith("\\textwidth")) {
                    int index = width.indexOf("\\");
                    double widthDouble = StringUtil.toDouble((String)width.substring(0, index).trim(), (double)1.0) * 100.0;
                    return widthDouble + "%";
                }
                return width;
            }
            ++n2;
        }
        return null;
    }

    private void createTable(String line) {
        this.writeln();
        this.writeln("<div>");
        this.writeln("<table>");
        this.addTableRow(line);
    }

    private void addTableRow(String line) {
        if ((line = line.trim()).matches("[|\\-+]+")) {
            return;
        }
        this.write("<tr>");
        if (line.startsWith("|")) {
            line = line.substring(1);
        }
        if (line.endsWith("|")) {
            line = line.substring(0, line.length() - 1);
        }
        String[] stringArray = line.split("\\|");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            this.write("<td>");
            arg = arg.trim();
            this.buf.append(arg);
            ++n2;
        }
        this.writeln("");
    }

    private void finishTable(String line) {
        this.writeln("</table width='100%'>");
        this.writeln("<div>");
    }

    int countIndent(String line) {
        int cnt = 0;
        while (line.charAt(cnt) == ' ') {
            ++cnt;
        }
        return cnt;
    }

    void createUls(int nr) {
        if (nr > 0) {
            int i = 0;
            while (i < nr) {
                this.buf.append("<ul>");
                ++i;
            }
        } else {
            int i = 0;
            while (i < -nr) {
                this.buf.append("</ul>");
                ++i;
            }
        }
    }

    private void write(String msg) {
        this.buf.append(msg);
    }

    private void writeln() {
        this.writeln("");
    }

    private void writeln(String msg) {
        this.write(msg + "\n");
    }
}

