/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.gendoc.org;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.edgemind.ibee.gendoc.Item;
import net.edgemind.ibee.gendoc.ItemRepo;
import net.edgemind.ibee.gendoc.org.OrgExtractorConfig;

public class OrgItemExtractor {
    private boolean record = false;
    private boolean isSourceCode = false;
    private ItemRepo repo;
    private OrgExtractorConfig cfg;
    private Item currItem;
    private BufferedReader reader;
    private List<Item> items;
    private boolean insideMultiPropertySection = false;
    private boolean isHeader = true;
    Stack<TitleStackEntry> titleStack = new Stack();
    Map<Integer, Item> ItemStack = new HashMap<Integer, Item>();

    public OrgItemExtractor(ItemRepo repo) {
        this.repo = repo;
    }

    public void extractItems(File orgFile, OrgExtractorConfig cfg) throws IOException {
        this.cfg = cfg;
        this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(orgFile), Charset.forName("UTF-8")));
        OrgExtractorConfig.ItemConfig itemCfg = this.getItemConfig(0);
        boolean scanHeader = itemCfg != null;
        this.items = new ArrayList<Item>();
        while (this.reader.ready()) {
            String line = this.reader.readLine();
            if (this.isTitleLine(line)) {
                this.isHeader = false;
            }
            if (this.isHeader && scanHeader) {
                this.scanHeaderLine(line);
                continue;
            }
            this.scanBodyLine(line);
        }
        this.reader.close();
        for (Item item : this.items) {
            String content = item.getContent().trim();
            if (!Pattern.matches("(?s)#\\+BEGIN_SRC.*#\\+END_SRC", content)) continue;
            item.setFormat(this.getSourceCodeFormat(content));
            item.setContent(this.removeOuterLines(content));
        }
    }

    private void scanHeaderLine(String line) {
        if (this.currItem == null) {
            OrgExtractorConfig.ItemConfig cfg = this.getItemConfig(0);
            String id = this.getItemId(cfg);
            this.currItem = this.createItem(id, this.getNamespace(cfg));
            this.currItem.setTitle("header");
            this.addItem(this.currItem, 1);
            this.currItem.setStandalone(false);
        } else {
            this.currItem.println(line);
        }
    }

    private void scanBodyLine(String line) throws IOException {
        if (this.isBeginSrcLine(line)) {
            this.isSourceCode = true;
            this.currItem.println(line);
            return;
        }
        if (this.isEndSrcLine(line)) {
            this.isSourceCode = false;
            this.currItem.println(line);
            return;
        }
        if (this.isSourceCode) {
            this.currItem.println(line);
            return;
        }
        if (this.isTitleLine(line)) {
            line = line.trim();
            Set<String> tags = this.parseItemTagsFromLine(line);
            int depth = this.getTitleDepth(line);
            String title = this.extractTitle(line);
            this.popTitleStack(depth);
            boolean export = tags.contains("export");
            this.addTitle(title, depth, export);
            if (this.record && depth <= this.getMinItemDepth()) {
                this.record = false;
            }
            OrgExtractorConfig.ItemConfig cfg = this.getItemConfig(depth);
            boolean bl = this.record = this.record || cfg != null;
            if (this.record) {
                this.popItemStack(depth);
                String id = this.getItemId(cfg);
                this.currItem = this.createItem(id, this.getNamespace(cfg));
                this.currItem.setTitle(title);
                this.addItem(this.currItem, depth);
                this.currItem.setTags(tags);
                this.currItem.setStandalone(export);
            }
        } else if (this.record) {
            if (this.insideMultiPropertySection) {
                if (line.trim().equals(":END:")) {
                    this.insideMultiPropertySection = false;
                } else {
                    this.addMultiPropertyFromLine(line);
                }
            } else if (this.isMultiPropertySectionBegin(line)) {
                this.insideMultiPropertySection = true;
            } else if (this.isProperty(line)) {
                this.addSinglePropertyFromLine(line);
            } else {
                this.currItem.println(line);
            }
        }
    }

    private boolean isMultiPropertySectionBegin(String line) {
        return line.trim().equals(":PROPERTIES:");
    }

    private boolean isProperty(String line) {
        return line.startsWith("#+PROPERTY");
    }

    private String getNamespace(OrgExtractorConfig.ItemConfig cfg) {
        return cfg != null ? cfg.getNamespace() : null;
    }

    private String getItemId(OrgExtractorConfig.ItemConfig cfg) {
        String id = null;
        if (cfg != null) {
            id = cfg.getId();
        }
        if (id == null) {
            id = this.getIdFromTitle();
        }
        return id;
    }

    private void addItem(Item item, int depth) {
        if (this.ItemStack.isEmpty()) {
            this.repo.addItem(item);
        } else {
            Item head = this.getHeadItem();
            head.addChild(item);
        }
        this.items.add(item);
        this.ItemStack.put(depth, item);
    }

    public int getMinItemDepth() {
        int minDepth = -1;
        for (int itemDepth : this.ItemStack.keySet()) {
            if (itemDepth == 0 || itemDepth >= minDepth && minDepth != -1) continue;
            minDepth = itemDepth;
        }
        return minDepth;
    }

    public Item getHeadItem() {
        Item head = null;
        int maxDepth = -1;
        for (int itemDepth : this.ItemStack.keySet()) {
            if (itemDepth <= maxDepth) continue;
            maxDepth = itemDepth;
            head = this.ItemStack.get(itemDepth);
        }
        return head;
    }

    public void popItemStack(int depth) {
        for (int itemDepth : new HashSet<Integer>(this.ItemStack.keySet())) {
            if (itemDepth < depth) continue;
            this.ItemStack.remove(itemDepth);
        }
    }

    public void addTitle(String title, int depth, boolean export) {
        int itemDepth = this.titleStack.size();
        while (itemDepth < depth - 1) {
            this.titleStack.add(new TitleStackEntry("", false));
            ++itemDepth;
        }
        this.titleStack.add(new TitleStackEntry(title, export));
    }

    public void popTitleStack(int depth) {
        if (depth < 0) {
            return;
        }
        if (depth > this.titleStack.size()) {
            return;
        }
        Stack newStack = new Stack();
        newStack.addAll(this.titleStack.subList(0, depth - 1));
        this.titleStack = newStack;
    }

    private boolean isBeginSrcLine(String line) {
        return Pattern.matches("\\s*#\\+BEGIN_SRC.*", line);
    }

    private String getSourceCodeFormat(String line) {
        Pattern pattern = Pattern.compile("#\\+BEGIN_SRC\\s(\\w+)");
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            return matcher.group(1).toString().trim();
        }
        return "";
    }

    private String removeOuterLines(String line) {
        String s = "";
        String regex = "^[^\\n]*\\n([\\s\\S]*?)\\n[^\\n]*$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(line);
        if (matcher.matches()) {
            s = matcher.group(1).trim();
        }
        return s;
    }

    private boolean isEndSrcLine(String line) {
        return Pattern.matches("\\s*#\\+END_SRC.*", line);
    }

    private boolean isTitleLine(String line) {
        return Pattern.matches("^\\*+\\s+.+", line);
    }

    private OrgExtractorConfig.ItemConfig getItemConfig(int itemLevel) {
        String titleQid = this.getTitleQidAsString();
        return this.getItemConfig(titleQid, itemLevel);
    }

    private OrgExtractorConfig.ItemConfig getItemConfig(String titleQid, int itemLevel) {
        for (OrgExtractorConfig.ItemConfig cfg : this.cfg.getItemConfigs()) {
            if (!cfg.getLevels().isEmpty() && !cfg.getLevels().contains(itemLevel)) continue;
            if (cfg.match == null) {
                return cfg;
            }
            String expr = cfg.match.replaceAll("\\*", ".*");
            Pattern p = Pattern.compile(expr);
            Matcher matcher = p.matcher(titleQid);
            if (!matcher.matches()) continue;
            return cfg;
        }
        return null;
    }

    private String getTitleQidAsString() {
        StringBuffer buf = new StringBuffer();
        for (TitleStackEntry s : this.titleStack) {
            if (buf.length() > 0) {
                buf.append("/");
            }
            buf.append(s.title);
        }
        return buf.toString();
    }

    private Item createItem(String id, String namespace) {
        Item item = new Item();
        item.setId(id);
        item.setNamespace(namespace);
        item.setFormat("orgMode");
        return item;
    }

    private String getIdFromTitle() {
        boolean skipParent = this.ItemStack.size() > 0;
        StringBuffer buf = new StringBuffer();
        int i = this.titleStack.size() - 1;
        while (i >= 0) {
            if (buf.length() > 0) {
                buf.insert(0, "/");
            }
            TitleStackEntry entry = (TitleStackEntry)this.titleStack.get(i);
            buf.insert(0, this.getIdFromTitle(entry.title));
            if (entry.export || skipParent) break;
            --i;
        }
        return buf.toString();
    }

    private String getIdFromTitle(String title) {
        String id = title.toLowerCase().replaceAll("\\s+", "-");
        id = id.replaceAll("\\*", "");
        id = id.replaceAll("\"", "");
        return id;
    }

    private String extractTitle(String line) {
        while (line.startsWith("*")) {
            line = line.substring(1);
        }
        Pattern pattern = Pattern.compile(":\\w+:");
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            line = line.substring(0, matcher.start());
        }
        if (line.endsWith(":")) {
            line = line.substring(0, line.length() - 1);
        }
        line = line.trim();
        return line;
    }

    private int getTitleDepth(String line) {
        int cnt = 0;
        int i = 0;
        while (i < line.length()) {
            if (line.charAt(i) != '*') break;
            ++cnt;
            ++i;
        }
        return cnt;
    }

    private void addSinglePropertyFromLine(String line) {
        Pattern pattern = Pattern.compile("#\\+PROPERTY:\\s*(\\w+)\\s+(.+)");
        Matcher matcher = pattern.matcher(line.trim());
        if (matcher.matches()) {
            String key = matcher.group(1).trim();
            String value = matcher.group(2).trim();
            this.currItem.getProperties().put(key, value);
        }
    }

    private void addMultiPropertyFromLine(String line) {
        Pattern pattern = Pattern.compile(":(\\w+):(.+)");
        Matcher matcher = pattern.matcher(line.trim());
        if (matcher.matches()) {
            String key = matcher.group(1).trim();
            String value = matcher.group(2).trim();
            this.currItem.getProperties().put(key, value);
        }
    }

    private Set<String> parseItemTagsFromLine(String line) {
        HashSet<String> tags = new HashSet<String>();
        Pattern pattern = Pattern.compile(":(\\w+)");
        Matcher matcher = pattern.matcher(line);
        while (matcher.find()) {
            String tag = matcher.group(1);
            tags.add(tag);
        }
        return tags;
    }

    public static class TitleStackEntry {
        String title;
        boolean export;

        public TitleStackEntry(String title, boolean export) {
            this.title = title;
            this.export = export;
        }
    }
}

