/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.gendoc.org;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.edgemind.ibee.gendoc.RefResolver;
import net.edgemind.ibee.util.Tuple;
import net.edgemind.ibee.util.string.StringUtil;

public class OrgToEmConverter {
    StringBuffer buf;
    int currentUlLevel = 0;
    int currentUlIndent = -1;
    StringBuffer controlBuf;
    String mode = "";
    Map<Integer, Integer> indents = new HashMap<Integer, Integer>();
    boolean liTagIsOpen = false;
    List<Replacement> replacements = new ArrayList<Replacement>();
    RefResolver refResolver = s -> s.toLowerCase();
    public static String tokenDelimiter = "[\\s,?;.:!\"'-*]";

    private void initReplacements() {
        this.replacements.add(new Replacement("", this.buildPatternSingle("\\\\\\\\"), "", new TokenReplacement("\\\\", "<br>")));
        this.replacements.add(new Replacement("", this.buildPatternSingle("\\\\newline"), this.buildEndPattern(), new TokenReplacement("\\newline", "<br>")));
        this.replacements.add(new Replacement("", this.buildPatternSimple("\\[\\[", "\\]\\]"), "", new TokenBasedReplacement("[[", "]]", this::resolveReference, false)));
        this.replacements.add(new Replacement(this.buildStartPattern(), this.buildPattern("<", ">"), this.buildEndPattern(), new TokenTagReplacement("<", ">", "pre", true)));
        this.replacements.add(new Replacement(this.buildStartPattern(), this.buildPattern("="), this.buildEndPattern(), new TokenTagReplacement("=", "=", "strong", true)));
        this.replacements.add(new Replacement(this.buildStartPattern(), this.buildPattern("\\*"), this.buildEndPattern(), new TokenTagReplacement("*", "*", "strong", true)));
        this.replacements.add(new Replacement(this.buildStartPattern(), this.buildPattern("/"), this.buildEndPattern(), new TokenTagReplacement("/", "/", "i", true)));
    }

    private String buildPatternSingle(String tokenStart) {
        return String.format("%s", tokenStart);
    }

    private String buildPatternSimple(String tokenStart, String tokenEnd) {
        return String.format("%s.*?%s", tokenStart, tokenEnd);
    }

    private String buildStartPattern() {
        return String.format("^|%s", tokenDelimiter);
    }

    private String buildPattern(String token) {
        return this.buildPattern(token, token);
    }

    private String buildPattern(String tokenStart, String tokenEnd) {
        return String.format("%s(\\S|(\\S.*?\\S))%s", tokenStart, tokenEnd);
    }

    private String buildEndPattern() {
        return String.format("%s|$", tokenDelimiter);
    }

    public void setRefResolver(RefResolver resolver) {
        this.refResolver = resolver;
    }

    public String convert(String in) {
        this.initReplacements();
        this.controlBuf = new StringBuffer();
        this.buf = new StringBuffer();
        String[] stringArray = in.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (this.mode.equals("source")) {
                if (line.trim().startsWith("#+END_SRC")) {
                    this.mode = "";
                    this.buf.append("</xmp>");
                } else {
                    this.buf.append(line);
                    this.buf.append("\n");
                }
            } else if (line.trim().startsWith("#+BEGIN_SRC")) {
                this.buf.append("<xmp>");
                this.mode = "source";
            } else if (line.trim().length() == 0) {
                this.buf.append("\n</div><div/>");
                this.controlBuf = new StringBuffer();
            } else if (line.trim().startsWith("#")) {
                this.controlBuf.append(line);
                this.controlBuf.append("\n");
            } else {
                if (line.trim().startsWith("- ")) {
                    this.closeOpenLi();
                    int ulIndent = this.countIndent(line);
                    line = line.trim().substring(0);
                    if (this.indents.containsKey(ulIndent)) {
                        Integer restoreUlLevel = this.indents.get(ulIndent);
                        this.createUls(restoreUlLevel - this.currentUlLevel);
                        this.currentUlLevel = restoreUlLevel;
                        this.currentUlIndent = ulIndent;
                        this.cleanIndents(restoreUlLevel);
                    } else if (ulIndent > this.currentUlIndent) {
                        ++this.currentUlLevel;
                        this.currentUlIndent = ulIndent;
                        this.indents.put(this.currentUlIndent, this.currentUlLevel);
                        this.createUls(1);
                    } else {
                        System.err.println("Corrupt indention in line '" + line + "'");
                    }
                    this.openLiTag();
                    line = line.substring(2);
                } else if (this.currentUlLevel >= 0 && (line.isEmpty() || !line.startsWith(" "))) {
                    this.closeOpenLi();
                    this.closeOpenUls();
                }
                if (line.trim().startsWith("|")) {
                    if (this.mode.equals("table")) {
                        this.addTableRow(line);
                    } else {
                        this.mode = "table";
                        this.createTable(line);
                    }
                } else {
                    if (this.mode.equals("table")) {
                        this.finishTable(line);
                        this.mode = "";
                    }
                    line = this.processLine(line);
                    this.buf.append(line);
                }
            }
            ++n2;
        }
        this.closeOpenLi();
        this.closeOpenUls();
        if (this.mode.equals("table")) {
            this.finishTable("");
            this.mode = "";
        }
        return this.buf.toString();
    }

    private String resolveReference(String ref) {
        if (this.isImage(ref)) {
            return this.addFigure(ref);
        }
        return this.addReference(ref);
    }

    private String addReference(String ref) {
        String target = this.refResolver.resolve(ref);
        return String.format("<a href=\"#%s\">%s</a>", target, ref);
    }

    private boolean isImage(String ref) {
        return (ref = ref.toLowerCase()).endsWith(".jpg") || ref.endsWith(".pdf") || ref.endsWith("png");
    }

    private void openLiTag() {
        this.closeOpenLi();
        this.buf.append("<li>");
        this.liTagIsOpen = true;
    }

    private void closeOpenLi() {
        if (this.liTagIsOpen) {
            this.buf.append("</li>");
            this.liTagIsOpen = false;
        }
    }

    private void closeOpenUls() {
        this.createUls(-this.currentUlLevel);
        this.currentUlLevel = 0;
        this.currentUlIndent = -1;
    }

    private void cleanIndents(Integer maxIndent) {
        this.indents.entrySet().removeIf(entry -> (Integer)entry.getKey() > maxIndent);
    }

    private String processLine(String line) {
        StringBuffer out = new StringBuffer();
        int index = 0;
        while (index < line.length()) {
            boolean replaced = false;
            Replacement repl = null;
            Tuple<Integer, Integer> match = null;
            for (Replacement next : this.replacements) {
                Tuple<Integer, Integer> nextMatch = this.findNext(line, next.patternPre, next.pattern, next.patternEnd, index);
                if (nextMatch == null || match != null && (Integer)nextMatch.first >= (Integer)match.first) continue;
                match = nextMatch;
                repl = next;
            }
            if (repl != null) {
                out.append(line.subSequence(index, (Integer)match.first));
                String expr = line.substring((Integer)match.first, (Integer)match.second);
                String replacedExpr = repl.replFct.apply(expr);
                out.append(replacedExpr);
                index = (Integer)match.second - 1;
                replaced = true;
            }
            if (!replaced) {
                out.append(line.substring(index));
                index = line.length() - 1;
            }
            ++index;
        }
        return out.toString();
    }

    private int processCommand(String line, int index, String tag, String replTag, StringBuffer out) {
        out.append(replTag);
        return index + tag.length() - 1;
    }

    private Tuple<Integer, Integer> findNext(String line, String patternPre, String pattern, String patternPost, int index) {
        String s;
        Pattern regex = Pattern.compile(String.format("(%s)(%s)(%s)", patternPre, pattern, patternPost));
        Matcher matcher = regex.matcher(s = line.substring(index));
        if (matcher.find()) {
            return new Tuple((Object)(index + matcher.start(2)), (Object)(index + matcher.end(2)));
        }
        return null;
    }

    private String addFigure(String path) {
        StringBuffer buf = new StringBuffer();
        String imgSource = path = path.trim();
        if ((imgSource = imgSource.replaceAll("\\.pdf", ".png")).endsWith(".pdf")) {
            buf.append(String.format("<embed src='%s'/>", imgSource));
        } else {
            String width = this.getWidthFromControlBuf();
            buf.append(String.format("<img src='%s'", imgSource));
            if (width != null) {
                buf.append(String.format(" style='width:%s;'", width));
            }
            buf.append("/>");
        }
        return buf.toString();
    }

    private String getLatexArgAfter(String key, String line) {
        Pattern pattern = Pattern.compile(key + "\\s+(.+?)(\\s+|$)");
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            return line.substring(matcher.start(1), matcher.end(1)).trim();
        }
        return null;
    }

    private String getWidthFromControlBuf() {
        String[] stringArray = this.controlBuf.toString().split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if ((line = line.trim()).startsWith("#+ATTR_LATEX:") && line.contains(":width")) {
                String width = this.getLatexArgAfter(":width", line);
                if (width != null && width.endsWith("\\textwidth")) {
                    int index = width.indexOf("\\");
                    double widthDouble = StringUtil.toDouble((String)width.substring(0, index).trim(), (double)1.0) * 100.0;
                    return widthDouble + "%";
                }
                return width;
            }
            ++n2;
        }
        return null;
    }

    private void createTable(String line) {
        this.writeln();
        this.writeln("<div>");
        this.writeln("<table>");
        this.addTableRow(line);
    }

    private void addTableRow(String line) {
        if ((line = line.trim()).matches("[|\\-+]+")) {
            return;
        }
        this.write("<tr>");
        if (line.startsWith("|")) {
            line = line.substring(1);
        }
        if (line.endsWith("|")) {
            line = line.substring(0, line.length() - 1);
        }
        String[] stringArray = line.split("\\|");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            this.write("<td>");
            arg = arg.trim();
            this.buf.append(arg);
            ++n2;
        }
        this.writeln("");
    }

    private void finishTable(String line) {
        this.writeln("</table width='100%'>");
        this.writeln("<div>");
    }

    int countIndent(String line) {
        int cnt = 0;
        while (line.charAt(cnt) == ' ') {
            ++cnt;
        }
        return cnt;
    }

    void createUls(int nr) {
        if (nr > 0) {
            int i = 0;
            while (i < nr) {
                this.buf.append("<ul>");
                ++i;
            }
        } else {
            int i = 0;
            while (i < -nr) {
                this.buf.append("</ul>");
                ++i;
            }
        }
    }

    private void write(String msg) {
        this.buf.append(msg);
    }

    private void writeln() {
        this.writeln("");
    }

    private void writeln(String msg) {
        this.write(msg + "\n");
    }

    public class Replacement {
        public String patternPre;
        public String pattern;
        public String patternEnd;
        public Function<String, String> replFct;

        public Replacement(String patternPre, String pattern, String patternEnd, Function<String, String> replFct) {
            this.patternPre = patternPre;
            this.pattern = pattern;
            this.patternEnd = patternEnd;
            this.replFct = replFct;
        }
    }

    public class SingleTagTokenReplacement
    extends TokenReplacement {
        public SingleTagTokenReplacement(String token, String newToken) {
            super("<" + newToken + "/>", newToken);
        }
    }

    public class TokenBasedReplacement
    implements Function<String, String> {
        public String tokenStart;
        public String tokenEnd;
        public boolean rec;
        public Function<String, String> replFct;

        public TokenBasedReplacement(String tokenStart, String tokenEnd, Function<String, String> replFct, boolean rec) {
            this.tokenStart = tokenStart;
            this.tokenEnd = tokenEnd;
            this.replFct = replFct;
            this.rec = rec;
        }

        @Override
        public String apply(String s) {
            if (s.startsWith(this.tokenStart)) {
                s = s.substring(this.tokenStart.length());
            }
            if (s.endsWith(this.tokenEnd)) {
                s = s.substring(0, s.length() - this.tokenEnd.length());
            }
            if (this.rec) {
                s = OrgToEmConverter.this.processLine(s);
            }
            return this.replFct.apply(s);
        }
    }

    public class TokenReplacement
    extends TokenBasedReplacement {
        public TokenReplacement(String tokenStart, String tokenEnd, String newTokenStart, String newTokenEnd, boolean rec) {
            super(tokenStart, tokenEnd, s -> String.format("%s%s%s", newTokenStart, s, newTokenEnd), rec);
        }

        public TokenReplacement(String tokenStart, String newToken) {
            super(tokenStart, "", s -> String.format("%s", newToken), false);
        }
    }

    public class TokenTagReplacement
    extends TokenReplacement {
        public TokenTagReplacement(String tokenStart, String tokenEnd, String newTag, boolean rec) {
            super(tokenStart, tokenEnd, "<" + newTag + ">", "</" + newTag + ">", rec);
        }
    }
}

