/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.gendoc.out.write;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import net.edgemind.ibee.gendoc.Item;
import net.edgemind.ibee.gendoc.ItemFormat;
import net.edgemind.ibee.gendoc.ItemFormatConverter;
import net.edgemind.ibee.gendoc.ItemReplacer;
import net.edgemind.ibee.gendoc.ItemRepo;
import net.edgemind.ibee.gendoc.LogUtil;
import net.edgemind.ibee.gendoc.common.DirReplication;
import net.edgemind.ibee.gendoc.common.Replication;
import net.edgemind.ibee.gendoc.out.write.ItemWriterConfig;
import net.edgemind.ibee.util.file.FileUtil;

public class ItemWriter {
    private ItemRepo repo;
    private Writer writer;
    private File baseDir;
    private ItemFormatConverter formatConverter = new ItemFormatConverter();
    String targetFormat;
    private ItemWriterConfig genCfg;

    public ItemWriter(ItemRepo repo) {
        this.repo = repo;
    }

    public void generate(ItemWriterConfig genCfg) throws IOException {
        this.genCfg = genCfg;
        this.baseDir = genCfg.getOutDir();
        if (!this.baseDir.exists()) {
            FileUtil.createDir((File)this.baseDir);
        }
        this.targetFormat = ItemFormat.fromString(genCfg.getFormat());
        ItemWriterConfig.ItemConfig itemCfg = genCfg.getItemConfigs();
        if (itemCfg != null) {
            String id = itemCfg.getId();
            this.repo.printIds();
            Item item = this.repo.findItem(id);
            if (item == null) {
                throw new RuntimeException("HTML GEN: No Item ID='" + id + "' found.");
            }
            String filename = genCfg.getFile();
            File outFile = new File(filename);
            if (!outFile.isAbsolute()) {
                outFile = new File(this.baseDir, outFile.getPath());
            }
            this.writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(outFile)));
            this.generate(item, itemCfg, 1);
            this.writer.close();
        }
        this.replicateFiles();
    }

    private void generate(Item item, ItemWriterConfig.ItemConfig cfg, int depth) throws IOException {
        String content = this.getItemContent(item);
        this.writeln(content);
    }

    private String getContentInTargetFormat(String content, String format) {
        return this.formatConverter.getContentInTargetFormat(content, format, this.targetFormat);
    }

    private String getItemContent(Item item) {
        ItemReplacer replacer = new ItemReplacer(this.repo, this.targetFormat);
        replacer.setResolve(true);
        return replacer.getContent(item, 0);
    }

    private void replicateFiles() throws IOException {
        for (Replication repl : this.genCfg.getReplications()) {
            if (!(repl instanceof DirReplication)) continue;
            DirReplication dirRepl = (DirReplication)repl;
            this.replicateDir(dirRepl.getFrom(), dirRepl.getTo());
        }
    }

    private void replicateDir(File from, File to) throws IOException {
        if (FileUtil.copyFileOrDir((String)from.getAbsolutePath(), (String)to.getAbsolutePath())) {
            LogUtil.log(String.format("Copy %s to %s", from.getAbsolutePath(), to.getAbsolutePath()));
        } else {
            LogUtil.log(String.format("Error: Copy %s to %s", from.getAbsolutePath(), to.getAbsolutePath()));
        }
    }

    private void writeln(String s) throws IOException {
        this.write(s + "\n");
    }

    private void write(String s) throws IOException {
        this.writer.append(s);
    }
}

