/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.gendoc.pdf;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import net.edgemind.ibee.gendoc.DocUtil;
import net.edgemind.ibee.gendoc.Item;
import net.edgemind.ibee.gendoc.ItemReplacer;
import net.edgemind.ibee.gendoc.ItemRepo;
import net.edgemind.ibee.gendoc.LogUtil;
import net.edgemind.ibee.gendoc.org.OrgExtractorConfig;
import net.edgemind.ibee.gendoc.pdf.OrgToPdfGeneratorConfig;
import net.edgemind.ibee.gendoc.pdf.StreamReader;
import net.edgemind.ibee.util.file.FileUtil;
import net.edgemind.ibee.util.system.CygwinUtil;
import net.edgemind.ibee.util.system.EnvUtil;
import net.edgemind.ibee.util.system.SystemUtil;

public class OrgToPdfGenerator {
    private ItemRepo repo;
    private Writer writer;
    private File orgFile;
    private File pdfOut;
    private File initEl;
    private File baseDir;
    private ItemReplacer replacer;

    public OrgToPdfGenerator(ItemRepo repo) {
        this.repo = repo;
        this.replacer = new ItemReplacer(repo, "orgMode");
        this.replacer.setWithChilds(false);
        this.replacer.setResolve(true);
    }

    public void generate(OrgToPdfGeneratorConfig genCfg) throws IOException, InterruptedException {
        boolean createOrg;
        boolean inputOrgProvided = genCfg.getOrgFile() != null;
        boolean bl = createOrg = genCfg.getCreateOrg() != null;
        if (inputOrgProvided && createOrg) {
            throw new RuntimeException("Cannot generate org: 'create-org' and 'orgfile' tags are both provided. Choose for one instruction only.");
        }
        if (!inputOrgProvided && !createOrg) {
            throw new RuntimeException("Cannot generate org: missing 'create-org' or 'orgfile' tag. Choose an instruction.");
        }
        if (createOrg) {
            File tempFolder = new File(FileUtil.getTempDir(), "org");
            this.replicateImgDirs(tempFolder, genCfg);
            File targetOrgFile = this.createOrg(tempFolder, genCfg);
            this.generatePdf(targetOrgFile, genCfg);
        } else if (inputOrgProvided) {
            this.generatePdf(genCfg.getOrgFile(), genCfg);
        }
    }

    private void replicateImgDirs(File tempFolder, OrgToPdfGeneratorConfig genCfg) throws IOException {
        OrgToPdfGeneratorConfig.CreateOrg autoGen = genCfg.getCreateOrg();
        for (File dir : autoGen.getImgDirs()) {
            this.replicateDirIfExists(dir, tempFolder);
        }
    }

    private void replicateDirIfExists(File from, File to) throws IOException {
        if (from.exists()) {
            if (FileUtil.copyFileOrDir((String)from.getAbsolutePath(), (String)to.getAbsolutePath())) {
                LogUtil.log(String.format("Copy %s to %s", from.getAbsolutePath(), to.getAbsolutePath()));
            } else {
                LogUtil.log(String.format("Error: Copy %s to %s", from.getAbsolutePath(), to.getAbsolutePath()));
            }
        }
    }

    public File createOrg(File tempFolder, OrgToPdfGeneratorConfig genCfg) throws IOException {
        tempFolder.mkdir();
        File targetOrgFile = new File(tempFolder, "target.org");
        FileUtil.createDir((File)targetOrgFile.getParentFile());
        LogUtil.log(String.format("Generate Target Org %s", targetOrgFile.getAbsolutePath()));
        this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(targetOrgFile), Charset.forName("UTF-8")));
        OrgToPdfGeneratorConfig.CreateOrg autoGen = genCfg.getCreateOrg();
        if (autoGen != null) {
            OrgToPdfGeneratorConfig.Header header = autoGen.getHeader();
            if (header != null) {
                this.genHeader(header);
            }
            this.genAuto(autoGen);
        }
        this.writer.close();
        return targetOrgFile;
    }

    private void genHeader(OrgToPdfGeneratorConfig.Header header) throws IOException {
        String itemId = header.getId();
        boolean rec = header.isRecursive();
        Item item = this.repo.findItem(itemId);
        if (item == null) {
            throw new RuntimeException(String.format("Cannot find org header item '%s'", itemId));
        }
        this.genHeader(item, rec);
    }

    private void genHeader(Item item, boolean rec) throws IOException {
        String content = this.getContentInOrgFormat(item);
        this.writeln(content);
        if (rec) {
            for (Item child : item.getChilds()) {
                this.genHeader(child, rec);
            }
        }
    }

    private void genAuto(OrgToPdfGeneratorConfig.CreateOrg autoGen) throws IOException {
        for (Item item : this.repo.getAllItems()) {
            if (!autoGen.getLevels().contains(item.getLevel()) || !this.checkNamespace(item, autoGen)) continue;
            OrgExtractorConfig.ItemConfig itemCfg = new OrgExtractorConfig.ItemConfig();
            String id = item.getQid();
            id = DocUtil.normalizeId(id);
            itemCfg.setId(id);
            itemCfg.setRecursive(autoGen.isRecursive());
            itemCfg.setTitle(item.getTitle());
            this.generateTargetOrg(item, itemCfg, 1);
        }
    }

    private boolean checkNamespace(Item item, OrgToPdfGeneratorConfig.CreateOrg autoGen) {
        String requiredNs = autoGen.getNamespace();
        return DocUtil.checkNamespace(item, requiredNs);
    }

    private void generateTargetOrg(Item item, OrgExtractorConfig.ItemConfig itemCfg, int depth) throws IOException {
        int i = 0;
        while (i < depth) {
            this.write("*");
            ++i;
        }
        if (depth > 0) {
            this.write(" ");
        }
        String title = item.getTitle();
        this.writeln(title);
        String content = this.getContentInOrgFormat(item);
        this.writeln(content);
        if (itemCfg.isRecursive()) {
            for (Item child : item.getChilds()) {
                this.generateTargetOrg(child, itemCfg, depth + 1);
            }
        }
    }

    private String getContentInOrgFormat(Item item) {
        String format = item.getFormat();
        if (format.equals("orgMode")) {
            return this.replacer.getContent(item, 0);
        }
        LogUtil.warning(String.format("Target Org Generation: Cannot treat item %s in %s format", item.getId(), item.getFormat()));
        return "";
    }

    private void writeln(String s) throws IOException {
        this.write(s);
        this.write("\n");
    }

    private void write(String s) throws IOException {
        this.writer.write(s);
    }

    public void generatePdf(File targetOrg, OrgToPdfGeneratorConfig genCfg) throws IOException, InterruptedException {
        this.orgFile = targetOrg;
        this.pdfOut = genCfg.getPdfOut();
        this.initEl = genCfg.getInitEl();
        String emacsProgramm = "emacs";
        String emacsProgrammEnv = EnvUtil.getEnv((String)"emacs.bin", (boolean)true);
        if (emacsProgrammEnv != null && emacsProgrammEnv.length() > 0) {
            emacsProgramm = emacsProgrammEnv;
        }
        String initElPath = CygwinUtil.cygpath((String)this.initEl.getAbsolutePath());
        emacsProgramm = CygwinUtil.cygpath((String)emacsProgramm);
        String orgFilePath = CygwinUtil.cygpath((String)this.orgFile.getAbsolutePath());
        String cmd = String.format("%s --batch --load %s %s -f org-latex-export-to-pdf", emacsProgramm, initElPath, orgFilePath);
        ArrayList<String> args = new ArrayList<String>();
        if (SystemUtil.isWindows()) {
            args.add("cmd.exe");
            args.add("/c");
        } else {
            args.add("sh");
            args.add("-c");
        }
        args.add(cmd);
        Process process = Runtime.getRuntime().exec(args.toArray(new String[args.size()]));
        StreamReader streamGobbler = new StreamReader(process.getInputStream(), System.out::println);
        Executors.newSingleThreadExecutor().submit(streamGobbler);
        StreamReader streamGobblerErr = new StreamReader(process.getErrorStream(), System.err::println);
        Executors.newSingleThreadExecutor().submit(streamGobblerErr);
        int exitCode = 0;
        try {
            exitCode = process.waitFor();
            process.exitValue();
            if (exitCode != 0) {
                throw new RuntimeException(String.format("Exit code of cmd '%s' was %d", cmd, exitCode));
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        File pdfFile = FileUtil.replaceExtension((File)this.orgFile, (String)"pdf");
        this.baseDir = this.pdfOut.getAbsoluteFile().getParentFile();
        if (!this.baseDir.exists()) {
            FileUtil.createDir((File)this.baseDir);
        }
        LogUtil.log(String.format("Copy file %s to %s", pdfFile.getAbsolutePath(), this.pdfOut.getAbsolutePath()));
        FileUtil.copyFile((File)pdfFile, (File)this.pdfOut);
        LogUtil.log(String.format("Delete file %s", pdfFile.getAbsolutePath()));
        FileUtil.deleteFile((File)pdfFile);
    }
}

