/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.app;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.edgemind.ibee.core.app.Event;
import net.edgemind.ibee.core.app.EventListener;
import net.edgemind.ibee.core.app.IApp;
import net.edgemind.ibee.core.app.IPart;
import net.edgemind.ibee.core.app.PartCreatedEvent;
import net.edgemind.ibee.core.context.Context;
import net.edgemind.ibee.core.context.IContext;
import net.edgemind.ibee.core.log.LogLevel;
import net.edgemind.ibee.core.log.LogUtil;

public abstract class Part
implements IPart {
    private IPart parent;
    private List<IPart> parts = new ArrayList<IPart>();
    private Map<Class, List<EventListener>> eventListeners;
    private IContext context = this.createContext();

    public abstract void refreshPart();

    public abstract boolean refreshRequired();

    protected IContext createContext() {
        return new Context();
    }

    @Override
    public List<IPart> getParts() {
        return this.parts;
    }

    @Override
    public void addPart(IPart part) {
        if (!this.parts.contains(part)) {
            this.parts.add(part);
            ((Part)part).setParent(this);
            ((Part)part).setContext(this.getContext());
            this.getApp().fireEvent(new PartCreatedEvent(part));
        }
    }

    @Override
    public void removePart(IPart part) {
        this.parts.remove(part);
    }

    public void setParent(IPart parent) {
        this.parent = parent;
    }

    public void setContext(IContext context) {
        this.context = context;
    }

    @Override
    public IApp getApp() {
        if (this instanceof IApp) {
            return (IApp)((Object)this);
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.getApp();
    }

    @Override
    public IContext getContext() {
        return this.context;
    }

    @Override
    public synchronized void refresh() {
        this.refresh(false);
    }

    @Override
    public synchronized void refresh(boolean force) {
        if (force || this.refreshRequired()) {
            this.refreshPart();
        }
        for (IPart part : this.parts) {
            part.refresh(force);
        }
    }

    @Override
    public IPart getParent() {
        return this.parent;
    }

    @Override
    public <T extends Event> void addEventListener(Class<T> type, EventListener<T> listener) {
        List<EventListener> listeners;
        if (this.eventListeners == null) {
            this.eventListeners = new HashMap<Class, List<EventListener>>();
        }
        if ((listeners = this.eventListeners.get(type)) == null) {
            listeners = new ArrayList<EventListener>();
            this.eventListeners.put(type, listeners);
        }
        listeners.add(listener);
    }

    @Override
    public void fireEvent(Event event) {
        LogUtil.log("[" + this.getId() + "] fire event " + event.getId(), LogLevel.DEBUG);
        if (this.eventListeners == null) {
            return;
        }
        List<EventListener> listeners = this.eventListeners.get(event.getClass());
        if (listeners == null) {
            return;
        }
        for (EventListener listener : listeners) {
            listener.handleEvent(event);
        }
        if (this.parent != null) {
            this.parent.fireEvent(event);
        }
    }

    @Override
    public void removeEventListener(String event, EventListener listener) {
        if (this.eventListeners == null) {
            return;
        }
        List<EventListener> listeners = this.eventListeners.get(event);
        if (listeners == null) {
            return;
        }
        listeners.remove(listener);
    }

    @Override
    public void setContextValue(String key, Object value) {
        this.getContext().setValue(key, value);
    }

    @Override
    public Object getValue(String key) {
        return this.getContext().getValue(key);
    }

    @Override
    public IPart getPart(String id) {
        if (this.getId().equals(id)) {
            return this;
        }
        for (IPart part : this.parts) {
            IPart test = part.getPart(id);
            if (test == null) continue;
            return test;
        }
        return null;
    }

    @Override
    public IPart findPart(String id) {
        return this.getApp().getPart(id);
    }
}

