/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.command;

import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.core.command.ExecutionException;
import net.edgemind.ibee.core.command.IUndoRedoCommand;
import net.edgemind.ibee.core.log.LogUtil;

public class CommandStack {
    protected List<IUndoRedoCommand> stack = new ArrayList<IUndoRedoCommand>();
    protected IUndoRedoCommand ongoingCmd;
    protected int currentIndex = -1;

    public void undoWithoutError() {
        try {
            this.undo();
        }
        catch (ExecutionException e) {
            LogUtil.log(e);
        }
    }

    public void undo() throws ExecutionException {
        if (this.currentIndex == -1) {
            return;
        }
        IUndoRedoCommand cmd = this.stack.get(this.currentIndex);
        cmd.undo();
        --this.currentIndex;
    }

    public void redoWithoutError() {
        try {
            this.redo();
        }
        catch (ExecutionException e) {
            LogUtil.log(e);
        }
    }

    public void redo() throws ExecutionException {
        int lastIndex = this.stack.size() - 1;
        if (this.currentIndex == lastIndex) {
            return;
        }
        IUndoRedoCommand cmd = this.stack.get(this.currentIndex + 1);
        cmd.redo();
        ++this.currentIndex;
    }

    public void executeWithoutError(IUndoRedoCommand cmd) {
        try {
            this.execute(cmd);
        }
        catch (ExecutionException e) {
            LogUtil.log(e);
        }
    }

    public void execute(IUndoRedoCommand cmd) throws ExecutionException {
        int lastIndex = this.stack.size() - 1;
        if (this.currentIndex < lastIndex) {
            int i = 0;
            while (i < lastIndex - this.currentIndex) {
                this.stack.remove(this.stack.size() - 1);
                ++i;
            }
        }
        try {
            if (this.ongoingCmd != null) {
                cmd.execute();
            } else {
                this.ongoingCmd = cmd;
                cmd.execute();
                this.addCommand(cmd);
            }
        }
        finally {
            this.ongoingCmd = null;
        }
    }

    public boolean addCommand(IUndoRedoCommand cmd) {
        if (!cmd.isEmpty()) {
            this.stack.add(cmd);
            ++this.currentIndex;
            return true;
        }
        return false;
    }

    public int getSize() {
        return this.stack.size();
    }

    public List<IUndoRedoCommand> getStack() {
        return this.stack;
    }

    public int getIndex() {
        return this.currentIndex;
    }

    public void clear() {
        if (this.stack == null) {
            return;
        }
        this.stack.clear();
        this.currentIndex = -1;
    }
}

