/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.command;

import net.edgemind.ibee.core.command.CommandFactoryRegistry;
import net.edgemind.ibee.core.command.HandlerRegistry;
import net.edgemind.ibee.core.command.ICommandHandler;
import net.edgemind.ibee.core.command.ICommandHandlerFactory;
import net.edgemind.ibee.core.command.IHandledCommand;
import net.edgemind.ibee.core.context.Context;
import net.edgemind.ibee.core.context.IContext;
import net.edgemind.ibee.core.log.LogLevel;
import net.edgemind.ibee.core.log.LogUtil;

public abstract class HandledCommand
implements IHandledCommand {
    private static final long serialVersionUID = 1L;
    private IContext context = new Context();

    public IContext getContext() {
        return this.context;
    }

    public void setContext(IContext context) {
        this.context = context;
    }

    @Override
    public final void execute() {
        ICommandHandler handler = HandlerRegistry.getHandler(this.getClass());
        if (handler != null) {
            handler.execute(this);
            return;
        }
        String cmdId = this.getId();
        boolean handled = false;
        for (ICommandHandlerFactory factory : CommandFactoryRegistry.getFactories()) {
            if (!factory.canHandle(this)) continue;
            handled = true;
            handler = factory.createHandler(this);
            if (handler == null) break;
            handler.execute(this);
            break;
        }
        if (!handled) {
            LogUtil.log("command '" + cmdId + "' has no handler", LogLevel.ERROR);
        }
    }
}

