/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.command;

import java.util.HashMap;
import java.util.Map;
import net.edgemind.ibee.core.command.ICommand;
import net.edgemind.ibee.core.command.ICommandHandler;
import net.edgemind.ibee.core.exception.IbeeException;

public class HandlerRegistry {
    private static Map<Class, ICommandHandler> map = new HashMap<Class, ICommandHandler>();

    public static <T extends ICommand> void setHandler(Class<T> clazz, ICommandHandler<T> handler) {
        map.put(clazz, handler);
    }

    public static <T extends ICommand> ICommandHandler<T> getHandler(Class<T> clazz) {
        return map.get(clazz);
    }

    public static void handle(ICommand command) {
        ICommandHandler<?> handler = HandlerRegistry.getHandler(command.getClass());
        if (handler == null) {
            throw new IbeeException("no handler for class " + command.getClass().getName());
        }
        handler.execute(command);
    }
}

