/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.edgemind.ibee.core.context.ContextValueChangedEvent;
import net.edgemind.ibee.core.context.IContext;
import net.edgemind.ibee.core.context.IContextChangedListener;

public class Context
implements IContext {
    private Map<String, Object> values = new HashMap<String, Object>();
    private IContext parent;
    private String name;
    private Map<String, List<IContextChangedListener>> listener = new HashMap<String, List<IContextChangedListener>>();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public <K, V extends K> void setValue(Class<K> clazz, V value) {
        this.setValue(clazz.getName(), value);
    }

    @Override
    public <T> void setValue(String key, T value) {
        String v2;
        String v1;
        Object oldValue = this.values.get(key);
        if (oldValue == null && value == null) {
            return;
        }
        if (oldValue != null && value != null && (value instanceof String ? (v1 = (String)oldValue).equals(v2 = (String)value) : oldValue == value)) {
            return;
        }
        this.values.put(key, value);
        List<IContextChangedListener> list = this.listener.get(key);
        if (list != null) {
            for (IContextChangedListener l : list) {
                l.contextChanged(new ContextValueChangedEvent<Object>(key, oldValue, value));
            }
        }
    }

    @Override
    public void setParent(IContext parent) {
        this.parent = parent;
    }

    @Override
    public <T> T getValue(Class<T> clazz) {
        return this.getValue(clazz.getName(), clazz);
    }

    @Override
    public Object getValue(String key) {
        Object obj = this.values.get(key);
        if (obj == null && this.parent != null) {
            return this.parent.getValue(key);
        }
        return obj;
    }

    @Override
    public <T> void addListener(String key, IContextChangedListener<T> l) {
        List<IContextChangedListener> list = this.listener.get(key);
        if (list == null) {
            list = new ArrayList<IContextChangedListener>();
            this.listener.put(key, list);
        }
        list.add(l);
    }

    public <T> void removeListener(IContextChangedListener<T> l) {
        for (String key : new ArrayList<String>(this.listener.keySet())) {
            IContextChangedListener next = (IContextChangedListener)((Object)this.listener.get(key));
            if (next != l) continue;
            this.listener.remove(key);
        }
    }

    @Override
    public <T> T getValue(String key, Class<T> clazz) {
        Object obj = this.getValue(key);
        if (obj == null) {
            return null;
        }
        if (clazz.isAssignableFrom(obj.getClass())) {
            return (T)obj;
        }
        return null;
    }
}

