/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.edgemind.ibee.core.context.ContextInfo;
import net.edgemind.ibee.core.context.IContext;
import net.edgemind.ibee.core.log.LogUtil;

public class ContextStack {
    private static Map<Thread, ContextStack> contextStacks = new HashMap<Thread, ContextStack>();
    private static Map<ThreadGroup, ContextStack> contextStackGroups = new HashMap<ThreadGroup, ContextStack>();
    private ContextInfo contextStackHead = null;

    public static <T> T getCurrentContextValue(String key, Class<T> clazz) {
        IContext context = ContextStack.getCurrentContext();
        if (context != null) {
            return context.getValue(key, clazz);
        }
        return null;
    }

    public static <T> T getCurrentContextValue(Class<T> key) {
        IContext context = ContextStack.getCurrentContext();
        if (context != null) {
            return context.getValue(key);
        }
        return null;
    }

    public static <T> void setCurrentContextValue(Class<T> key, T value) {
        IContext context = ContextStack.getCurrentContext();
        if (context != null) {
            context.setValue(key, value);
        }
    }

    public static IContext getCurrentContext() {
        ContextInfo context = ContextStack.getCurrentContextInfo();
        return context != null ? context.getContext() : null;
    }

    public static ContextStack getCurrentContextStack() {
        return ContextStack.getContextStack(null, false);
    }

    public static ContextStack getCurrentContextStack(boolean create) {
        return ContextStack.getContextStack(null, create);
    }

    public static ContextStack getContextStack(Thread thread) {
        return ContextStack.getContextStack(thread, false);
    }

    public static ContextStack getContextStack(Thread thread, boolean create) {
        ContextStack stack;
        if (thread == null) {
            thread = Thread.currentThread();
        }
        if ((stack = contextStacks.get(thread)) == null) {
            if (create) {
                stack = new ContextStack();
                contextStacks.put(thread, stack);
                ThreadGroup threadGroup = thread.getThreadGroup();
                if (!contextStackGroups.containsKey(threadGroup)) {
                    contextStackGroups.put(threadGroup, stack);
                }
            } else {
                ThreadGroup threadGroup = thread.getThreadGroup();
                if (contextStackGroups.containsKey(threadGroup)) {
                    stack = contextStackGroups.get(threadGroup);
                }
            }
        }
        return stack;
    }

    public static ContextInfo appendContext(String name) {
        return ContextStack.createContext(name, null);
    }

    public static ContextInfo createContext(String name, ContextInfo branchPoint) {
        ContextStack stack = ContextStack.getCurrentContextStack(true);
        ContextInfo context = new ContextInfo();
        context.setName(name);
        ContextInfo parentContext = null;
        if (branchPoint != null) {
            if (!stack.isEmpty() && stack.getHead() != branchPoint) {
                LogUtil.error(String.format("Cannot branch context '%s' from parent context '%s': corresponding thread has different parent context '%s'", name, branchPoint.getName(), stack.getHead().getName()));
                parentContext = branchPoint;
            } else {
                parentContext = branchPoint;
            }
        } else if (!stack.isEmpty()) {
            parentContext = stack.getHead();
        }
        context.setParent(parentContext);
        stack.setHead(context);
        return context;
    }

    public static ContextInfo popContext() {
        ContextStack stack = ContextStack.getCurrentContextStack(false);
        ContextInfo context = null;
        if (stack != null) {
            context = stack.pop();
            if (stack.getHead() == null) {
                ContextStack.removeCurrentContextStack();
            }
        }
        return context;
    }

    private static ContextStack removeCurrentContextStack() {
        Thread thread = Thread.currentThread();
        return contextStacks.remove(thread);
    }

    public static ContextInfo getCurrentContextInfo() {
        ContextStack stack = ContextStack.getCurrentContextStack(false);
        if (stack != null) {
            return stack.getHead();
        }
        return null;
    }

    public List<ContextInfo> getContextInfos() {
        ArrayList<ContextInfo> res = new ArrayList<ContextInfo>();
        ContextInfo tmp = this.contextStackHead;
        while (tmp != null) {
            res.add(0, tmp);
            tmp = tmp.getParent();
        }
        return res;
    }

    public boolean isEmpty() {
        return this.contextStackHead == null;
    }

    public int getSize() {
        int cnt = 0;
        ContextInfo tmp = this.contextStackHead;
        while (tmp != null) {
            ++cnt;
            tmp = tmp.getParent();
        }
        return cnt;
    }

    public ContextInfo pop() {
        ContextInfo stack = this.contextStackHead;
        if (this.contextStackHead != null) {
            this.contextStackHead = this.contextStackHead.getParent();
        }
        return stack;
    }

    public void setHead(ContextInfo context) {
        this.contextStackHead = context;
    }

    public void add(ContextInfo context) {
        if (this.contextStackHead != null) {
            context.setParent(this.contextStackHead);
        }
        this.setHead(context);
    }

    public ContextInfo getHead() {
        return this.contextStackHead;
    }
}

