/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.diagram;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jsinterop.annotations.JsType;
import net.edgemind.ibee.core.diagram.Group;
import net.edgemind.ibee.util.math.Frame;

@JsType(namespace="ui")
public class Diagram
implements Serializable {
    private Frame lastFrame;
    private static final long serialVersionUID = 1L;
    private List<Group> groups;
    private Map<String, Object> map = new HashMap<String, Object>();

    public void addGroup(Group g) {
        if (this.groups == null) {
            this.groups = new ArrayList<Group>();
        }
        this.groups.add(g);
    }

    public List<Group> getGroups() {
        if (this.groups == null) {
            return new ArrayList<Group>();
        }
        return this.groups;
    }

    public Frame getSize(boolean refresh) {
        if (!refresh && this.lastFrame != null) {
            return this.lastFrame;
        }
        Frame frame = null;
        if (this.groups != null) {
            for (Group group : this.groups) {
                Frame other = group.getSize();
                if (frame == null) {
                    frame = other;
                    continue;
                }
                if (other == null) continue;
                frame.expand(other);
            }
        }
        if (frame == null) {
            frame = new Frame();
        }
        this.lastFrame = frame;
        return frame;
    }

    public void setSize(Frame frame) {
        this.lastFrame = frame;
    }

    public Object getData(String key) {
        return this.map.get(key);
    }

    public void setData(String key, Object value) {
        this.map.put(key, value);
    }
}

