/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.diagram;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import jsinterop.annotations.JsType;
import net.edgemind.ibee.core.command.ICommand;
import net.edgemind.ibee.core.diagram.DElement;
import net.edgemind.ibee.core.diagram.Symbol;
import net.edgemind.ibee.util.math.Frame;
import net.edgemind.ibee.util.math.Point2D;

@JsType(namespace="ui")
public class Node
extends DElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Symbol symbol;
    private double x;
    private double y;
    private double w;
    private double h;
    private Map<String, ICommand> actions = null;

    public void setSymbol(Symbol s) {
        this.symbol = s;
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getX() {
        return this.x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getY() {
        return this.y;
    }

    public void setWidth(double w) {
        this.w = w;
    }

    public double getWidth() {
        return this.w;
    }

    public void setHeight(double h) {
        this.h = h;
    }

    public double getHeight() {
        return this.h;
    }

    public Frame getFrame() {
        return new Frame(this.x, this.y, this.w, this.h);
    }

    public Frame getSize() {
        Frame frame = new Frame(this.x, this.y, this.w, this.h);
        return frame;
    }

    public Point2D getCenter() {
        return new Point2D(this.x + this.w / 2.0, this.y + this.h / 2.0);
    }

    public Point2D getNorth() {
        return new Point2D(this.x + this.w / 2.0, this.y);
    }

    public Point2D getSouth() {
        return new Point2D(this.x + this.w / 2.0, this.y + this.h);
    }

    public Point2D getWest() {
        return new Point2D(this.x, this.y + this.h / 2.0);
    }

    public Point2D getEast() {
        return new Point2D(this.x + this.w, this.y + this.h / 2.0);
    }

    public Point2D getNorthWest() {
        return new Point2D(this.x, this.y);
    }

    public Point2D getNorthEeast() {
        return new Point2D(this.x + this.w, this.y);
    }

    public Point2D getSouthWest() {
        return new Point2D(this.x, this.y + this.h);
    }

    public Point2D getSouthEeast() {
        return new Point2D(this.x + this.w, this.y + this.h);
    }

    public boolean containsPoint(double x, double y) {
        return x > this.getX() && x < this.getX() + this.getWidth() && y > this.getY() && y < this.getY() + this.getHeight();
    }

    public void setAction(String action, ICommand cmd) {
        if (this.actions == null) {
            this.actions = new HashMap<String, ICommand>();
        }
        this.actions.put(action, cmd);
    }

    public ICommand getAction(String action) {
        if (this.actions == null) {
            return null;
        }
        return this.actions.get(action);
    }

    public Node clone() {
        Node clone = new Node();
        clone.setBackColor(this.backColor);
        clone.setForeColor(this.foreColor);
        clone.setSymbol(this.symbol);
        clone.setX(this.getX());
        clone.setY(this.getY());
        clone.setWidth(this.getWidth());
        clone.setHeight(this.getHeight());
        clone.setElement(this.getElement());
        clone.setDeltaScreenX(this.getDeltaScreenX());
        clone.setDeltaScreenY(this.getDeltaScreenY());
        clone.setPositioning(this.getPositioning());
        return clone;
    }
}

